/*
 * Decompiled with CFR 0.152.
 */
package squeek.tictooltips.helpers;

import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.common.TContent;
import tconstruct.items.tools.Excavator;
import tconstruct.items.tools.Hammer;
import tconstruct.items.tools.LumberAxe;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.HarvestTool;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;

public class ToolHelper {
    public static boolean harvestToolsHaveVariableSpeedCalculations = false;
    private static Method harvestToolStoneboundModifier = null;
    private static Method harvestToolBreakSpeedModifier = null;

    public static void init() {
        try {
            harvestToolStoneboundModifier = HarvestTool.class.getDeclaredMethod("stoneboundModifier", new Class[0]);
            harvestToolBreakSpeedModifier = HarvestTool.class.getDeclaredMethod("breakSpeedModifier", new Class[0]);
            harvestToolsHaveVariableSpeedCalculations = true;
        }
        catch (Exception e) {
            harvestToolsHaveVariableSpeedCalculations = false;
        }
    }

    public static boolean hasToolTag(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("InfiTool");
    }

    public static NBTTagCompound getToolTag(ItemStack tool) {
        NBTTagCompound tag = tool.func_77978_p().func_74775_l("InfiTool");
        return tag;
    }

    public static ToolMaterial getHeadMaterial(NBTTagCompound toolTag) {
        ToolMaterial mat = null;
        int matID = toolTag.func_74762_e("Head");
        if (matID >= 0) {
            mat = TConstructRegistry.getMaterial((int)matID);
        }
        return mat;
    }

    public static boolean hasToolCategory(ToolCore tool, String searchCategory) {
        for (String category : tool.toolCategories()) {
            if (!category.equals(searchCategory)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWeaponTool(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "weapon");
    }

    public static boolean isBowTool(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "bow");
    }

    public static boolean isAmmoTool(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "ammo");
    }

    public static boolean isDualHarvestTool(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "dualharvest");
    }

    public static boolean isHarvestTool(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "harvest");
    }

    public static boolean isUtilityTool(ToolCore tool) {
        return ToolHelper.hasToolCategory(tool, "utility");
    }

    public static int getUsedDurability(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("Damage");
    }

    public static int getMaxDurability(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("TotalDurability");
    }

    public static int getEffectiveDurability(NBTTagCompound toolTag) {
        return (int)((float)toolTag.func_74762_e("TotalDurability") * (1.0f + (float)ToolHelper.getReinforcedLevel(toolTag) * 0.1f));
    }

    public static int getReinforcedLevel(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("Unbreaking");
    }

    public static boolean isUnbreakable(NBTTagCompound toolTag) {
        return ToolHelper.getReinforcedLevel(toolTag) >= 10;
    }

    public static float getStonebound(NBTTagCompound toolTag) {
        return toolTag.func_74760_g("Shoddy");
    }

    public static int getRawDamage(ToolCore tool, NBTTagCompound toolTag) {
        int rawDamage = toolTag.func_74762_e("Attack") - tool.getDamageVsEntity(null);
        return rawDamage;
    }

    public static int getDamage(ToolCore tool, NBTTagCompound toolTag) {
        int attack = toolTag.func_74762_e("Attack") + 1;
        attack = (int)((float)attack + ToolHelper.getShoddinessDamageBonus(toolTag));
        if ((attack = (int)((float)attack * tool.getDamageModifier())) < 1) {
            attack = 1;
        }
        return attack;
    }

    public static int[] getSmiteDamageRange(ToolCore tool, NBTTagCompound toolTag) {
        int staticBonus = 0;
        int variableBonus = 0;
        if (tool == TContent.hammer) {
            int level = 2;
            staticBonus += level * 2;
            variableBonus += level * 2 + 1;
        }
        if (toolTag.func_74764_b("ModSmite")) {
            int[] array = toolTag.func_74759_k("ModSmite");
            int base = array[0] / 18;
            staticBonus += 1 + base;
            variableBonus += base + 1;
        }
        return new int[]{staticBonus, staticBonus + variableBonus};
    }

    public static int[] getAntiSpiderDamageRange(ToolCore tool, NBTTagCompound toolTag) {
        int staticBonus = 0;
        int variableBonus = 0;
        if (toolTag.func_74764_b("ModAntiSpider")) {
            int[] array = toolTag.func_74759_k("ModAntiSpider");
            int base = array[0] / 2;
            staticBonus += 1 + base;
            variableBonus += base + 1;
        }
        return new int[]{staticBonus, staticBonus + variableBonus};
    }

    public static int getBurnDuration(ToolCore tool, NBTTagCompound toolTag) {
        int burnDuration = 0;
        if (toolTag.func_74764_b("Fiery")) {
            burnDuration += toolTag.func_74762_e("Fiery") / 5 + 1;
        }
        if (toolTag.func_74767_n("Lava")) {
            burnDuration += 3;
        }
        return burnDuration;
    }

    public static float getChanceToBehead(ToolCore tool, NBTTagCompound toolTag) {
        float chanceToBehead = toolTag.func_74762_e("Beheading");
        if (tool == TContent.cleaver) {
            chanceToBehead += 2.0f;
        }
        return Math.min(1.0f, chanceToBehead /= 10.0f);
    }

    public static float getShoddinessDamageBonus(NBTTagCompound toolTag) {
        return (float)Math.log((float)ToolHelper.getUsedDurability(toolTag) / 72.0f + 1.0f) * -2.0f * ToolHelper.getStonebound(toolTag);
    }

    public static float getMaxShoddinessDamageBonus(NBTTagCompound toolTag) {
        return (float)Math.log((float)ToolHelper.getMaxDurability(toolTag) / 72.0f + 1.0f) * -2.0f * ToolHelper.getStonebound(toolTag);
    }

    public static float getShoddinessModifierConstant(ToolCore tool) {
        float modifierConstant = 72.0f;
        if (tool == null || !(tool instanceof HarvestTool)) {
            return modifierConstant;
        }
        if (harvestToolsHaveVariableSpeedCalculations) {
            try {
                modifierConstant = ((Float)harvestToolStoneboundModifier.invoke((Object)((HarvestTool)tool), new Object[0])).floatValue();
            }
            catch (Exception e) {
                harvestToolsHaveVariableSpeedCalculations = false;
            }
        } else if (tool instanceof Excavator || tool instanceof Hammer) {
            modifierConstant = 216.0f;
        }
        return modifierConstant;
    }

    public static float getShoddinessSpeedBonus(int usedDurability, float shoddiness, float modifierConstant) {
        return (float)Math.log((float)usedDurability / modifierConstant + 1.0f) * 2.0f * shoddiness;
    }

    public static float getShoddinessSpeedBonus(ToolCore tool, NBTTagCompound toolTag) {
        return ToolHelper.getShoddinessSpeedBonus(ToolHelper.getUsedDurability(toolTag), ToolHelper.getStonebound(toolTag), ToolHelper.getShoddinessModifierConstant(tool));
    }

    public static float getMaxShoddinessSpeedBonus(ToolCore tool, NBTTagCompound toolTag) {
        return ToolHelper.getShoddinessSpeedBonus(ToolHelper.getMaxDurability(toolTag), ToolHelper.getStonebound(toolTag), ToolHelper.getShoddinessModifierConstant(tool));
    }

    public static int getDrawSpeed(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("DrawSpeed");
    }

    public static float getArrowSpeedModifier(NBTTagCompound toolTag) {
        return toolTag.func_74760_g("FlightSpeed");
    }

    public static int getAmmoDamage(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("Attack");
    }

    public static float getWeight(NBTTagCompound toolTag) {
        return toolTag.func_74760_g("Mass");
    }

    public static float getAccuracy(NBTTagCompound toolTag) {
        return toolTag.func_74760_g("Accuracy");
    }

    public static float getMiningSpeedModifier(ToolCore tool) {
        float speedModifier = 1.0f;
        if (tool == null || !(tool instanceof HarvestTool)) {
            return speedModifier;
        }
        if (harvestToolsHaveVariableSpeedCalculations) {
            try {
                speedModifier = ((Float)harvestToolBreakSpeedModifier.invoke((Object)((HarvestTool)tool), new Object[0])).floatValue();
            }
            catch (Exception e) {
                harvestToolsHaveVariableSpeedCalculations = false;
            }
        } else if (tool instanceof Excavator || tool instanceof Hammer || tool instanceof LumberAxe) {
            speedModifier = 0.33333334f;
        }
        return speedModifier;
    }

    public static int getPrimaryMiningSpeed(ToolCore tool, NBTTagCompound toolTag) {
        return (int)((float)toolTag.func_74762_e("MiningSpeed") * ToolHelper.getMiningSpeedModifier(tool));
    }

    public static int getSecondaryMiningSpeed(ToolCore tool, NBTTagCompound toolTag) {
        return (int)((float)toolTag.func_74762_e("MiningSpeed2") * ToolHelper.getMiningSpeedModifier(tool));
    }

    public static int getTotalMiningSpeed(ToolCore tool, NBTTagCompound toolTag) {
        int mineSpeed = toolTag.func_74762_e("MiningSpeed");
        int heads = 1;
        if (toolTag.func_74764_b("MiningSpeed2")) {
            mineSpeed += toolTag.func_74762_e("MiningSpeed2");
            ++heads;
        }
        if (toolTag.func_74764_b("MiningSpeedHandle")) {
            mineSpeed += toolTag.func_74762_e("MiningSpeedHandle");
            ++heads;
        }
        if (toolTag.func_74764_b("MiningSpeedExtra")) {
            mineSpeed += toolTag.func_74762_e("MiningSpeedExtra");
            ++heads;
        }
        return (int)((float)mineSpeed / (float)heads * ToolHelper.getMiningSpeedModifier(tool));
    }

    public static int getPrimaryHarvestLevel(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("HarvestLevel");
    }

    public static int getSecondaryHarvestLevel(NBTTagCompound toolTag) {
        return toolTag.func_74762_e("HarvestLevel2");
    }
}

