/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.blocks.logic;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;
import tsteelworks.blocks.logic.DeepTankLogic;
import tsteelworks.blocks.logic.HighOvenDrainLogic;
import tsteelworks.lib.blocks.TSInventoryLogic;

public class TurbineLogic
extends TSInventoryLogic
implements IActiveLogic,
IFacingLogic,
IFluidHandler {
    byte direction;
    int tick;
    public FluidTank tank = new FluidTank(1000);
    boolean active = false;

    public TurbineLogic() {
        super(0);
    }

    public boolean getActive() {
        return this.active && this.tank.getFluidAmount() > 0;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.activateTurbine(this.active);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    void activateTurbine(boolean flag) {
        DeepTankLogic tankcontroller;
        if (this.tank.getFluidAmount() > 0 && (tankcontroller = this.getTankController()) != null) {
            tankcontroller.setTurbineAttached(flag);
        }
    }

    DeepTankLogic getTankController() {
        int x = this.field_70329_l;
        int z = this.field_70327_n;
        switch (this.getRenderDirection()) {
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        TileEntity drainte = this.field_70331_k.func_72796_p(x, this.field_70330_m, z);
        if (drainte instanceof HighOvenDrainLogic && ((HighOvenDrainLogic)this.field_70331_k.func_72796_p(x, this.field_70330_m, z)).getControllerLogicType() == 2) {
            DeepTankLogic tankcontroller = ((HighOvenDrainLogic)this.field_70331_k.func_72796_p(x, this.field_70330_m, z)).getDeepTankController();
            return tankcontroller;
        }
        return null;
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_70316_g() {
        ++this.tick;
        if (this.tick == 60) {
            if (this.getActive()) {
                this.tank.drain(25, true);
            }
            this.tick = 0;
        }
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return null;
    }

    @Override
    public String getDefaultName() {
        return "machines.Turbine";
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!resource.getFluid().equals(FluidRegistry.getFluid((String)"steam"))) {
            return 0;
        }
        int amount = this.tank.fill(resource, doFill);
        if (amount > 0 && doFill) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return amount;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidStack fluid = null;
        if (this.tank.getFluid() != null) {
            fluid = this.tank.getFluid().copy();
        }
        return new FluidTankInfo[]{new FluidTankInfo(fluid, this.tank.getCapacity())};
    }

    public boolean containsFluid() {
        return this.tank.getFluid() != null;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.active = tags.func_74767_n("Active");
        this.direction = tags.func_74771_c("Direction");
        if (tags.func_74767_n("hasFluid")) {
            this.tank.setFluid(new FluidStack(tags.func_74762_e("itemID"), tags.func_74762_e("amount")));
        } else {
            this.tank.setFluid(null);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        tags.func_74757_a("Active", this.active);
        super.func_70310_b(tags);
        tags.func_74774_a("Direction", this.direction);
        FluidStack liquid = this.tank.getFluid();
        tags.func_74757_a("hasFluid", liquid != null);
        if (liquid != null) {
            tags.func_74768_a("itemID", liquid.fluidID);
            tags.func_74768_a("amount", liquid.amount);
        }
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }
}

