/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import squeek.spiceoflife.ModSpiceOfLife;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.network.PacketConfigSync;

public class ModConfig {
    private static Configuration config;
    private static final String COMMENT_SERVER_SIDE_OPTIONS = "These config settings are server-side only\nTheir values will get synced to all clients on the server";
    private static final String CATEGORY_MAIN = " main ";
    private static final String CATEGORY_MAIN_COMMENT = "These config settings are server-side only\nTheir values will get synced to all clients on the server";
    public static boolean FOOD_MODIFIER_ENABLED;
    private static final String FOOD_MODIFIER_ENABLED_NAME = "food.modifier.enabled";
    private static final boolean FOOD_MODIFIER_ENABLED_DEFAULT = true;
    private static final String FOOD_MODIFIER_ENABLED_COMMENT = "If false, disables the entire diminishing returns part of the mod\nSet this to false if you only want the client-side tooltip/HUD additions";
    private static final String CATEGORY_SERVER = "server";
    private static final String CATEGORY_SERVER_COMMENT = "These config settings are server-side only\nTheir values will get synced to all clients on the server";
    public static int FOOD_HISTORY_LENGTH;
    private static final String FOOD_HISTORY_LENGTH_NAME = "food.history.length";
    private static final int FOOD_HISTORY_LENGTH_DEFAULT = 12;
    private static final String FOOD_HISTORY_LENGTH_COMMENT = "The maximum amount of eaten foods stored in the history at a time";
    public static boolean FOOD_HISTORY_PERSISTS_THROUGH_DEATH;
    private static final String FOOD_HISTORY_PERSISTS_THROUGH_DEATH_NAME = "food.history.persists.through.death";
    private static final boolean FOOD_HISTORY_PERSISTS_THROUGH_DEATH_DEFAULT = false;
    private static final String FOOD_HISTORY_PERSISTS_THROUGH_DEATH_COMMENT = "If true, food history will not get reset after every death";
    public static int FOOD_EATEN_THRESHOLD;
    private static final String FOOD_EATEN_THRESHOLD_NAME = "new.player.food.eaten.threshold";
    private static final int FOOD_EATEN_THRESHOLD_DEFAULT;
    private static final String FOOD_EATEN_THRESHOLD_COMMENT = "The number of times a new player (by World) needs to eat before this mod has any effect";
    public static boolean CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD;
    private static final String CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD_NAME = "clear.history.after.food.eaten.threshold.reached";
    private static final boolean CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD_DEFAULT = false;
    private static final String CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD_COMMENT = "If true, a player's food history will be empty once they pass the new.player.food.eaten.threshold\nIf false, any food eaten before the threshold is passed will also count after it is passed";
    public static boolean USE_FOOD_GROUPS;
    private static final String USE_FOOD_GROUPS_NAME = "use.food.groups";
    private static final boolean USE_FOOD_GROUPS_DEFAULT = false;
    private static final String USE_FOOD_GROUPS_COMMENT = "See 'foodgroups' settings category";
    public static RoundingMode FOOD_HUNGER_ROUNDING_MODE;
    public static String FOOD_HUNGER_ROUNDING_MODE_STRING;
    private static final String FOOD_HUNGER_ROUNDING_MODE_NAME = "food.hunger.rounding.mode";
    private static final String FOOD_HUNGER_ROUNDING_MODE_DEFAULT = "round";
    private static final String FOOD_HUNGER_ROUNDING_MODE_COMMENT = "Rounding mode used on the hunger value of foods\nValid options: 'round', 'floor', 'ceiling'";
    public static boolean AFFECT_FOOD_SATURATION_MODIFIERS;
    private static final String AFFECT_FOOD_SATURATION_MODIFIERS_NAME = "affect.food.saturation.modifiers";
    private static final boolean AFFECT_FOOD_SATURATION_MODIFIERS_DEFAULT = false;
    private static final String AFFECT_FOOD_SATURATION_MODIFIERS_COMMENT = "If true, foods' saturation modifier will also be multiplied by the nutritional value\nNOTE: Saturation bonuses of foods will automatically decrease as the hunger value of the food decreases\nSetting this to true will make saturation bonuses decrease disproportionately more than hunger values";
    public static boolean AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS;
    private static final String AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS_NAME = "affect.negative.food.saturation.modifiers";
    private static final boolean AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS_DEFAULT = false;
    private static final String AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS_COMMENT = "If true, foods with negative saturation modifiers will be made more negative as nutritional value decreases\nNOTE: affect.food.saturation.modifiers must be true for this to have any affect";
    public static boolean USE_HUNGER_QUEUE;
    private static final String USE_HUNGER_QUEUE_NAME = "use.hunger.restored.for.food.history.length";
    private static final boolean USE_HUNGER_QUEUE_DEFAULT = false;
    private static final String USE_HUNGER_QUEUE_COMMENT = "If true, food.history.length will use amount of hunger restored instead of number of foods eaten for its maximum length\nFor example, a food.history.length length of 12 will store a max of 2 foods that restored 6 hunger each, \n3 foods that restored 4 hunger each, 12 foods that restored 1 hunger each, etc\nNOTE: food.history.length uses hunger units, where 1 hunger unit = 1/2 hunger bar";
    public static String FOOD_MODIFIER_FORMULA;
    private static final String FOOD_MODIFIER_FORMULA_STRING_NAME = "food.modifier.formula";
    private static final String FOOD_MODIFIER_FORMULA_STRING_DEFAULT = "MAX(0, (1 - count/12))^MIN(8, food_hunger_value)";
    private static final String FOOD_MODIFIER_FORMULA_STRING_COMMENT = "Uses the EvalEx expression parser\nSee: https://github.com/uklimaschewski/EvalEx for syntax/function documentation\n\nAvailable variables:\n\tcount : The number of times the food (or its food group) has been eaten within the food history\n\tmax_history_length : The maximum length of the food history (see food.history.length)\n\tcur_history_length : The current length of the food history (<= max_history_length)\n\tfood_hunger_value : The default amount of hunger the food would restore in hunger units (1 hunger unit = 1/2 hunger bar)\n\tfood_saturation_mod : The default saturation modifier of the food\n\tcur_hunger : The current hunger value of the player in hunger units (20 = full)\n\tcur_saturation : The current saturation value of the player\n\ttotal_food_eaten : The all-time total number of times any food has been eaten by the player\n";
    private static final String CATEGORY_CLIENT = "client";
    private static final String CATEGORY_CLIENT_COMMENT = "These config settings are client-side only";
    public static boolean SHOW_FOOD_VALUES_IN_TOOLTIP;
    private static final String SHOW_FOOD_VALUES_IN_TOOLTIP_NAME = "show.food.values.in.tooltip";
    private static final String SHOW_FOOD_VALUES_IN_TOOLTIP_COMMENT = "If true, shows the hunger and saturation values of food in its tooltip while holding SHIFT";
    public static boolean SHOW_SATURATION_OVERLAY;
    private static final String SHOW_SATURATION_OVERLAY_NAME = "show.saturation.hud.overlay";
    private static final String SHOW_SATURATION_OVERLAY_COMMENT = "If true, shows your current saturation level overlayed on the hunger bar";
    public static boolean SHOW_FOOD_VALUES_OVERLAY;
    private static final String SHOW_FOOD_VALUES_OVERLAY_NAME = "show.food.values.hud.overlay";
    private static final String SHOW_FOOD_VALUES_OVERLAY_COMMENT = "If true, shows the hunger (and saturation if show.saturation.hud.overlay is true) that would be restored by food you are currently holding";
    private static final String CATEGORY_FOODGROUPS = "foodgroups";
    private static final String CATEGORY_FOODGROUPS_COMMENT = "These config settings are server-side only\nTheir values will get synced to all clients on the server\nNOTE: Food groups are a work-in-progress; not all features have been implemented and/or tested";

    public static void init(File file) {
        config = new Configuration(file);
        ModConfig.load();
        config.getCategory(CATEGORY_MAIN).setComment("These config settings are server-side only\nTheir values will get synced to all clients on the server");
        FOOD_MODIFIER_ENABLED = config.get(CATEGORY_MAIN, FOOD_MODIFIER_ENABLED_NAME, true, FOOD_MODIFIER_ENABLED_COMMENT).getBoolean(true);
        config.getCategory(CATEGORY_SERVER).setComment("These config settings are server-side only\nTheir values will get synced to all clients on the server");
        Property FOOD_MODIFIER_PROPERTY = config.get(CATEGORY_SERVER, FOOD_MODIFIER_FORMULA_STRING_NAME, FOOD_MODIFIER_FORMULA_STRING_DEFAULT, FOOD_MODIFIER_FORMULA_STRING_COMMENT);
        if (FOOD_MODIFIER_PROPERTY.getString().equals("MAX(0, (1 - count/12))^MAX(0, food_hunger_value-ROUND(MAX(0, 1 - count/12), 0))")) {
            FOOD_MODIFIER_PROPERTY.set(FOOD_MODIFIER_FORMULA_STRING_DEFAULT);
        }
        FOOD_MODIFIER_FORMULA = FOOD_MODIFIER_PROPERTY.getString();
        FOOD_HISTORY_LENGTH = config.get(CATEGORY_SERVER, FOOD_HISTORY_LENGTH_NAME, 12, FOOD_HISTORY_LENGTH_COMMENT).getInt();
        FOOD_HISTORY_PERSISTS_THROUGH_DEATH = config.get(CATEGORY_SERVER, FOOD_HISTORY_PERSISTS_THROUGH_DEATH_NAME, false, FOOD_HISTORY_PERSISTS_THROUGH_DEATH_COMMENT).getBoolean(false);
        FOOD_EATEN_THRESHOLD = config.get(CATEGORY_SERVER, FOOD_EATEN_THRESHOLD_NAME, FOOD_EATEN_THRESHOLD_DEFAULT, FOOD_EATEN_THRESHOLD_COMMENT).getInt();
        CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD = config.get(CATEGORY_SERVER, CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD_NAME, false, CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD_COMMENT).getBoolean(false);
        USE_FOOD_GROUPS = config.get(CATEGORY_SERVER, USE_FOOD_GROUPS_NAME, false, USE_FOOD_GROUPS_COMMENT).getBoolean(false);
        AFFECT_FOOD_SATURATION_MODIFIERS = config.get(CATEGORY_SERVER, AFFECT_FOOD_SATURATION_MODIFIERS_NAME, false, AFFECT_FOOD_SATURATION_MODIFIERS_COMMENT).getBoolean(false);
        AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS = config.get(CATEGORY_SERVER, AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS_NAME, false, AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS_COMMENT).getBoolean(false);
        USE_HUNGER_QUEUE = config.get(CATEGORY_SERVER, USE_HUNGER_QUEUE_NAME, false, USE_HUNGER_QUEUE_COMMENT).getBoolean(false);
        FOOD_HUNGER_ROUNDING_MODE_STRING = config.get(CATEGORY_SERVER, FOOD_HUNGER_ROUNDING_MODE_NAME, FOOD_HUNGER_ROUNDING_MODE_DEFAULT, FOOD_HUNGER_ROUNDING_MODE_COMMENT).getString();
        ModConfig.setRoundingMode();
        config.getCategory(CATEGORY_CLIENT).setComment(CATEGORY_CLIENT_COMMENT);
        SHOW_FOOD_VALUES_IN_TOOLTIP = config.get(CATEGORY_CLIENT, SHOW_FOOD_VALUES_IN_TOOLTIP_NAME, true, SHOW_FOOD_VALUES_IN_TOOLTIP_COMMENT).getBoolean(true);
        SHOW_SATURATION_OVERLAY = config.get(CATEGORY_CLIENT, SHOW_SATURATION_OVERLAY_NAME, true, SHOW_SATURATION_OVERLAY_COMMENT).getBoolean(true);
        SHOW_FOOD_VALUES_OVERLAY = config.get(CATEGORY_CLIENT, SHOW_FOOD_VALUES_OVERLAY_NAME, true, SHOW_FOOD_VALUES_OVERLAY_COMMENT).getBoolean(true);
        config.getCategory(CATEGORY_FOODGROUPS).setComment(CATEGORY_FOODGROUPS_COMMENT);
        ModConfig.writeExampleFoodGroup();
        if (USE_FOOD_GROUPS) {
            ModConfig.loadFoodGroups();
        }
        ModConfig.save();
    }

    public static void loadFoodGroups() {
        ArrayList<String> enabledFoodGroups = new ArrayList<String>();
        ConfigCategory categoryFoodGroups = config.getCategory(CATEGORY_FOODGROUPS);
        for (String configKey : categoryFoodGroups.keySet()) {
            if (!configKey.endsWith(".enabled") || !config.get(CATEGORY_FOODGROUPS, configKey, false).getBoolean(false)) continue;
            enabledFoodGroups.add(configKey.substring(0, configKey.length() - ".enabled".length()));
        }
        for (String foodGroupIdent : enabledFoodGroups) {
            String name = config.get(CATEGORY_FOODGROUPS, foodGroupIdent + ".name", foodGroupIdent).getString();
            int priority = config.get(CATEGORY_FOODGROUPS, foodGroupIdent + ".priority", 0).getInt();
            FoodGroup foodGroup = new FoodGroup(foodGroupIdent, name, priority);
            String[] items = config.get(CATEGORY_FOODGROUPS, foodGroupIdent + ".items", new String[0]).getStringList();
            String[] oredicts = config.get(CATEGORY_FOODGROUPS, foodGroupIdent + ".oredicts", new String[0]).getStringList();
            for (String itemString : items) {
                ModConfig.addItemToFoodGroup(foodGroup, itemString, false);
            }
            for (String oredictString : oredicts) {
                foodGroup.addFood(oredictString, false);
            }
            FoodGroupRegistry.addFoodGroup(foodGroup);
        }
    }

    public static void addItemToFoodGroup(FoodGroup foodGroup, String itemString, boolean isBaseItem) {
        String[] itemStringParts = itemString.split(":");
        if (itemStringParts.length > 0) {
            int itemId = Integer.parseInt(itemStringParts[0]);
            boolean exactMetadata = itemStringParts.length > 1 && itemStringParts[1] != "*";
            int metadata = itemStringParts.length > 1 && exactMetadata ? Integer.parseInt(itemStringParts[1]) : 0;
            foodGroup.addFood(new ItemStack(itemId, 1, metadata), exactMetadata, isBaseItem);
        }
    }

    public static void writeExampleFoodGroup() {
        config.get(CATEGORY_FOODGROUPS, "example.enabled", false);
        config.get(CATEGORY_FOODGROUPS, "example.name", "Example");
        config.get(CATEGORY_FOODGROUPS, "example.priority", 0, "Food can only belong to one food group\nin the case of conflicting food groups, the food group with the highest priority will be selected\nExample: A food group with priority 3 will take precedence over a food group with priority 1");
        config.get(CATEGORY_FOODGROUPS, "example.items", new String[]{"260", "322:0"}, "A list of item IDs in id:meta format\nThis example adds red apples (id 260 with any metadata) and golden apples (id 322 with metadata 0), thereby excluding enchanted golden apples (id 322 with metadata 1)");
        config.get(CATEGORY_FOODGROUPS, "example.oredicts", new String[]{"listAllfruit", "listAllberry"}, "A list of ore dictionary entries\nThis example adds two oredictionary entries created by Pam's HarvestCraft, including all fruit and all berries");
    }

    public static void setRoundingMode() {
        for (RoundingMode roundingMode : RoundingMode.values()) {
            if (!roundingMode.id.equals(FOOD_HUNGER_ROUNDING_MODE_STRING.toLowerCase())) continue;
            FOOD_HUNGER_ROUNDING_MODE = roundingMode;
            break;
        }
        if (FOOD_HUNGER_ROUNDING_MODE == null) {
            ModSpiceOfLife.Log.warning("Rounding mode '" + FOOD_HUNGER_ROUNDING_MODE_STRING + "' not recognized; defaulting to 'round'");
            FOOD_HUNGER_ROUNDING_MODE_STRING = FOOD_HUNGER_ROUNDING_MODE_DEFAULT;
            FOOD_HUNGER_ROUNDING_MODE = RoundingMode.ROUND;
        }
    }

    public static void save() {
        config.save();
    }

    public static void load() {
        config.load();
    }

    public static void pack(DataOutputStream data) throws IOException {
        data.writeBoolean(FOOD_MODIFIER_ENABLED);
        if (FOOD_MODIFIER_ENABLED) {
            data.writeUTF(FOOD_MODIFIER_FORMULA);
            data.writeShort(FOOD_HISTORY_LENGTH);
            data.writeBoolean(FOOD_HISTORY_PERSISTS_THROUGH_DEATH);
            data.writeInt(FOOD_EATEN_THRESHOLD);
            data.writeBoolean(CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD);
            data.writeBoolean(USE_FOOD_GROUPS);
            data.writeBoolean(AFFECT_FOOD_SATURATION_MODIFIERS);
            data.writeBoolean(AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS);
            data.writeBoolean(USE_HUNGER_QUEUE);
            data.writeUTF(FOOD_HUNGER_ROUNDING_MODE_STRING);
        }
    }

    public static void unpack(DataInputStream data, EntityPlayer player) throws IOException {
        FOOD_MODIFIER_ENABLED = data.readBoolean();
        if (FOOD_MODIFIER_ENABLED) {
            FOOD_MODIFIER_FORMULA = data.readUTF();
            FOOD_HISTORY_LENGTH = data.readShort();
            FOOD_HISTORY_PERSISTS_THROUGH_DEATH = data.readBoolean();
            FOOD_EATEN_THRESHOLD = data.readInt();
            CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD = data.readBoolean();
            USE_FOOD_GROUPS = data.readBoolean();
            AFFECT_FOOD_SATURATION_MODIFIERS = data.readBoolean();
            AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS = data.readBoolean();
            USE_HUNGER_QUEUE = data.readBoolean();
            FOOD_HUNGER_ROUNDING_MODE_STRING = data.readUTF();
            ModConfig.setRoundingMode();
            FoodModifier.onFormulaChanged();
            FoodHistory.get(player).onHistoryTypeChanged();
            FoodGroupRegistry.clear();
        }
    }

    public static void sync(EntityPlayer player) {
        PacketDispatcher.sendPacketToPlayer((Packet)new PacketConfigSync().getPacket(), (Player)((Player)player));
    }

    static {
        FOOD_MODIFIER_ENABLED = true;
        FOOD_HISTORY_LENGTH = 12;
        FOOD_HISTORY_PERSISTS_THROUGH_DEATH = false;
        FOOD_EATEN_THRESHOLD = FOOD_EATEN_THRESHOLD_DEFAULT;
        FOOD_EATEN_THRESHOLD_DEFAULT = FOOD_HISTORY_LENGTH / 2;
        CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD = false;
        USE_FOOD_GROUPS = false;
        FOOD_HUNGER_ROUNDING_MODE = null;
        FOOD_HUNGER_ROUNDING_MODE_STRING = FOOD_HUNGER_ROUNDING_MODE_DEFAULT;
        AFFECT_FOOD_SATURATION_MODIFIERS = false;
        AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS = false;
        USE_HUNGER_QUEUE = false;
        FOOD_MODIFIER_FORMULA = FOOD_MODIFIER_FORMULA_STRING_DEFAULT;
        SHOW_FOOD_VALUES_IN_TOOLTIP = true;
        SHOW_SATURATION_OVERLAY = true;
        SHOW_FOOD_VALUES_OVERLAY = true;
    }

    public static enum RoundingMode {
        ROUND("round"){

            @Override
            public double round(double val) {
                return Math.round(val);
            }
        }
        ,
        FLOOR("floor"){

            @Override
            public double round(double val) {
                return Math.floor(val);
            }
        }
        ,
        CEILING("ceiling"){

            @Override
            public double round(double val) {
                return Math.ceil(val);
            }
        };

        public String id;

        private RoundingMode(String id) {
            this.id = id;
        }

        public abstract double round(double var1);
    }
}

