/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;

public abstract class FixedSizeQueue<E>
extends LinkedList<E> {
    private static final long serialVersionUID = 2666900280639735575L;
    protected int limit;

    public FixedSizeQueue(int limit) {
        this.setMaxSize(limit);
    }

    @Override
    public boolean add(E o) {
        boolean added = super.add(o);
        if (added) {
            this.trimToMaxSize();
        }
        return added;
    }

    public int getMaxSize() {
        return this.limit;
    }

    public void setMaxSize(int limit) {
        this.limit = limit;
        this.trimToMaxSize();
    }

    protected void trimToMaxSize() {
        while (this.size() > this.limit) {
            super.remove();
        }
    }

    public abstract void writeToNBT(NBTTagCompound var1);

    public abstract void readFromNBT(NBTTagCompound var1);

    public abstract void pack(DataOutputStream var1) throws IOException;

    public abstract void unpack(DataInputStream var1) throws IOException;
}

