/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FixedFoodQueue;
import squeek.spiceoflife.foodtracker.FixedHungerQueue;
import squeek.spiceoflife.foodtracker.FixedSizeQueue;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;

public class FoodHistory
implements IExtendedEntityProperties {
    public static final String TAG_KEY = "SpiceOfLifeHistory";
    public final EntityPlayer player;
    protected FixedSizeQueue<FoodEaten> history = ModConfig.USE_HUNGER_QUEUE ? new FixedHungerQueue(ModConfig.FOOD_HISTORY_LENGTH) : new FixedFoodQueue(ModConfig.FOOD_HISTORY_LENGTH);
    public int totalFoodsEatenAllTime = 0;

    public FoodHistory(EntityPlayer player) {
        this.player = player;
        if (player != null) {
            player.registerExtendedProperties(TAG_KEY, (IExtendedEntityProperties)this);
        }
    }

    public void onHistoryTypeChanged() {
        FixedSizeQueue<FoodEaten> oldHistory = this.history;
        this.history = ModConfig.USE_HUNGER_QUEUE ? new FixedHungerQueue(ModConfig.FOOD_HISTORY_LENGTH) : new FixedFoodQueue(ModConfig.FOOD_HISTORY_LENGTH);
        this.history.addAll(oldHistory);
    }

    public boolean addFood(FoodEaten foodEaten) {
        return this.addFood(foodEaten, true);
    }

    public boolean addFood(FoodEaten foodEaten, boolean countsTowardsAllTime) {
        if (countsTowardsAllTime) {
            ++this.totalFoodsEatenAllTime;
        }
        if (ModConfig.CLEAR_HISTORY_ON_FOOD_EATEN_THRESHOLD && countsTowardsAllTime && this.totalFoodsEatenAllTime == ModConfig.FOOD_EATEN_THRESHOLD) {
            this.history.clear();
            return true;
        }
        return this.history.add(foodEaten);
    }

    public int getFoodCount(ItemStack food) {
        int count = 0;
        FoodGroup foodGroup = null;
        if (ModConfig.USE_FOOD_GROUPS) {
            foodGroup = FoodGroupRegistry.getFoodGroupForFood(food);
        }
        for (FoodEaten foodEaten : this.history) {
            if ((!food.func_77969_a(foodEaten.itemStack) || !ItemStack.func_77970_a((ItemStack)food, (ItemStack)foodEaten.itemStack)) && (!ModConfig.USE_FOOD_GROUPS || foodGroup == null || !foodGroup.equals(foodEaten.foodGroup))) continue;
            ++count;
        }
        return count;
    }

    public FixedSizeQueue<FoodEaten> getHistory() {
        return this.history;
    }

    public int getHistoryLengthInRelevantUnits() {
        return ModConfig.USE_HUNGER_QUEUE ? ((FixedHungerQueue)this.history).hunger() : this.history.size();
    }

    public FoodEaten getLastEatenFood() {
        return (FoodEaten)this.history.peekLast();
    }

    public static FoodHistory get(EntityPlayer player) {
        return (FoodHistory)player.getExtendedProperties(TAG_KEY);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound rootPersistentCompound = this.player.getEntityData().func_74775_l("PlayerPersisted");
        NBTTagCompound nonPersistentCompound = new NBTTagCompound();
        NBTTagCompound persistentCompound = new NBTTagCompound();
        if (this.history.size() > 0 && (compound != null || ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH)) {
            NBTTagCompound nbtHistory = new NBTTagCompound();
            this.history.writeToNBT(nbtHistory);
            if (ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH) {
                persistentCompound.func_74782_a("History", (NBTBase)nbtHistory);
            } else {
                nonPersistentCompound.func_74782_a("History", (NBTBase)nbtHistory);
            }
        }
        if (this.totalFoodsEatenAllTime > 0) {
            persistentCompound.func_74768_a("Total", this.totalFoodsEatenAllTime);
        }
        if (compound != null && !nonPersistentCompound.func_82582_d()) {
            compound.func_74766_a(TAG_KEY, nonPersistentCompound);
        }
        if (!persistentCompound.func_82582_d()) {
            rootPersistentCompound.func_74766_a(TAG_KEY, persistentCompound);
        }
        if (!this.player.getEntityData().func_74764_b("PlayerPersisted")) {
            this.player.getEntityData().func_74766_a("PlayerPersisted", rootPersistentCompound);
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound rootPersistentCompound = this.player.getEntityData().func_74775_l("PlayerPersisted");
        if (compound != null && compound.func_74764_b(TAG_KEY) || rootPersistentCompound.func_74764_b(TAG_KEY)) {
            NBTTagCompound nonPersistentCompound = compound != null ? compound.func_74775_l(TAG_KEY) : new NBTTagCompound();
            NBTTagCompound persistentCompound = rootPersistentCompound.func_74775_l(TAG_KEY);
            NBTTagCompound nbtHistory = ModConfig.FOOD_HISTORY_PERSISTS_THROUGH_DEATH ? persistentCompound.func_74775_l("History") : nonPersistentCompound.func_74775_l("History");
            this.history.readFromNBT(nbtHistory);
            this.totalFoodsEatenAllTime = persistentCompound.func_74762_e("Total");
        }
    }

    public void init(Entity entity, World world) {
    }
}

