/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import com.udojava.evalex.Expression;
import java.math.BigDecimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.FoodStats;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.FoodTracker;
import squeek.spiceoflife.foodtracker.FoodValues;

public class FoodModifier {
    public static Expression expression = FoodModifier.getNewExpression();

    private static Expression getNewExpression() {
        return new Expression(ModConfig.FOOD_MODIFIER_FORMULA).with("max_history_length", new BigDecimal(ModConfig.FOOD_HISTORY_LENGTH));
    }

    public static void onFormulaChanged() {
        expression = FoodModifier.getNewExpression();
    }

    public static float getFoodModifier(EntityPlayer player, FoodStats foodStats, int hunger, float saturationModifier) {
        return FoodModifier.getFoodModifier(player, FoodTracker.getFoodLastEatenBy(player), foodStats, hunger, saturationModifier);
    }

    public static float getFoodModifier(EntityPlayer player, ItemStack food, FoodStats foodStats, int hunger, float saturationModifier) {
        if (!ModConfig.FOOD_MODIFIER_ENABLED) {
            return 1.0f;
        }
        FoodHistory foodHistory = FoodHistory.get(player);
        int count = foodHistory.getFoodCount(food);
        int historySize = foodHistory.getHistoryLengthInRelevantUnits();
        int totalFoodsEaten = foodHistory.totalFoodsEatenAllTime;
        if (ModConfig.FOOD_EATEN_THRESHOLD > 0 && totalFoodsEaten < ModConfig.FOOD_EATEN_THRESHOLD) {
            return 1.0f;
        }
        BigDecimal result = expression.with("count", new BigDecimal(count)).and("cur_history_length", new BigDecimal(historySize)).and("food_hunger_value", new BigDecimal(hunger)).and("food_saturation_mod", new BigDecimal(saturationModifier)).and("cur_hunger", new BigDecimal(foodStats.func_75116_a())).and("cur_saturation", new BigDecimal(foodStats.func_75115_e())).and("total_food_eaten", new BigDecimal(totalFoodsEaten)).eval();
        return result.floatValue();
    }

    public static FoodValues getModifiedFoodValues(FoodValues foodValues, float modifier) {
        return foodValues.getModified(modifier);
    }

    public static FoodValues modifyFoodValues(FoodValues foodValues, float modifier) {
        return foodValues.modify(modifier);
    }
}

