/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.gui;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.ModSpiceOfLife;
import squeek.spiceoflife.asm.Hooks;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.foodtracker.FoodValues;
import squeek.spiceoflife.helpers.KeyHelper;

public class TooltipOverlayHandler
implements ITickHandler {
    private static final Field theSlot = ReflectionHelper.findField(GuiContainer.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)GuiContainer.class.getName(), (String[])new String[]{"theSlot", "field_82320_o", "t"}));
    private static Class<?> tinkersContainerGui = null;
    private static Field mainSlot = null;
    private static Method getStackMouseOver = null;
    private static Field itemPanel = null;
    private static boolean neiLoaded = false;

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (ModConfig.SHOW_FOOD_VALUES_IN_TOOLTIP && type.contains(TickType.RENDER)) {
            boolean isValidContainerGui;
            Minecraft mc = Minecraft.func_71410_x();
            EntityClientPlayerMP player = mc.field_71439_g;
            GuiScreen curScreen = mc.field_71462_r;
            ScaledResolution scale = new ScaledResolution(mc.field_71474_y, mc.field_71443_c, mc.field_71440_d);
            boolean isTinkersContainerGui = tinkersContainerGui != null && tinkersContainerGui.isInstance(curScreen);
            boolean bl = isValidContainerGui = curScreen instanceof GuiContainer || isTinkersContainerGui;
            if (isValidContainerGui && KeyHelper.isShiftKeyDown()) {
                GuiScreen gui = curScreen;
                int mouseX = Mouse.getX() * scale.func_78326_a() / mc.field_71443_c;
                int mouseY = scale.func_78328_b() - Mouse.getY() * scale.func_78328_b() / mc.field_71440_d;
                ItemStack hoveredStack = null;
                try {
                    Slot hoveredSlot;
                    Slot slot = hoveredSlot = !isTinkersContainerGui ? (Slot)theSlot.get(gui) : (Slot)mainSlot.get(gui);
                    if (hoveredSlot != null) {
                        hoveredStack = hoveredSlot.func_75211_c();
                    }
                    if (hoveredStack == null && getStackMouseOver != null) {
                        hoveredStack = (ItemStack)getStackMouseOver.invoke(itemPanel.get(null), mouseX, mouseY);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (player.field_71071_by.func_70445_o() == null && hoveredStack != null && hoveredStack.func_77973_b() instanceof ItemFood) {
                    int x;
                    FoodValues defaultFoodValues = FoodValues.get(hoveredStack);
                    if (defaultFoodValues.hunger == 0 && defaultFoodValues.saturationModifier == 0.0f) {
                        return;
                    }
                    FoodValues modifiedFoodValues = FoodModifier.getModifiedFoodValues(defaultFoodValues, FoodModifier.getFoodModifier((EntityPlayer)player, hoveredStack, player.func_71024_bL(), defaultFoodValues.hunger, defaultFoodValues.saturationModifier));
                    int barsNeeded = (int)Math.ceil((float)defaultFoodValues.hunger / 2.0f);
                    int saturationBarsNeeded = (int)Math.max(1.0, Math.ceil(Math.abs(defaultFoodValues.getSaturationIncrement()) / 2.0f));
                    boolean needsCoordinateShift = isTinkersContainerGui || !isTinkersContainerGui && !neiLoaded;
                    int toolTipBottomY = Hooks.toolTipY + Hooks.toolTipH + 1 + (needsCoordinateShift ? 3 : 0);
                    int toolTipRightX = Hooks.toolTipX + Hooks.toolTipW + 1 + (needsCoordinateShift ? 3 : 0);
                    boolean shouldDrawBelow = toolTipBottomY + 20 < scale.func_78328_b() - 3;
                    int rightX = toolTipRightX - 3;
                    int leftX = rightX - Math.max(barsNeeded * 9, saturationBarsNeeded * 6) - 4;
                    int topY = shouldDrawBelow ? toolTipBottomY : Hooks.toolTipY - 20 + (needsCoordinateShift ? -4 : 0);
                    int bottomY = topY + (shouldDrawBelow ? 20 : 20);
                    boolean wasLightingEnabled = GL11.glIsEnabled((int)2896);
                    if (wasLightingEnabled) {
                        GL11.glDisable((int)2896);
                    }
                    GL11.glDisable((int)2929);
                    Gui.func_73734_a((int)(leftX - 1), (int)topY, (int)(rightX + 1), (int)bottomY, (int)-267386864);
                    Gui.func_73734_a((int)leftX, (int)(shouldDrawBelow ? bottomY : topY - 1), (int)rightX, (int)(shouldDrawBelow ? bottomY + 1 : topY), (int)-267386864);
                    Gui.func_73734_a((int)leftX, (int)topY, (int)rightX, (int)bottomY, (int)0x66FFFFFF);
                    int startX = x = rightX - 2;
                    int y = bottomY - 19;
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
                    mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                    for (int i = 0; i < barsNeeded * 2; i += 2) {
                        x -= 9;
                        if (modifiedFoodValues.hunger > i + 1 || defaultFoodValues.hunger == modifiedFoodValues.hunger) {
                            gui.func_73729_b(x, y, 16, 27, 9, 9);
                        } else if (modifiedFoodValues.hunger == i + 1) {
                            gui.func_73729_b(x, y, 124, 27, 9, 9);
                        } else {
                            gui.func_73729_b(x, y, 34, 27, 9, 9);
                        }
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        gui.func_73729_b(x, y, defaultFoodValues.hunger - 1 == i ? 115 : 106, 27, 9, 9);
                        GL11.glDisable((int)3042);
                        if (modifiedFoodValues.hunger <= i) continue;
                        gui.func_73729_b(x, y, modifiedFoodValues.hunger - 1 == i ? 61 : 52, 27, 9, 9);
                    }
                    y += 11;
                    x = startX;
                    float modifiedSaturationIncrement = modifiedFoodValues.getSaturationIncrement();
                    float absModifiedSaturationIncrement = Math.abs(modifiedSaturationIncrement);
                    GL11.glPushMatrix();
                    GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    for (int i = 0; i < saturationBarsNeeded * 2; i += 2) {
                        boolean shouldBeFaded;
                        float effectiveSaturationOfBar = (absModifiedSaturationIncrement - (float)i) / 2.0f;
                        x -= 6;
                        boolean bl2 = shouldBeFaded = absModifiedSaturationIncrement <= (float)i;
                        if (shouldBeFaded) {
                            GL11.glEnable((int)3042);
                            GL11.glBlendFunc((int)770, (int)771);
                        }
                        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                        gui.func_73729_b(x * 4 / 3, y * 4 / 3, 16, 27, 9, 9);
                        mc.func_110434_K().func_110577_a(new ResourceLocation("SpiceOfLife".toLowerCase(), "textures/icons.png"));
                        gui.func_73729_b(x * 4 / 3, y * 4 / 3, effectiveSaturationOfBar >= 1.0f ? 27 : ((double)effectiveSaturationOfBar > 0.5 ? 18 : ((double)effectiveSaturationOfBar > 0.25 ? 9 : (effectiveSaturationOfBar > 0.0f ? 0 : 36))), modifiedSaturationIncrement >= 0.0f ? 0 : 9, 9, 9);
                        if (!shouldBeFaded) continue;
                        GL11.glDisable((int)3042);
                    }
                    GL11.glPopMatrix();
                    GL11.glEnable((int)2929);
                    if (wasLightingEnabled) {
                        GL11.glEnable((int)2896);
                    }
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.RENDER, TickType.CLIENT);
    }

    public String getLabel() {
        return "SpiceOfLife";
    }

    static {
        try {
            neiLoaded = Loader.isModLoaded((String)"NotEnoughItems");
            if (neiLoaded) {
                Class<?> LayoutManager = Class.forName("codechicken.nei.LayoutManager");
                itemPanel = LayoutManager.getDeclaredField("itemPanel");
                getStackMouseOver = Class.forName("codechicken.nei.ItemPanel").getDeclaredMethod("getStackMouseOver", Integer.TYPE, Integer.TYPE);
            }
        }
        catch (Exception e) {
            ModSpiceOfLife.Log.warning("Unable to integrate the food values tooltip overlay with NEI: ");
            e.printStackTrace();
        }
        try {
            if (Loader.isModLoaded((String)"TConstruct")) {
                tinkersContainerGui = ReflectionHelper.getClass((ClassLoader)TooltipOverlayHandler.class.getClassLoader(), (String[])new String[]{"tconstruct.client.gui.NewContainerGui"});
                mainSlot = ReflectionHelper.findField(tinkersContainerGui, (String[])new String[]{"mainSlot"});
            }
        }
        catch (Exception e) {
            ModSpiceOfLife.Log.warning("Unable to integrate the food values tooltip overlay with Tinkers Construct: ");
            e.printStackTrace();
        }
    }
}

