/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.network;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.network.PacketBase;

public class PacketFoodHistory
extends PacketBase {
    private FoodHistory foodHistory = null;
    private boolean shouldOverwrite = false;

    public PacketFoodHistory() {
    }

    public PacketFoodHistory(FoodHistory foodHistory) {
        this.foodHistory = foodHistory;
    }

    public PacketFoodHistory(FoodHistory foodHistory, boolean shouldOverwrite) {
        this(foodHistory);
        this.shouldOverwrite = shouldOverwrite;
    }

    public PacketFoodHistory(FoodEaten foodEaten) {
        this.foodHistory = new FoodHistory(null);
        this.foodHistory.addFood(foodEaten);
    }

    @Override
    public void pack(DataOutputStream data) throws IOException {
        if (this.foodHistory == null) {
            return;
        }
        data.writeBoolean(this.shouldOverwrite);
        data.writeShort(this.foodHistory.getHistory().size());
        for (FoodEaten foodEaten : this.foodHistory.getHistory()) {
            data.writeShort(foodEaten.hungerRestored);
            data.writeUTF(foodEaten.foodGroup != null ? foodEaten.foodGroup.identifier : "");
            Packet.func_73270_a((ItemStack)foodEaten.itemStack, (DataOutput)data);
        }
    }

    @Override
    public void unpack(DataInputStream data, INetworkManager manager, EntityPlayer player) throws IOException {
        FoodHistory foodHistory = FoodHistory.get(player) == null ? new FoodHistory(player) : FoodHistory.get(player);
        this.shouldOverwrite = data.readBoolean();
        if (this.shouldOverwrite) {
            foodHistory.getHistory().clear();
        }
        int historySize = data.readShort();
        for (int i = 0; i < historySize; ++i) {
            FoodEaten foodEaten = new FoodEaten();
            foodEaten.hungerRestored = data.readShort();
            foodEaten.foodGroup = FoodGroupRegistry.getFoodGroup(data.readUTF());
            foodEaten.itemStack = Packet.func_73276_c((DataInput)data);
            foodHistory.addFood(foodEaten, !this.shouldOverwrite);
        }
    }
}

