/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block;

import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import openblocks.common.block.BlockRadio;
import openblocks.common.tileentity.TileEntityRadio;
import openmods.block.OpenBlock;
import openmods.renderer.IBlockRenderer;
import openmods.renderer.RotatedTessellator;
import org.lwjgl.opengl.GL11;

public class BlockRadioRenderer
implements IBlockRenderer<BlockRadio> {
    private static final double UNIT = 0.0625;

    public void renderInventoryBlock(BlockRadio block, int metadata, int modelID, RenderBlocks renderer) {
        Tessellator tes = new Tessellator();
        tes.func_78382_b();
        tes.func_78373_b(-0.5, -0.5, -0.5);
        BlockRadioRenderer.renderRadio(block, (Tessellator)new RotatedTessellator.R90(tes), null);
        GL11.glDisable((int)2896);
        tes.func_78381_a();
        GL11.glEnable((int)2896);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockRadio block, int modelId, RenderBlocks renderer) {
        int meta = world.func_72805_g(x, y, z);
        TileEntityRadio te = (TileEntityRadio)((Object)OpenBlock.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityRadio.class));
        ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
        Tessellator tes = Tessellator.field_78398_a;
        double tx = tes.field_78408_v;
        double ty = tes.field_78407_w;
        double tz = tes.field_78417_x;
        tes.func_78373_b((double)x + tx, (double)y + ty, (double)z + tz);
        Tessellator rotated = RotatedTessellator.wrap((Tessellator)tes, (ForgeDirection)dir);
        tes.func_78380_c(block.func_71874_e(world, x, y, z));
        BlockRadioRenderer.renderRadio(block, rotated, te != null ? te.getCrystalColor() : null);
        tes.func_78373_b(tx, ty, tz);
        return true;
    }

    private static void renderWalls(BlockRadio b, Tessellator tes, double dx, double dy, double dz) {
        double mx = 1.0 - dx;
        double my = 1.0 - dy;
        double mz = 1.0 - dz;
        Icon front = b.iconFront;
        Icon back = b.iconBack;
        Icon side = b.iconSide;
        Icon top = b.iconTop;
        tes.func_78374_a(mx, 0.0, dz, (double)front.func_94214_a(dx * 16.0), (double)front.func_94210_h());
        tes.func_78374_a(dx, 0.0, dz, (double)front.func_94214_a(mx * 16.0), (double)front.func_94210_h());
        tes.func_78374_a(dx, dy, dz, (double)front.func_94214_a(mx * 16.0), (double)front.func_94207_b(my * 16.0));
        tes.func_78374_a(mx, dy, dz, (double)front.func_94214_a(dx * 16.0), (double)front.func_94207_b(my * 16.0));
        tes.func_78374_a(mx, 0.0, mz, (double)back.func_94214_a(dx * 16.0), (double)back.func_94210_h());
        tes.func_78374_a(mx, dy, mz, (double)back.func_94214_a(dx * 16.0), (double)back.func_94207_b(my * 16.0));
        tes.func_78374_a(dx, dy, mz, (double)back.func_94214_a(mx * 16.0), (double)back.func_94207_b(my * 16.0));
        tes.func_78374_a(dx, 0.0, mz, (double)back.func_94214_a(mx * 16.0), (double)back.func_94210_h());
        tes.func_78374_a(dx, 0.0, dz, (double)side.func_94214_a(dz * 16.0), (double)side.func_94210_h());
        tes.func_78374_a(dx, 0.0, mz, (double)side.func_94214_a(mz * 16.0), (double)side.func_94210_h());
        tes.func_78374_a(dx, dy, mz, (double)side.func_94214_a(mz * 16.0), (double)side.func_94207_b(my * 16.0));
        tes.func_78374_a(dx, dy, dz, (double)side.func_94214_a(dz * 16.0), (double)side.func_94207_b(my * 16.0));
        tes.func_78374_a(mx, 0.0, dz, (double)side.func_94214_a(dz * 16.0), (double)side.func_94210_h());
        tes.func_78374_a(mx, dy, dz, (double)side.func_94214_a(dz * 16.0), (double)side.func_94207_b(my * 16.0));
        tes.func_78374_a(mx, dy, mz, (double)side.func_94214_a(mz * 16.0), (double)side.func_94207_b(my * 16.0));
        tes.func_78374_a(mx, 0.0, mz, (double)side.func_94214_a(mz * 16.0), (double)side.func_94210_h());
        tes.func_78374_a(dx, dy, dz, (double)top.func_94214_a(dx * 16.0), (double)top.func_94207_b(mz * 16.0));
        tes.func_78374_a(dx, dy, mz, (double)top.func_94214_a(dx * 16.0), (double)top.func_94207_b(dz * 16.0));
        tes.func_78374_a(mx, dy, mz, (double)top.func_94214_a(mx * 16.0), (double)top.func_94207_b(dz * 16.0));
        tes.func_78374_a(mx, dy, dz, (double)top.func_94214_a(mx * 16.0), (double)top.func_94207_b(mz * 16.0));
    }

    private static void renderBottom(BlockRadio b, Tessellator tes) {
        float minU = b.iconBottom.func_94209_e();
        float maxV = b.iconBottom.func_94210_h();
        float maxU = b.iconBottom.func_94212_f();
        float minV = b.iconBottom.func_94206_g();
        tes.func_78374_a(0.0, 0.0, 0.0, (double)minU, (double)maxV);
        tes.func_78374_a(1.0, 0.0, 0.0, (double)maxU, (double)maxV);
        tes.func_78374_a(1.0, 0.0, 1.0, (double)maxU, (double)minV);
        tes.func_78374_a(0.0, 0.0, 1.0, (double)minU, (double)minV);
    }

    private static void renderInside(BlockRadio b, Tessellator tes) {
        double lx = 0.375;
        double rx = 0.625;
        double by = 0.0625;
        double ty = 0.4375;
        double fz = 0.0625;
        double bz = 0.3125;
        Icon inside = b.iconInside;
        float u0 = inside.func_94214_a(0.0);
        float u6 = inside.func_94214_a(6.0);
        float u16 = inside.func_94214_a(16.0);
        float v1 = inside.func_94207_b(1.0);
        float v5 = inside.func_94207_b(5.0);
        float v10 = inside.func_94214_a(10.0);
        float v11 = inside.func_94207_b(11.0);
        float v15 = inside.func_94207_b(15.0);
        tes.func_78374_a(0.375, 0.0625, 0.0625, (double)u0, (double)v15);
        tes.func_78374_a(0.375, 0.0625, 0.3125, (double)u6, (double)v15);
        tes.func_78374_a(0.625, 0.0625, 0.3125, (double)u6, (double)v11);
        tes.func_78374_a(0.625, 0.0625, 0.0625, (double)u0, (double)v11);
        tes.func_78374_a(0.375, 0.4375, 0.0625, (double)u16, (double)v5);
        tes.func_78374_a(0.625, 0.4375, 0.0625, (double)u16, (double)v1);
        tes.func_78374_a(0.625, 0.4375, 0.3125, (double)v10, (double)v1);
        tes.func_78374_a(0.375, 0.4375, 0.3125, (double)v10, (double)v5);
        tes.func_78374_a(0.375, 0.4375, 0.0625, (double)u16, (double)v5);
        tes.func_78374_a(0.375, 0.4375, 0.3125, (double)v10, (double)v5);
        tes.func_78374_a(0.375, 0.0625, 0.3125, (double)v10, (double)v11);
        tes.func_78374_a(0.375, 0.0625, 0.0625, (double)u16, (double)v11);
        tes.func_78374_a(0.625, 0.4375, 0.0625, (double)u0, (double)v5);
        tes.func_78374_a(0.625, 0.0625, 0.0625, (double)u0, (double)v11);
        tes.func_78374_a(0.625, 0.0625, 0.3125, (double)u6, (double)v11);
        tes.func_78374_a(0.625, 0.4375, 0.3125, (double)u6, (double)v5);
        tes.func_78374_a(0.375, 0.4375, 0.3125, (double)v10, (double)v5);
        tes.func_78374_a(0.625, 0.4375, 0.3125, (double)u6, (double)v5);
        tes.func_78374_a(0.625, 0.0625, 0.3125, (double)u6, (double)v11);
        tes.func_78374_a(0.375, 0.0625, 0.3125, (double)v10, (double)v11);
    }

    private static void renderCrystalCage(BlockRadio b, Tessellator tes) {
        double lx = 0.4375;
        double rx = 0.5625;
        double by = 0.0625;
        double ty = 0.4375;
        double fz = 0.140625;
        double bz = 0.234375;
        Icon tex = b.iconInside;
        float u6 = tex.func_94214_a(6.0);
        float u10 = tex.func_94214_a(10.0);
        float u16 = tex.func_94214_a(16.0);
        float v11 = tex.func_94207_b(11.0);
        float v15 = tex.func_94207_b(15.0);
        tes.func_78374_a(0.4375, 0.0625, 0.140625, (double)u10, (double)v15);
        tes.func_78374_a(0.4375, 0.4375, 0.140625, (double)u16, (double)v15);
        tes.func_78374_a(0.5625, 0.4375, 0.140625, (double)u16, (double)v11);
        tes.func_78374_a(0.5625, 0.0625, 0.140625, (double)u10, (double)v11);
        tes.func_78374_a(0.4375, 0.0625, 0.234375, (double)u10, (double)v15);
        tes.func_78374_a(0.4375, 0.4375, 0.234375, (double)u16, (double)v15);
        tes.func_78374_a(0.5625, 0.4375, 0.234375, (double)u16, (double)v11);
        tes.func_78374_a(0.5625, 0.0625, 0.234375, (double)u10, (double)v11);
        tes.func_78374_a(0.4375, 0.0625, 0.234375, (double)u10, (double)v15);
        tes.func_78374_a(0.4375, 0.0625, 0.140625, (double)u10, (double)v11);
        tes.func_78374_a(0.4375, 0.4375, 0.140625, (double)u16, (double)v11);
        tes.func_78374_a(0.4375, 0.4375, 0.234375, (double)u16, (double)v15);
        tes.func_78374_a(0.5625, 0.0625, 0.234375, (double)u10, (double)v15);
        tes.func_78374_a(0.5625, 0.0625, 0.140625, (double)u10, (double)v11);
        tes.func_78374_a(0.5625, 0.4375, 0.140625, (double)u16, (double)v11);
        tes.func_78374_a(0.5625, 0.4375, 0.234375, (double)u16, (double)v15);
        tes.func_78374_a(0.4375, 0.0625, 0.234375, (double)u10, (double)v15);
        tes.func_78374_a(0.4375, 0.4375, 0.234375, (double)u16, (double)v15);
        tes.func_78374_a(0.4375, 0.4375, 0.140625, (double)u16, (double)v11);
        tes.func_78374_a(0.4375, 0.0625, 0.140625, (double)u10, (double)v11);
        tes.func_78374_a(0.5625, 0.0625, 0.234375, (double)u10, (double)v15);
        tes.func_78374_a(0.5625, 0.4375, 0.234375, (double)u16, (double)v15);
        tes.func_78374_a(0.5625, 0.4375, 0.140625, (double)u16, (double)v11);
        tes.func_78374_a(0.5625, 0.0625, 0.140625, (double)u10, (double)v11);
        double by2 = 0.125;
        double ty2 = 0.375;
        tes.func_78374_a(0.5625, 0.375, 0.234375, (double)u6, (double)v15);
        tes.func_78374_a(0.4375, 0.375, 0.234375, (double)u10, (double)v15);
        tes.func_78374_a(0.4375, 0.375, 0.140625, (double)u10, (double)v11);
        tes.func_78374_a(0.5625, 0.375, 0.140625, (double)u6, (double)v11);
        tes.func_78374_a(0.5625, 0.125, 0.234375, (double)u6, (double)v15);
        tes.func_78374_a(0.5625, 0.125, 0.140625, (double)u6, (double)v11);
        tes.func_78374_a(0.4375, 0.125, 0.140625, (double)u10, (double)v11);
        tes.func_78374_a(0.4375, 0.125, 0.234375, (double)u10, (double)v15);
    }

    private static void renderCrystal(BlockRadio b, Tessellator tes, Integer crystal) {
        double lx = 0.46875;
        double rx = 0.53125;
        double by = 0.21875;
        double ty = 0.28125;
        double fz = 0.15625;
        double bz = 0.21875;
        Icon tex = b.iconInside;
        tes.func_78374_a(0.53125, 0.21875, 0.15625, (double)tex.func_94214_a(1.0), (double)tex.func_94207_b(4.0));
        tes.func_78374_a(0.46875, 0.21875, 0.15625, (double)tex.func_94214_a(3.0), (double)tex.func_94207_b(4.0));
        tes.func_78374_a(0.46875, 0.28125, 0.15625, (double)tex.func_94214_a(3.0), (double)tex.func_94207_b(2.0));
        tes.func_78374_a(0.53125, 0.28125, 0.15625, (double)tex.func_94214_a(1.0), (double)tex.func_94207_b(2.0));
        tes.func_78374_a(0.53125, 0.21875, 0.15625, (double)tex.func_94214_a(1.0), (double)tex.func_94207_b(4.0));
        tes.func_78374_a(0.53125, 0.28125, 0.15625, (double)tex.func_94214_a(1.0), (double)tex.func_94207_b(2.0));
        tes.func_78374_a(0.53125, 0.28125, 0.21875, (double)tex.func_94214_a(3.0), (double)tex.func_94207_b(2.0));
        tes.func_78374_a(0.53125, 0.21875, 0.21875, (double)tex.func_94214_a(3.0), (double)tex.func_94207_b(4.0));
        tes.func_78374_a(0.46875, 0.21875, 0.15625, (double)tex.func_94214_a(1.0), (double)tex.func_94207_b(4.0));
        tes.func_78374_a(0.46875, 0.21875, 0.21875, (double)tex.func_94214_a(3.0), (double)tex.func_94207_b(4.0));
        tes.func_78374_a(0.46875, 0.28125, 0.21875, (double)tex.func_94214_a(3.0), (double)tex.func_94207_b(2.0));
        tes.func_78374_a(0.46875, 0.28125, 0.15625, (double)tex.func_94214_a(1.0), (double)tex.func_94207_b(2.0));
        tes.func_78374_a(0.53125, 0.28125, 0.15625, (double)tex.func_94214_a(1.0), (double)tex.func_94207_b(4.0));
        tes.func_78374_a(0.46875, 0.28125, 0.15625, (double)tex.func_94214_a(1.0), (double)tex.func_94207_b(2.0));
        tes.func_78374_a(0.46875, 0.28125, 0.21875, (double)tex.func_94214_a(3.0), (double)tex.func_94207_b(2.0));
        tes.func_78374_a(0.53125, 0.28125, 0.21875, (double)tex.func_94214_a(2.0), (double)tex.func_94207_b(4.0));
        tes.func_78374_a(0.53125, 0.21875, 0.15625, (double)tex.func_94214_a(1.0), (double)tex.func_94207_b(4.0));
        tes.func_78374_a(0.53125, 0.21875, 0.21875, (double)tex.func_94214_a(3.0), (double)tex.func_94207_b(4.0));
        tes.func_78374_a(0.46875, 0.21875, 0.21875, (double)tex.func_94214_a(3.0), (double)tex.func_94207_b(2.0));
        tes.func_78374_a(0.46875, 0.21875, 0.15625, (double)tex.func_94214_a(1.0), (double)tex.func_94207_b(2.0));
    }

    private static void renderRadio(BlockRadio b, Tessellator tes, Integer crystal) {
        tes.func_78376_a(255, 255, 255);
        BlockRadioRenderer.renderWalls(b, tes, 0.3125, 0.9375, 0.0625);
        BlockRadioRenderer.renderWalls(b, tes, 0.125, 0.75, 0.1875);
        BlockRadioRenderer.renderWalls(b, tes, 0.0, 0.625, 0.3125);
        BlockRadioRenderer.renderBottom(b, tes);
        BlockRadioRenderer.renderInside(b, tes);
        if (crystal != null) {
            BlockRadioRenderer.renderCrystalCage(b, tes);
            tes.func_78378_d(crystal.intValue());
            BlockRadioRenderer.renderCrystal(b, tes, crystal);
        }
    }
}

