/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Joiner;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import openblocks.client.gui.GuiDonationStation;
import openblocks.common.DonationUrlManager;
import openblocks.common.container.ContainerDonationStation;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.Mods;
import openmods.api.IHasGui;
import openmods.api.IInventoryCallback;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.sync.SyncableString;
import openmods.tileentity.OpenTileEntity;

public class TileEntityDonationStation
extends OpenTileEntity
implements IHasGui,
IInventoryCallback,
IExtendable,
IInventoryProvider {
    private SyncableString modName = new SyncableString();
    private SyncableString authors = new SyncableString();
    private String donateUrl;
    private final GenericInventory inventory = new GenericInventory("donationstation", true, 1);

    public TileEntityDonationStation() {
        this.inventory.addCallback((IInventoryCallback)this);
    }

    public void initialize() {
        this.findModNameForInventoryItem();
    }

    public void onInventoryChanged(IInventory inventory, int slotNumber) {
        this.findModNameForInventoryItem();
    }

    public String getDonateUrl() {
        return this.donateUrl;
    }

    public SyncableString getAuthors() {
        return this.authors;
    }

    private void findModNameForInventoryItem() {
        ItemStack stack = this.inventory.getStackInSlot((Enum)Slots.input);
        this.modName.setValue("Love an item?");
        this.authors.clear();
        this.donateUrl = null;
        if (stack != null) {
            this.modName.setValue("Vanilla / Unknown");
            ModContainer container = Mods.getModForItemStack((ItemStack)stack);
            if (container != null) {
                ModMetadata meta = container.getMetadata();
                if (meta != null && meta.authorList != null) {
                    this.authors.setValue(Joiner.on((String)", ").join((Iterable)meta.authorList));
                }
                this.donateUrl = DonationUrlManager.instance().getUrl(container.getModId());
                this.modName.setValue(container.getName());
            }
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerDonationStation((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiDonationStation(new ContainerDonationStation((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public SyncableString getModName() {
        return this.modName;
    }

    public void showSomeLove() {
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public static enum Slots {
        input;

    }
}

