/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraftforge.common.ForgeDirection;
import openblocks.shapes.GuideShape;
import openmods.api.IActivateAwareTile;
import openmods.shapes.IShapeable;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.ColorUtils;
import openmods.utils.Coord;

public class TileEntityGuide
extends SyncedTileEntity
implements IShapeable,
IActivateAwareTile {
    private Set<Coord> shape;
    private Set<Coord> previousShape;
    private float timeSinceChange = 0.0f;
    protected SyncableInt width;
    protected SyncableInt height;
    protected SyncableInt depth;
    protected SyncableInt mode;
    protected SyncableInt color;

    protected void createSyncedFields() {
        this.width = new SyncableInt(8);
        this.height = new SyncableInt(8);
        this.depth = new SyncableInt(8);
        this.mode = new SyncableInt(0);
        this.color = new SyncableInt(0xFFFFFF);
    }

    public int getWidth() {
        return this.width.getValue();
    }

    public int getHeight() {
        return this.height.getValue();
    }

    public int getDepth() {
        return this.depth.getValue();
    }

    public int getColor() {
        return this.color.getValue();
    }

    public void setWidth(int w) {
        this.width.setValue(w);
    }

    public void setDepth(int d) {
        this.depth.setValue(d);
    }

    public void setHeight(int h) {
        this.height.setValue(h);
    }

    public GuideShape getCurrentMode() {
        return GuideShape.values()[this.mode.getValue()];
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K && (double)this.timeSinceChange < 1.0) {
            this.timeSinceChange = (float)Math.min(1.0, (double)this.timeSinceChange + 0.1);
        }
    }

    public float getTimeSinceChange() {
        return this.timeSinceChange;
    }

    private void recreateShape() {
        this.previousShape = this.shape;
        this.shape = Sets.newHashSet();
        this.getCurrentMode().generator.generateShape(this.getWidth(), this.getHeight(), this.getDepth(), (IShapeable)this);
        this.timeSinceChange = 0.0f;
    }

    public void setBlock(int x, int y, int z) {
        this.shape.add(new Coord(x, y, z));
    }

    public Set<Coord> getShape() {
        return this.shape;
    }

    public Set<Coord> getPreviousShape() {
        return this.previousShape;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox();
        return box.func_72314_b((double)this.getWidth(), (double)this.getHeight(), (double)this.getDepth());
    }

    private void switchMode(EntityPlayer player) {
        this.switchMode();
        player.func_70006_a(ChatMessageComponent.func_111082_b((String)"openblocks.misc.change_mode", (Object[])new Object[]{this.getCurrentMode().getLocalizedName()}));
        player.func_70006_a(ChatMessageComponent.func_111082_b((String)"openblocks.misc.total_blocks", (Object[])new Object[]{this.shape.size()}));
    }

    private void switchMode() {
        int nextMode = this.mode.getValue() + 1;
        if (nextMode >= GuideShape.values().length) {
            nextMode = 0;
        }
        this.mode.setValue(nextMode);
        if (this.getCurrentMode().fixedRatio) {
            this.setHeight(this.getWidth());
            this.setDepth(this.getWidth());
        }
        this.recreateShape();
        if (!this.field_70331_k.field_72995_K) {
            this.sync();
        }
    }

    private void changeDimensions(EntityPlayer player, ForgeDirection orientation) {
        this.changeDimensions(orientation);
        player.func_70006_a(ChatMessageComponent.func_111082_b((String)"openblocks.misc.change_size", (Object[])new Object[]{this.width.getValue(), this.height.getValue(), this.depth.getValue()}));
        player.func_70006_a(ChatMessageComponent.func_111082_b((String)"openblocks.misc.total_blocks", (Object[])new Object[]{this.shape.size()}));
    }

    private static void inc(SyncableInt v) {
        v.modify(1);
    }

    private static void dec(SyncableInt v) {
        if (v.getValue() > 0) {
            v.modify(-1);
        }
    }

    private void changeDimensions(ForgeDirection orientation) {
        switch (orientation) {
            case EAST: {
                TileEntityGuide.dec(this.width);
                break;
            }
            case WEST: {
                TileEntityGuide.inc(this.width);
                break;
            }
            case SOUTH: {
                TileEntityGuide.dec(this.depth);
                break;
            }
            case NORTH: {
                TileEntityGuide.inc(this.depth);
                break;
            }
            case DOWN: {
                TileEntityGuide.dec(this.height);
                break;
            }
            case UP: {
                TileEntityGuide.inc(this.height);
                break;
            }
            default: {
                return;
            }
        }
        if (this.getCurrentMode().fixedRatio) {
            int h = this.getHeight();
            int w = this.getWidth();
            int d = this.getDepth();
            if (w != h && w != d) {
                this.setHeight(w);
                this.setDepth(w);
            } else if (h != w && h != d) {
                this.depth.setValue(h);
                this.width.setValue(h);
            } else if (d != w && d != h) {
                this.width.setValue(d);
                this.height.setValue(d);
            }
        }
        this.recreateShape();
        if (!this.field_70331_k.field_72995_K) {
            this.sync();
        }
    }

    public void onSynced(Set<ISyncableObject> changes) {
        this.recreateShape();
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (this.field_70331_k.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            this.switchMode(player);
        } else {
            ItemStack heldStack = player.func_70694_bm();
            if (heldStack == null || !this.tryUseItem(player, heldStack)) {
                this.changeDimensions(player, ForgeDirection.getOrientation((int)side));
            }
        }
        return true;
    }

    protected boolean tryUseItem(EntityPlayer player, ItemStack heldStack) {
        Item heldItem;
        if (player.field_71075_bZ.field_75098_d && this.isInFillMode() && (heldItem = heldStack.func_77973_b()) instanceof ItemBlock) {
            this.replaceBlocks(heldStack, heldItem);
            return true;
        }
        ColorUtils.ColorMeta color = ColorUtils.stackToColor((ItemStack)heldStack);
        if (color != null) {
            this.changeColor(color.rgb);
            return true;
        }
        return false;
    }

    protected void replaceBlocks(ItemStack heldStack, Item heldItem) {
        if (this.shape == null) {
            this.recreateShape();
        }
        ItemBlock itemBlock = (ItemBlock)heldItem;
        int blockId = itemBlock.func_77883_f();
        int blockMeta = itemBlock.func_77647_b(heldStack.func_77960_j());
        for (Coord coord : this.shape) {
            this.field_70331_k.func_72832_d(this.field_70329_l + coord.x, this.field_70330_m + coord.y, this.field_70327_n + coord.z, blockId, blockMeta, 3);
        }
    }

    protected void changeColor(int color) {
        this.color.setValue(color);
        if (!this.field_70331_k.field_72995_K) {
            this.sync();
        }
    }

    private boolean isInFillMode() {
        return this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) == Block.field_72089_ap.field_71990_ca;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

