/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Preconditions;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import openblocks.common.item.ItemImaginationGlasses;
import openblocks.common.tileentity.Packet132TileEntity;
import openmods.OpenMods;

public class TileEntityImaginary
extends Packet132TileEntity {
    public static final double PANEL_HEIGHT = 0.1;
    public static final ICollisionData DUMMY = new ICollisionData(){

        @Override
        public void readFromNBT(NBTTagCompound tag) {
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
        }

        @Override
        public CollisionType getType() {
            return CollisionType.BLOCK;
        }

        @Override
        public void addCollisions(int x, int y, int z, AxisAlignedBB region, List<AxisAlignedBB> result) {
            AxisAlignedBB aabb = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            if (aabb != null && aabb.func_72326_a(region)) {
                result.add(aabb);
            }
        }

        @Override
        public AxisAlignedBB getBlockBounds() {
            return AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    };
    @SideOnly(value=Side.CLIENT)
    public float visibility;
    public Integer color;
    public boolean isInverted;
    public ICollisionData collisionData;

    public TileEntityImaginary() {
        this.collisionData = DUMMY;
    }

    public TileEntityImaginary(Integer color, boolean isInverted, ICollisionData collisionData) {
        Preconditions.checkNotNull((Object)collisionData, (Object)"Bad idea! Rejected!");
        this.color = color;
        this.isInverted = isInverted;
        this.collisionData = collisionData;
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.color = tag.func_74764_b("Color") ? Integer.valueOf(tag.func_74762_e("Color")) : null;
        this.isInverted = tag.func_74767_n("IsInverted");
        CollisionType type = CollisionType.VALUES[tag.func_74771_c("Type")];
        this.collisionData = type.createData();
        this.collisionData.readFromNBT(tag);
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        if (this.color != null) {
            tag.func_74768_a("Color", this.color.intValue());
        }
        tag.func_74757_a("IsInverted", this.isInverted);
        tag.func_74774_a("Type", (byte)this.collisionData.getType().ordinal());
        this.collisionData.writeToNBT(tag);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean isPencil() {
        return this.color == null;
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public boolean is(Property what, EntityPlayer player) {
        if (what == Property.SOLID && this.isPencil()) {
            return true;
        }
        ItemStack helmet = player.field_71071_by.func_70440_f(3);
        if (helmet == null) {
            return this.isInverted();
        }
        Item item = helmet.func_77973_b();
        if (item instanceof ItemImaginationGlasses) {
            return ((ItemImaginationGlasses)item).checkBlock(what, helmet, this);
        }
        return false;
    }

    public boolean is(EntityPlayer player) {
        return player.func_70694_bm() != null;
    }

    public boolean is(Property what, Entity e) {
        return e instanceof EntityPlayer && this.is(what, (EntityPlayer)e);
    }

    public boolean is(Property what) {
        EntityPlayer player = OpenMods.proxy.getThePlayer();
        return player != null && this.is(what, player);
    }

    public void addCollisions(AxisAlignedBB region, List<AxisAlignedBB> result) {
        this.collisionData.addCollisions(this.field_70329_l, this.field_70330_m, this.field_70327_n, region, result);
    }

    public AxisAlignedBB getSelectionBox() {
        return this.collisionData.getBlockBounds().func_72317_d((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n);
    }

    public AxisAlignedBB getBlockBounds() {
        return this.collisionData.getBlockBounds();
    }

    public static class StairsData
    implements ICollisionData {
        public float lowerPanelHeight;
        public float upperPanelHeight;
        public ForgeDirection orientation;

        public StairsData() {
        }

        public StairsData(float lowerPanelHeight, float upperPanelHeight, ForgeDirection orientation) {
            this.lowerPanelHeight = lowerPanelHeight;
            this.upperPanelHeight = upperPanelHeight;
            this.orientation = orientation;
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.lowerPanelHeight = tag.func_74760_g("LowerPanelHeight");
            this.upperPanelHeight = tag.func_74760_g("UpperPanelHeight");
            this.orientation = ForgeDirection.getOrientation((int)tag.func_74771_c("Orientation"));
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74776_a("LowerPanelHeight", this.lowerPanelHeight);
            tag.func_74776_a("UpperPanelHeight", this.upperPanelHeight);
            tag.func_74774_a("Orientation", (byte)this.orientation.ordinal());
        }

        @Override
        public CollisionType getType() {
            return CollisionType.STAIRS;
        }

        @Override
        public void addCollisions(int x, int y, int z, AxisAlignedBB region, List<AxisAlignedBB> result) {
            AxisAlignedBB upper;
            AxisAlignedBB lower;
            double lowerTop = (float)y + this.lowerPanelHeight;
            double lowerBottom = lowerTop - 0.1;
            double upperTop = (float)y + this.upperPanelHeight;
            double upperBottom = upperTop - 0.1;
            switch (this.orientation) {
                case NORTH: {
                    lower = AxisAlignedBB.func_72332_a().func_72299_a((double)x, lowerBottom, (double)z + 0.5, (double)(x + 1), lowerTop, (double)z + 1.0);
                    upper = AxisAlignedBB.func_72332_a().func_72299_a((double)x, upperBottom, (double)z + 0.0, (double)(x + 1), upperTop, (double)z + 0.5);
                    break;
                }
                case SOUTH: {
                    lower = AxisAlignedBB.func_72332_a().func_72299_a((double)x, lowerBottom, (double)z + 0.0, (double)(x + 1), lowerTop, (double)z + 0.5);
                    upper = AxisAlignedBB.func_72332_a().func_72299_a((double)x, upperBottom, (double)z + 0.5, (double)(x + 1), upperTop, (double)z + 1.0);
                    break;
                }
                case WEST: {
                    lower = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5, lowerBottom, (double)z, (double)x + 1.0, lowerTop, (double)(z + 1));
                    upper = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.0, upperBottom, (double)z, (double)x + 0.5, upperTop, (double)(z + 1));
                    break;
                }
                case EAST: {
                    lower = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.0, lowerBottom, (double)z, (double)x + 0.5, lowerTop, (double)(z + 1));
                    upper = AxisAlignedBB.func_72332_a().func_72299_a((double)x + 0.5, upperBottom, (double)z, (double)x + 1.0, upperTop, (double)(z + 1));
                    break;
                }
                default: {
                    upper = null;
                    lower = null;
                }
            }
            if (lower != null && lower.func_72326_a(region)) {
                result.add(lower);
            }
            if (upper != null && upper.func_72326_a(region)) {
                result.add(upper);
            }
        }

        @Override
        public AxisAlignedBB getBlockBounds() {
            return AxisAlignedBB.func_72332_a().func_72299_a(0.0, (double)this.lowerPanelHeight, 0.0, 1.0, (double)this.upperPanelHeight, 1.0);
        }
    }

    public static class PanelData
    implements ICollisionData {
        public float height;

        public PanelData() {
        }

        public PanelData(float height) {
            this.height = height;
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.height = tag.func_74760_g("PanelHeight");
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74776_a("PanelHeight", this.height);
        }

        @Override
        public CollisionType getType() {
            return CollisionType.PANEL;
        }

        @Override
        public void addCollisions(int x, int y, int z, AxisAlignedBB region, List<AxisAlignedBB> result) {
            AxisAlignedBB aabb = AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)((float)y + this.height) - 0.1, (double)z, (double)(x + 1), (double)((float)y + this.height), (double)(z + 1));
            if (aabb != null && aabb.func_72326_a(region)) {
                result.add(aabb);
            }
        }

        @Override
        public AxisAlignedBB getBlockBounds() {
            return AxisAlignedBB.func_72332_a().func_72299_a(0.0, (double)this.height - 0.1, 0.0, 1.0, (double)this.height, 1.0);
        }
    }

    public static interface ICollisionData {
        public CollisionType getType();

        public void readFromNBT(NBTTagCompound var1);

        public void writeToNBT(NBTTagCompound var1);

        public void addCollisions(int var1, int var2, int var3, AxisAlignedBB var4, List<AxisAlignedBB> var5);

        public AxisAlignedBB getBlockBounds();
    }

    private static enum CollisionType {
        BLOCK{

            @Override
            public ICollisionData createData() {
                return DUMMY;
            }
        }
        ,
        PANEL{

            @Override
            public ICollisionData createData() {
                return new PanelData();
            }
        }
        ,
        STAIRS{

            @Override
            public ICollisionData createData() {
                return new StairsData();
            }
        };

        public static final CollisionType[] VALUES;

        public abstract ICollisionData createData();

        static {
            VALUES = CollisionType.values();
        }
    }

    public static enum Property {
        VISIBLE,
        SELECTABLE,
        SOLID;

    }
}

