/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.common;

import codechicken.nei.PositionedStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mods.neiplugins.common.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;

public abstract class LiquidHelper {
    private static Map<Integer, ArrayList<ItemStack>> mapFilledContainersFromLiquid = new HashMap<Integer, ArrayList<ItemStack>>();
    private static Map<Integer, ArrayList<ItemStack>> mapEmptyContainersFromLiquid = new HashMap<Integer, ArrayList<ItemStack>>();

    public static String getLiquidName(FluidStack fluidStack) {
        String res = fluidStack.getFluid().getLocalizedName();
        if (res.equals("fluid.tile.water")) {
            res = "\u00a7n" + StatCollector.func_74838_a((String)"tile.water.name");
        } else if (res.equals("fluid.tile.lava")) {
            res = "\u00a7n" + StatCollector.func_74838_a((String)"tile.lava.name");
        }
        if (res.isEmpty() && !(res = fluidStack.getFluid().getName()).isEmpty()) {
            res = "\u00a73" + res;
        }
        return res;
    }

    public static ResourceLocation getFluidSheet(FluidStack liquid) {
        return TextureMap.field_110575_b;
    }

    public static Icon getFluidTexture(FluidStack fluidStack, boolean flowing) {
        Icon fluidIcon;
        if (fluidStack == null || fluidStack.amount <= 0) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        Icon icon = fluidIcon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (fluidIcon == null) {
            fluidIcon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return fluidIcon;
    }

    public static Fluid getLavaFluid() {
        return FluidRegistry.LAVA;
    }

    public static FluidStack getFluidStack(ItemStack stack) {
        Fluid fluid;
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        FluidStack fluidStack = null;
        if (item instanceof IFluidContainerItem) {
            fluidStack = ((IFluidContainerItem)item).getFluid(stack);
        }
        if (fluidStack == null) {
            fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
        }
        if (fluidStack == null && stack.field_77993_c < Block.field_71973_m.length && Block.field_71973_m[stack.field_77993_c] instanceof IFluidBlock && (fluid = ((IFluidBlock)Block.field_71973_m[stack.field_77993_c]).getFluid()) != null) {
            return new FluidStack(fluid, 1000);
        }
        return fluidStack;
    }

    public static PositionedStack[] generateStacksForLiquid(FluidStack fluidStack, int x1, int y1, int x2, int y2) {
        if (mapFilledContainersFromLiquid.isEmpty()) {
            LiquidHelper.generateLiquidCache();
        }
        if (fluidStack == null) {
            return new PositionedStack[]{null, null};
        }
        Integer key = fluidStack.fluidID;
        if (!mapFilledContainersFromLiquid.containsKey(key)) {
            return new PositionedStack[]{null, null};
        }
        return new PositionedStack[]{new PositionedStack(mapEmptyContainersFromLiquid.get(key), x1, y1), new PositionedStack(mapFilledContainersFromLiquid.get(key), x2, y2)};
    }

    public static boolean areSameLiquid(FluidStack fluidStack1, FluidStack fluidStack2) {
        if (fluidStack1 == null || fluidStack2 == null) {
            return false;
        }
        return fluidStack1.isFluidEqual(fluidStack2);
    }

    public static PositionedStack getSeqCycledStack(int cycle, PositionedStack origstack) {
        if (origstack == null) {
            return null;
        }
        PositionedStack stack = origstack.copy();
        if (stack.items.length > 1) {
            stack.setPermutationToRender(cycle % stack.items.length);
        }
        return stack;
    }

    public static void generateLiquidCache() {
        mapFilledContainersFromLiquid.clear();
        mapEmptyContainersFromLiquid.clear();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            Integer key = data.fluid.fluidID;
            if (!mapFilledContainersFromLiquid.containsKey(key)) {
                mapFilledContainersFromLiquid.put(key, new ArrayList());
                mapEmptyContainersFromLiquid.put(key, new ArrayList());
            }
            if (!Utils.isSafeItemStack(data.filledContainer, "FluidContainerRegistry.getRegisteredFluidContainerData[].filledContainer")) continue;
            mapFilledContainersFromLiquid.get(key).add(data.filledContainer.func_77946_l());
            mapEmptyContainersFromLiquid.get(key).add(data.emptyContainer != null ? data.emptyContainer.func_77946_l() : null);
        }
    }

    public static Fluid getWaterFluid() {
        return FluidRegistry.WATER;
    }
}

