/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.tile.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizable;
import powercrystals.minefactoryreloaded.api.IFactoryFertilizer;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.gui.client.GuiFactoryInventory;
import powercrystals.minefactoryreloaded.gui.client.GuiUpgradable;
import powercrystals.minefactoryreloaded.gui.container.ContainerUpgradable;
import powercrystals.minefactoryreloaded.item.ItemUpgrade;
import powercrystals.minefactoryreloaded.setup.MFRConfig;
import powercrystals.minefactoryreloaded.setup.Machine;
import powercrystals.minefactoryreloaded.tile.base.TileEntityFactoryPowered;

public class TileEntityFertilizer
extends TileEntityFactoryPowered {
    private Random _rand = new Random();

    public TileEntityFertilizer() {
        super(Machine.Fertilizer);
        this._areaManager = new HarvestAreaManager(this, 1, 0, 0);
        this.setManageSolids(true);
        this.setCanRotate(true);
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[9]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiFactoryInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiUpgradable(this.getContainer(inventoryPlayer), (TileEntityFactoryPowered)this);
    }

    @Override
    public ContainerUpgradable getContainer(InventoryPlayer inventoryPlayer) {
        return new ContainerUpgradable(this, inventoryPlayer);
    }

    @Override
    public boolean activateMachine() {
        BlockPosition blockPosition = this._areaManager.getNextBlock();
        int n = this.field_70331_k.func_72798_a(blockPosition.x, blockPosition.y, blockPosition.z);
        if (!MFRRegistry.getFertilizables().containsKey(new Integer(n))) {
            this.setIdleTicks(this.getIdleTicksMax());
            return false;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null || !MFRRegistry.getFertilizers().containsKey(new Integer(itemStack.field_77993_c))) continue;
            IFactoryFertilizer iFactoryFertilizer = MFRRegistry.getFertilizers().get(new Integer(itemStack.field_77993_c));
            IFactoryFertilizable iFactoryFertilizable = MFRRegistry.getFertilizables().get(new Integer(n));
            if (iFactoryFertilizer.getFertilizerMeta() != itemStack.func_77960_j() || !iFactoryFertilizable.canFertilizeBlock(this.field_70331_k, blockPosition.x, blockPosition.y, blockPosition.z, iFactoryFertilizer.getFertilizerType()) || !iFactoryFertilizable.fertilize(this.field_70331_k, this._rand, blockPosition.x, blockPosition.y, blockPosition.z, iFactoryFertilizer.getFertilizerType())) continue;
            iFactoryFertilizer.consume(itemStack);
            if (MFRConfig.playSounds.getBoolean(true)) {
                this.field_70331_k.func_72889_a(null, 2005, blockPosition.x, blockPosition.y, blockPosition.z, this._rand.nextInt(10) + 5);
            }
            if (itemStack.field_77994_a <= 0) {
                this.func_70299_a(i, null);
            }
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    public int func_70302_i_() {
        return 10;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 20;
    }

    @Override
    public int getStartInventorySide(ForgeDirection forgeDirection) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection forgeDirection) {
        return 9;
    }

    @Override
    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        if (itemStack != null) {
            if (n < 9) {
                return MFRRegistry.getFertilizers().containsKey(new Integer(itemStack.field_77993_c));
            }
            if (n == 9) {
                return itemStack.func_77973_b() instanceof ItemUpgrade;
            }
        }
        return false;
    }
}

