/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.rockdigger;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.List;
import net.minecraft.block.Block;
import nl.lang2619.rockdigger.RockDigger;
import nl.lang2619.rockdigger.block.RockBlock;
import nl.lang2619.rockdigger.block.RockSlab;
import nl.lang2619.rockdigger.block.RockStair;
import nl.lang2619.rockdigger.config.BlockConfig;

public final class BlockRegistry {
    public static final List<RockBlock> REGISTERED_BLOCKS = Lists.newLinkedList();
    public static final List<RockSlab> REGISTERED_SLABS = Lists.newLinkedList();

    public static void register(BlockConfig config) {
        RockBlock block = new RockBlock(config);
        GameRegistry.registerBlock((Block)block, (String)config.getNameId());
        block.func_71849_a(RockDigger.RockTab);
        LanguageRegistry.addName((Object)((Object)block), (String)config.getName());
        REGISTERED_BLOCKS.add(block);
        if (config.getAltergen()) {
            RockStair stairs = new RockStair(config, block);
            GameRegistry.registerBlock((Block)stairs, (String)stairs.func_71917_a());
            stairs.func_71849_a(RockDigger.RockTab);
            LanguageRegistry.addName((Object)((Object)stairs), (String)stairs.func_71931_t());
            RockSlab slab = new RockSlab(config);
            GameRegistry.registerBlock((Block)slab, (String)slab.func_71917_a());
            slab.func_71849_a(RockDigger.RockTab);
            LanguageRegistry.addName((Object)((Object)slab), (String)slab.func_71931_t());
            REGISTERED_SLABS.add(slab);
        }
    }

    public static void registerAll(List<BlockConfig> configs) {
        for (BlockConfig config : configs) {
            BlockRegistry.register(config);
        }
    }
}

