/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.bloodmagic;

import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipe;
import WayofTime.alchemicalWizardry.api.altarRecipeRegistry.AltarRecipeRegistry;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraft.item.ItemStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;

public class AltarAddRecipe
extends TweakerBaseFunction {
    public static final AltarAddRecipe INSTANCE = new AltarAddRecipe();

    private AltarAddRecipe() {
        super("bloodmagic.altar.addRecipe");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(new int[]{4, 5, 6}, args)) {
            ItemStack input = TweakerHelper.getItem();
            ItemStack output = TweakerHelper.getItem();
            int tier = TweakerHelper.getInt();
            int lp = TweakerHelper.getInt();
            int consumption = 5;
            int drain = 5;
            if (args.length >= 5) {
                consumption = TweakerHelper.getInt();
                if (args.length >= 6) {
                    drain = TweakerHelper.getInt();
                }
            }
            Tweaker.apply((IUndoableAction)new Action(new AltarRecipe(output, input, tier, lp, consumption, drain, false)));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, new int[]{5, 6});
        }
    }

    private static class Action
    implements IUndoableAction {
        private final AltarRecipe recipe;

        public Action(AltarRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            AltarRecipeRegistry.altarRecipes.add(this.recipe);
        }

        public boolean canUndo() {
            return AltarRecipeRegistry.altarRecipes != null;
        }

        public void undo() {
            AltarRecipeRegistry.altarRecipes.remove(this.recipe);
        }

        public String describe() {
            return "Adding Altar Recipe: " + this.recipe.result.func_82833_r();
        }

        public String describeUndo() {
            return "Removing Altar Recipe: " + this.recipe.result.func_82833_r();
        }
    }
}

