/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.growthcraft.action;

import growthcraft.api.fishtrap.FishTrapEntry;
import modtweaker.growthcraft.GrowthcraftHacks;
import stanhebben.minetweaker.api.IUndoableAction;

public class FishTrapAddLootAction
implements IUndoableAction {
    private final Rarity rarity;
    private final FishTrapEntry entry;

    public FishTrapAddLootAction(FishTrapEntry entry, Rarity rarity) {
        this.entry = entry;
        this.rarity = rarity;
    }

    public void apply() {
        switch (this.rarity) {
            case FISH: {
                GrowthcraftHacks.fishList.add(this.entry);
                break;
            }
            case TREASURE: {
                GrowthcraftHacks.treasureList.add(this.entry);
                break;
            }
            case JUNK: {
                GrowthcraftHacks.junkList.add(this.entry);
            }
        }
    }

    public boolean canUndo() {
        switch (this.rarity) {
            case FISH: {
                return GrowthcraftHacks.fishList != null;
            }
            case TREASURE: {
                return GrowthcraftHacks.treasureList != null;
            }
            case JUNK: {
                return GrowthcraftHacks.junkList != null;
            }
        }
        return false;
    }

    public void undo() {
        switch (this.rarity) {
            case FISH: {
                GrowthcraftHacks.fishList.remove(this.entry);
                break;
            }
            case TREASURE: {
                GrowthcraftHacks.treasureList.remove(this.entry);
                break;
            }
            case JUNK: {
                GrowthcraftHacks.junkList.remove(this.entry);
            }
        }
    }

    public String describe() {
        return "Adding Growthcraft Loot: " + this.entry.fishable.func_82833_r() + " from " + this.rarity.name().toLowerCase();
    }

    public String describeUndo() {
        return "Removing Growthcraft Loot: " + this.entry.fishable.func_82833_r() + " from " + this.rarity.name().toLowerCase();
    }

    public static enum Rarity {
        FISH,
        TREASURE,
        JUNK;

    }
}

