/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.steelworks;

import java.util.Arrays;
import modtweaker.steelworks.SteelworksHacks;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;
import tsteelworks.lib.crafting.AdvancedSmelting;

public class MeltingRemoveRecipe
extends TweakerBaseFunction {
    public static final MeltingRemoveRecipe INSTANCE = new MeltingRemoveRecipe();

    private MeltingRemoveRecipe() {
        super("steelworks.removeMelting");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(1, args)) {
            ItemStack input = TweakerHelper.getItem();
            Tweaker.apply((IUndoableAction)new Action(input));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, 1);
        }
    }

    private static class Action
    implements IUndoableAction {
        private final ItemStack input;
        private FluidStack fluid;
        private Integer temp;
        private ItemStack renderer;

        public Action(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            this.fluid = SteelworksHacks.smeltingList.get(Arrays.asList(this.input.field_77993_c, this.input.func_77960_j()));
            this.temp = SteelworksHacks.temperatureList.get(Arrays.asList(this.input.field_77993_c, this.input.func_77960_j()));
            this.renderer = SteelworksHacks.renderIndex.get(Arrays.asList(this.input.field_77993_c, this.input.func_77960_j()));
            SteelworksHacks.smeltingList.remove(Arrays.asList(this.input.field_77993_c, this.input.func_77960_j()));
            SteelworksHacks.temperatureList.remove(Arrays.asList(this.input.field_77993_c, this.input.func_77960_j()));
            SteelworksHacks.renderIndex.remove(Arrays.asList(this.input.field_77993_c, this.input.func_77960_j()));
        }

        public boolean canUndo() {
            return SteelworksHacks.smeltingList != null;
        }

        public void undo() {
            AdvancedSmelting.addMelting((ItemStack)this.input, (int)this.renderer.field_77993_c, (int)this.renderer.func_77960_j(), (int)this.temp, (FluidStack)this.fluid);
        }

        public String describe() {
            return "Removing High Oven Recipe: " + this.input.func_82833_r();
        }

        public String describeUndo() {
            return "Restoring High Oven Recipe: " + this.input.func_82833_r();
        }
    }
}

