/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.tconstruct;

import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraft.item.ItemStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;
import tconstruct.library.crafting.DryingRackRecipes;

public class DryingAddRecipe
extends TweakerBaseFunction {
    public static final DryingAddRecipe INSTANCE = new DryingAddRecipe();

    private DryingAddRecipe() {
        super("tconstruct.drying.addRecipe");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(3, args)) {
            ItemStack input = TweakerHelper.getItem();
            ItemStack output = TweakerHelper.getItem();
            int time = TweakerHelper.getInt();
            Tweaker.apply((IUndoableAction)new Action(input, time, output));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, 3);
        }
    }

    private static class Action
    implements IUndoableAction {
        private final ItemStack input;
        private final int time;
        private final ItemStack output;

        public Action(ItemStack input, int time, ItemStack output) {
            this.input = input;
            this.time = time;
            this.output = output;
        }

        public void apply() {
            DryingRackRecipes.addDryingRecipe((Object)this.input, (int)this.time, (Object)this.output);
        }

        public boolean canUndo() {
            return false;
        }

        public void undo() {
        }

        public String describe() {
            return "Adding Drying Rack Recipe: " + this.output.func_82833_r();
        }

        public String describeUndo() {
            return "Removing Drying Rack Recipe: " + this.output.func_82833_r();
        }
    }
}

