/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.network.Payload;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.core.TEProps;

public class TileDynamoCompression
extends TileDynamoBase
implements IFluidHandler {
    static Map fuels = new HashMap();
    static Map coolants = new HashMap();
    FluidTank fuelTank = new FluidTank(4000);
    FluidTank coolantTank = new FluidTank(4000);
    FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
    int coolantRF;

    public static void initialize() {
        TileDynamoCompression.guiIds[BlockDynamo.Types.COMPRESSION.ordinal()] = ThermalExpansion.proxy.registerGui("DynamoCompression", "dynamo", "TEBase", null, true);
        GameRegistry.registerTileEntity(TileDynamoCompression.class, (String)"cofh.thermalexpansion.DynamoCompression");
    }

    public int getType() {
        return BlockDynamo.Types.COMPRESSION.ordinal();
    }

    public static boolean registerFuel(Fluid fluid, int energy) {
        if (fluid == null || energy <= 10000) {
            return false;
        }
        fuels.put(fluid, energy / 100);
        return true;
    }

    public static boolean registerCoolant(Fluid fluid, int cooling) {
        if (fluid == null || cooling <= 10000) {
            return false;
        }
        coolants.put(fluid, cooling / 100);
        return true;
    }

    public static int getFuelEnergy(FluidStack stack) {
        return stack == null ? 0 : (Integer)fuels.get(stack.getFluid());
    }

    public static int getCoolantEnergy(FluidStack stack) {
        return stack == null ? 0 : (Integer)coolants.get(stack.getFluid());
    }

    public static boolean isValidFuel(FluidStack stack) {
        return stack == null ? false : fuels.containsKey(stack.getFluid());
    }

    public static boolean isValidCoolant(FluidStack stack) {
        return stack == null ? false : coolants.containsKey(stack.getFluid());
    }

    public FluidTank getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.fuelTank;
        }
        return this.coolantTank;
    }

    @Override
    protected boolean canGenerate() {
        if (this.fuelRF > 0) {
            return this.coolantRF > 0 || this.coolantTank.getFluidAmount() >= 10;
        }
        if (this.coolantRF > 0) {
            return this.fuelTank.getFluidAmount() >= 10;
        }
        return this.fuelTank.getFluidAmount() >= 10 && this.coolantTank.getFluidAmount() >= 10;
    }

    @Override
    protected void generate() {
        if (this.fuelRF <= 0) {
            this.fuelRF = TileDynamoCompression.getFuelEnergy(this.fuelTank.getFluid());
            this.fuelTank.drain(10, true);
        }
        if (this.coolantRF <= 0) {
            this.coolantRF = TileDynamoCompression.getCoolantEnergy(this.coolantTank.getFluid());
            this.coolantTank.drain(10, true);
        }
        int energy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(energy);
        this.fuelRF -= energy;
        this.coolantRF -= energy;
    }

    @Override
    public Icon getActiveIcon() {
        return this.renderFluid.getFluid().getIcon(this.renderFluid);
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addFluidStack(this.fuelTank.getFluid());
        return payload;
    }

    @Override
    public Payload getGuiPayload() {
        Payload payload = Payload.getInfoPayload((TileEntity)this);
        payload.addByte(TEProps.PacketID.GUI.ordinal());
        payload.addFluidStack(this.fuelTank.getFluid());
        payload.addFluidStack(this.coolantTank.getFluid());
        payload.addInt(this.energyStorage.getEnergyStored());
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
        if (this.renderFluid == null) {
            this.renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
        }
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.fuelTank.setFluid(payload.getFluidStack());
                this.coolantTank.setFluid(payload.getFluidStack());
                this.energyStorage.setEnergyStored(payload.getInt());
                return;
            }
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.coolantRF = nbt.func_74762_e("Coolant");
        this.fuelTank.readFromNBT(nbt.func_74775_l("FuelTank"));
        this.coolantTank.readFromNBT(nbt.func_74775_l("CoolantTank"));
        if (!TileDynamoCompression.isValidFuel(this.fuelTank.getFluid())) {
            this.fuelTank.setFluid(null);
        }
        if (!TileDynamoCompression.isValidCoolant(this.coolantTank.getFluid())) {
            this.coolantTank.setFluid(null);
        }
        if (this.fuelTank.getFluid() != null) {
            this.renderFluid = this.fuelTank.getFluid();
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Coolant", this.coolantRF);
        nbt.func_74782_a("FuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("CoolantTank", (NBTBase)this.coolantTank.writeToNBT(new NBTTagCompound()));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return 0;
        }
        if (TileDynamoCompression.isValidFuel(resource)) {
            return this.fuelTank.fill(resource, doFill);
        }
        if (TileDynamoCompression.isValidCoolant(resource)) {
            return this.coolantTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return null;
        }
        if (TileDynamoCompression.isValidFuel(resource)) {
            return this.fuelTank.drain(resource.amount, doDrain);
        }
        if (TileDynamoCompression.isValidCoolant(resource)) {
            return this.coolantTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.fuelTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.ordinal() != this.facing;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.ordinal() != this.facing;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fuelTank.getInfo(), this.coolantTank.getInfo()};
    }
}

