/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.network.Payload;
import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.util.FluidHelper;
import cofh.util.ItemHelper;
import cofh.util.ServerHelper;
import cofh.util.fluid.FluidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.block.machine.TileMachineEnergized;
import thermalexpansion.core.TEProps;
import thermalexpansion.util.crafting.TransposerManager;

public class TileTransposer
extends TileMachineEnergized
implements IFluidHandler {
    public static final int TYPE = BlockMachine.Types.TRANSPOSER.ordinal();
    public boolean reverseFlag;
    public boolean reverse;
    IFluidContainerItem containerItem = null;
    FluidStack renderFluid = new FluidStack(FluidRegistry.WATER, 0);
    FluidTankAdv tank = new FluidTankAdv(10000);
    FluidStack outputBuffer;
    int outputTracker;
    int outputTrackerFluid;

    public static void initialize() {
        TileTransposer.sideData[TileTransposer.TYPE] = new TileMachineBase.SideConfig();
        TileTransposer.sideData[TileTransposer.TYPE].numGroup = 5;
        TileTransposer.sideData[TileTransposer.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, new int[0], {1}};
        TileTransposer.sideData[TileTransposer.TYPE].allowInsertion = new boolean[]{false, true, false, false, false};
        TileTransposer.sideData[TileTransposer.TYPE].allowExtraction = new boolean[]{false, false, true, false, true};
        TileTransposer.sideData[TileTransposer.TYPE].sideTex = new int[]{0, 1, 2, 3, 4};
        TileTransposer.energyData[TileTransposer.TYPE] = new TileMachineEnergized.EnergyConfig();
        energyData[TYPE].setEnergyParams(40);
        TileTransposer.guiIds[TileTransposer.TYPE] = ThermalExpansion.proxy.registerGui("Transposer", "machine", true);
        GameRegistry.registerTileEntity(TileTransposer.class, (String)"cofh.thermalexpansion.Transposer");
    }

    public TileTransposer() {
        this.sideCache = new byte[]{3, 3, 2, 2, 2, 2};
        this.inventory = new ItemStack[3];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        if (!this.reverse) {
            if (this.tank.getFluidAmount() <= 0) {
                return false;
            }
            TransposerManager.RecipeTransposer recipe = TransposerManager.getFillRecipe(this.inventory[0], this.tank.getFluid());
            if (recipe == null || this.tank.getFluidAmount() < recipe.getFluid().amount || this.energyStorage.getEnergyStored() < recipe.getEnergy()) {
                return false;
            }
            if (this.inventory[0].field_77994_a < recipe.getInput().field_77994_a) {
                return false;
            }
            if (this.inventory[1] == null) {
                return true;
            }
            ItemStack output = recipe.getOutput();
            if (!this.inventory[1].func_77969_a(output)) {
                return false;
            }
            int result = this.inventory[1].field_77994_a + output.field_77994_a;
            return this.inventory[1].field_77994_a + output.field_77994_a <= output.func_77976_d();
        }
        TransposerManager.RecipeTransposer recipe = TransposerManager.getExtractionRecipe(this.inventory[0]);
        if (recipe == null || this.energyStorage.getEnergyStored() < recipe.getEnergy()) {
            return false;
        }
        if (this.inventory[0].field_77994_a < recipe.getInput().field_77994_a) {
            return false;
        }
        if (this.tank.fill(recipe.getFluid(), false) != recipe.getFluid().amount) {
            return false;
        }
        if (this.inventory[1] == null) {
            return true;
        }
        ItemStack output = recipe.getOutput();
        if (output == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(output)) {
            return false;
        }
        return this.inventory[1].field_77994_a + output.field_77994_a <= output.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.containerItem != null) {
            return true;
        }
        TransposerManager.RecipeTransposer recipe = !this.reverse ? TransposerManager.getFillRecipe(this.inventory[0], this.tank.getFluid()) : TransposerManager.getExtractionRecipe(this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        return recipe.getInput().field_77994_a <= this.inventory[0].field_77994_a;
    }

    @Override
    protected void processStart() {
        int prevID = this.renderFluid.fluidID;
        if (!this.reverse) {
            this.processMax = TransposerManager.getFillRecipe(this.inventory[0], this.tank.getFluid()).getEnergy();
            this.renderFluid = this.tank.getFluid().copy();
        } else {
            this.processMax = TransposerManager.getExtractionRecipe(this.inventory[0]).getEnergy();
            this.renderFluid = TransposerManager.getExtractionRecipe(this.inventory[0]).getFluid();
        }
        this.renderFluid.amount = 0;
        this.processRem = this.processMax;
        if (prevID != this.renderFluid.fluidID) {
            this.sendFluidPacket();
        }
    }

    @Override
    protected void processFinish() {
        if (!this.reverse) {
            TransposerManager.RecipeTransposer recipe = TransposerManager.getFillRecipe(this.inventory[0], this.tank.getFluid());
            ItemStack output = recipe.getOutput();
            if (this.inventory[1] == null) {
                this.inventory[1] = output;
            } else {
                this.inventory[1].field_77994_a += output.field_77994_a;
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
            this.tank.drain(recipe.getFluid().amount, true);
        } else {
            TransposerManager.RecipeTransposer recipe = TransposerManager.getExtractionRecipe(this.inventory[0]);
            ItemStack output = recipe.getOutput();
            if (this.field_70331_k.field_73012_v.nextInt(100) < recipe.getChance()) {
                if (this.inventory[1] == null) {
                    this.inventory[1] = output;
                } else {
                    this.inventory[1].field_77994_a += output.field_77994_a;
                }
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
            this.tank.fill(recipe.getFluid(), true);
        }
        this.reverse = this.reverseFlag;
    }

    protected void transferFluid() {
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        this.outputBuffer = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 25));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (this.sideCache[side] != 3 && this.sideCache[side] != 4 || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (int)side, (FluidStack)this.outputBuffer, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    @Override
    protected void transferProducts() {
        if (this.inventory[1] == null) {
            if (this.containerItem != null) {
                this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
                this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
                this.containerItem = null;
            } else {
                return;
            }
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 && this.sideCache[side] != 4 || !this.transferItem(1, 4, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public void func_70316_g() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            if (this.inventory[0] == null) {
                this.processRem = 0;
            }
            return;
        }
        if (this.containerItem == null && FluidHelper.isFluidContainerItem((ItemStack)this.inventory[0])) {
            this.updateContainerItem();
        }
        if (this.reverse) {
            this.transferFluid();
        }
        if (this.containerItem != null) {
            boolean curActive = this.isActive;
            this.processContainerItem();
            this.updateIfChanged(curActive);
            this.chargeEnergy();
        } else {
            super.func_70316_g();
        }
    }

    protected void processContainerItem() {
        if (this.isActive) {
            int energy = Math.min(this.energyStorage.getEnergyStored(), this.calcEnergy());
            if (!this.reverse) {
                this.updateContainerFill(energy);
            } else {
                this.updateContainerEmpty(energy);
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(this.field_70331_k);
            } else if (this.containerItem == null) {
                if (FluidHelper.isFluidContainerItem((ItemStack)this.inventory[0])) {
                    this.updateContainerItem();
                    this.isActive = true;
                } else {
                    this.isActive = false;
                    this.wasActive = true;
                    this.tracker.markTime(this.field_70331_k);
                }
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferProducts();
            }
            if (this.containerItem == null && FluidHelper.isFluidContainerItem((ItemStack)this.inventory[0])) {
                this.updateContainerItem();
            }
            if (this.containerItem != null) {
                this.isActive = true;
            }
        }
    }

    protected void updateContainerItem() {
        FluidStack containerStack = FluidHelper.getFluidStackFromContainerItem((ItemStack)this.inventory[0]);
        int prevID = this.renderFluid.fluidID;
        if (!this.reverse) {
            if (containerStack == null || FluidHelper.isFluidEqual((FluidStack)containerStack, (FluidStack)this.tank.getFluid())) {
                this.containerItem = (IFluidContainerItem)this.inventory[0].func_77973_b();
                this.renderFluid = this.tank.getFluid() == null ? null : this.tank.getFluid().copy();
            }
        } else if (containerStack != null && this.tank.getFluid() == null || FluidHelper.isFluidEqual((FluidStack)containerStack, (FluidStack)this.tank.getFluid())) {
            this.containerItem = (IFluidContainerItem)this.inventory[0].func_77973_b();
            this.renderFluid = containerStack;
        }
        if (this.renderFluid == null) {
            this.renderFluid = new FluidStack(FluidRegistry.WATER, 0);
        } else {
            this.renderFluid.amount = 0;
        }
        if (this.containerItem != null) {
            this.processMax = 192;
            this.processRem = 1;
            if (prevID != this.renderFluid.fluidID) {
                this.sendFluidPacket();
            }
        }
    }

    protected void updateContainerFill(int energy) {
        int filled;
        if (energy <= 0) {
            return;
        }
        int amount = Math.min(this.tank.getFluidAmount(), energy);
        int n = filled = this.tank.getFluid() == null ? 0 : this.containerItem.fill(this.inventory[0], new FluidStack(this.tank.getFluid(), amount), true);
        if (filled == 0) {
            this.processRem = 0;
            this.reverse = this.reverseFlag;
            this.transferProducts();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(this.field_70331_k);
            }
        } else {
            this.tank.drain(filled, true);
            this.energyStorage.modifyEnergyStored(-amount);
        }
    }

    protected void updateContainerEmpty(int energy) {
        if (energy <= 0) {
            return;
        }
        FluidStack drained = null;
        int amount = Math.min(this.tank.getSpace(), energy);
        if (amount > 0) {
            drained = this.containerItem.drain(this.inventory[0], amount, true);
        }
        if (drained == null) {
            this.processRem = 0;
            this.reverse = this.reverseFlag;
            this.transferProducts();
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(this.field_70331_k);
            }
        } else {
            this.tank.fill(drained, true);
            this.energyStorage.modifyEnergyStored(-drained.amount);
        }
    }

    @Override
    public boolean canAcceptItem(ItemStack stack, int slot, int side) {
        return slot == 0 ? FluidHelper.isFluidContainerItem((ItemStack)stack) || TransposerManager.isItemValid(stack) : true;
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public Payload getGuiPayload() {
        Payload payload = super.getGuiPayload();
        payload.addBool(this.reverse);
        payload.addBool(this.reverseFlag);
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    @Override
    public Payload getFluidPayload() {
        Payload payload = super.getFluidPayload();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    public Payload getModePayload() {
        Payload payload = super.getModePayload();
        payload.addBool(this.reverseFlag);
        return payload;
    }

    public void setMode(boolean mode) {
        this.reverseFlag = mode;
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.sendModePacket();
        }
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.renderFluid = payload.getFluidStack();
        } else {
            payload.getFluidStack();
        }
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.isActive = payload.getBool();
                this.processMax = payload.getInt();
                this.processRem = payload.getInt();
                this.energyStorage.setEnergyStored(payload.getInt());
                this.reverse = payload.getBool();
                this.reverseFlag = payload.getBool();
                this.tank.setFluid(payload.getFluidStack());
                return;
            }
            case FLUID: {
                this.renderFluid = payload.getFluidStack();
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                return;
            }
            case MODE: {
                this.reverseFlag = payload.getBool();
                if (!this.isActive) {
                    this.reverse = this.reverseFlag;
                }
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
                return;
            }
        }
    }

    public FluidTankAdv getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.outputTracker = nbt.func_74762_e("Tracker1");
        this.outputTrackerFluid = nbt.func_74762_e("Tracker2");
        this.reverseFlag = this.reverse = nbt.func_74767_n("Rev");
        this.tank.readFromNBT(nbt);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        } else if (TransposerManager.getExtractionRecipe(this.inventory[0]) != null) {
            this.renderFluid = TransposerManager.getExtractionRecipe(this.inventory[0]).getFluid();
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = super.func_70298_a(slot, amount);
        if (ServerHelper.isServerWorld((World)this.field_70331_k) && slot <= this.getMaxInputSlot() && this.isActive && (this.inventory[slot] == null || !this.hasValidInput())) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(this.field_70331_k);
            this.processRem = 0;
            this.containerItem = null;
            this.reverse = this.reverseFlag;
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (ServerHelper.isServerWorld((World)this.field_70331_k) && slot <= this.getMaxInputSlot()) {
            if (!(!this.isActive || this.inventory[slot] == null || stack != null && stack.func_77969_a(this.inventory[slot]) && this.hasValidInput())) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(this.field_70331_k);
                this.processRem = 0;
            }
            this.containerItem = null;
            this.reverse = this.reverseFlag;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public void func_70296_d() {
        if (this.isActive && !this.hasValidInput()) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(this.field_70331_k);
            this.processRem = 0;
            this.containerItem = null;
            this.reverse = this.reverseFlag;
        }
        super.func_70296_d();
    }

    @Override
    public Icon getBlockTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return IconRegistry.getIcon((String)"MachineBottom");
            }
            if (side == 1) {
                return IconRegistry.getIcon((String)"MachineTop");
            }
            return side != this.facing ? IconRegistry.getIcon((String)"MachineSide") : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : IconRegistry.getIcon((String)"MachineFace_", (int)this.getType()));
        }
        return side != this.facing ? IconRegistry.getIcon((String)TEProps.textureSelection, (int)TileTransposer.sideData[this.getType()].sideTex[this.sideCache[side]]) : (this.isActive ? IconRegistry.getIcon((String)"MachineActive_", (int)this.getType()) : IconRegistry.getIcon((String)"MachineFace_", (int)this.getType()));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Tracker1", this.outputTracker);
        nbt.func_74768_a("Tracker2", this.outputTrackerFluid);
        nbt.func_74757_a("Rev", this.reverse);
        this.tank.writeToNBT(nbt);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.reverse || from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] != 1) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.reverse || from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] != 3) {
            return null;
        }
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.reverse || from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] != 3) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.UNKNOWN) {
            return false;
        }
        return !this.reverse && this.sideCache[from.ordinal()] == 1;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.reverse && this.sideCache[from.ordinal()] == 3;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

