/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.entity.projectile;

import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.EntityRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.item.tool.ItemFlorb;
import thermalexpansion.util.Utils;

public class EntityFlorb
extends EntityThrowable {
    public static ItemStack blockCheck = new ItemStack(Block.field_71981_t);
    protected Fluid fluid;
    protected float gravity = 0.03f;

    public static void initialize() {
        EntityRegistry.registerModEntity(EntityFlorb.class, (String)"florb", (int)Utils.getEntityId(), (Object)ThermalExpansion.instance, (int)64, (int)1, (boolean)true);
    }

    public EntityFlorb(World world) {
        super(world);
    }

    public EntityFlorb(World world, Fluid fluid) {
        super(world);
        this.fluid = fluid;
        this.setGravity();
        this.setSyncFluid();
    }

    public EntityFlorb(World world, EntityLivingBase entity, Fluid fluid) {
        super(world, entity);
        this.fluid = fluid;
        this.setGravity();
        this.setSyncFluid();
    }

    public EntityFlorb(World world, double x, double y, double z, Fluid fluid) {
        super(world, x, y, z);
        this.fluid = fluid;
        this.setGravity();
        this.setSyncFluid();
    }

    public EntityFlorb(World world, Fluid fluid, int velocity) {
        this(world, fluid);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 1.0f);
    }

    public EntityFlorb(World world, EntityLivingBase entity, Fluid fluid, int velocity) {
        this(world, entity, fluid);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 1.0f);
    }

    public EntityFlorb(World world, double x, double y, double z, Fluid fluid, int velocity) {
        this(world, x, y, z, fluid);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 1.0f);
    }

    protected void setGravity() {
        if (this.fluid.getDensity() < 0) {
            this.gravity = MathHelper.minF((float)0.01f, (float)(0.03f + 0.03f * (float)this.fluid.getDensity() / 1000.0f));
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public void setSyncFluid() {
        this.field_70180_af.func_75692_b(16, (Object)this.fluid.getID());
    }

    public Fluid getSyncFluid() {
        return FluidRegistry.getFluid((int)this.field_70180_af.func_75679_c(16));
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    protected float func_70185_h() {
        return this.gravity;
    }

    public void func_70030_z() {
        if (this.fluid == null && ServerHelper.isClientWorld((World)this.field_70170_p)) {
            this.fluid = this.getSyncFluid();
        }
        super.func_70030_z();
    }

    protected void func_70017_D() {
        int j1;
        int i1;
        int l;
        int k;
        int j;
        int i = net.minecraft.util.MathHelper.func_76128_c((double)(this.field_70121_D.field_72340_a + 0.001));
        if (this.field_70170_p.func_72904_c(i, j = net.minecraft.util.MathHelper.func_76128_c((double)(this.field_70121_D.field_72338_b + 0.001)), k = net.minecraft.util.MathHelper.func_76128_c((double)(this.field_70121_D.field_72339_c + 0.001)), l = net.minecraft.util.MathHelper.func_76128_c((double)(this.field_70121_D.field_72336_d - 0.001)), i1 = net.minecraft.util.MathHelper.func_76128_c((double)(this.field_70121_D.field_72337_e - 0.001)), j1 = net.minecraft.util.MathHelper.func_76128_c((double)(this.field_70121_D.field_72334_f - 0.001)))) {
            for (int k1 = i; k1 <= l; ++k1) {
                for (int l1 = j; l1 <= i1; ++l1) {
                    for (int i2 = k; i2 <= j1; ++i2) {
                        int j2 = this.field_70170_p.func_72798_a(k1, l1, i2);
                        if (j2 <= 0) continue;
                        Block.field_71973_m[j2].func_71869_a(this.field_70170_p, k1, l1, i2, (Entity)this);
                    }
                }
            }
        }
    }

    protected void func_70184_a(MovingObjectPosition pos) {
        int x = pos.field_72311_b;
        int y = pos.field_72312_c;
        int z = pos.field_72309_d;
        if (pos.field_72308_g != null) {
            x = (int)pos.field_72308_g.field_70165_t;
            y = (int)pos.field_72308_g.field_70163_u + 1;
            z = (int)pos.field_72308_g.field_70161_v;
            pos.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 0.0f);
        }
        if (this.field_70170_p.func_72798_a(x, y, z) != Block.field_72037_aS.field_71990_ca) {
            switch (pos.field_72310_e) {
                case 0: {
                    --y;
                    break;
                }
                case 1: {
                    ++y;
                    break;
                }
                case 2: {
                    --z;
                    break;
                }
                case 3: {
                    ++z;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                    break;
                }
            }
        }
        if (ServerHelper.isServerWorld((World)this.field_70170_p)) {
            if (this.func_85052_h() instanceof EntityPlayer && !((EntityPlayer)this.func_85052_h()).func_82247_a(x, y, z, pos.field_72310_e, blockCheck)) {
                ItemFlorb.dropFlorb(this.getFluid(), this.field_70170_p, x, y, z);
                this.func_70106_y();
                return;
            }
            int bId = this.fluid.getBlockID();
            if (this.fluid.getName() == "water" || this.fluid.getName() == "lava") {
                --bId;
            }
            if (this.field_70170_p.func_72799_c(x, y, z) || this.field_70170_p.func_72803_f(x, y, z) == Material.field_76250_n || this.field_70170_p.func_72798_a(x, y, z) == Block.field_72037_aS.field_71990_ca) {
                if (this.fluid.getName() != "water" || !this.field_70170_p.func_72807_a((int)(x / 16), (int)(z / 16)).field_76791_y.toLowerCase().equals("hell")) {
                    this.field_70170_p.func_72832_d(x, y, z, bId, 0, 3);
                    this.field_70170_p.func_72845_h(x, y, z);
                }
            } else {
                ItemFlorb.dropFlorb(this.getFluid(), this.field_70170_p, x, y, z);
            }
        }
        this.func_70106_y();
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.fluid = FluidRegistry.getFluid((String)nbt.func_74779_i("Fluid"));
        if (this.fluid == null) {
            this.fluid = FluidRegistry.WATER;
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("Fluid", this.fluid.getName());
    }
}

