/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.network.packets;

import appeng.api.IItemList;
import appeng.api.Util;
import appeng.api.config.ItemFlow;
import appeng.api.config.MatchingMode;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.network.AppEngPacket;
import appeng.me.container.ContainerPatternEncoder;
import appeng.me.container.ContainerPreformatter;
import appeng.me.container.ContainerStorageBus;
import appeng.me.tile.TilePatternEncoder;
import appeng.me.tile.TileStorageBus;
import appeng.util.ItemList;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;

public class PacketGuiButtonAction
extends AppEngPacket {
    final String name;
    final PlayerTileBtn action;

    @Override
    public void serverPacketData(INetworkManager manager, AppEngPacket packet, Player player) {
        try {
            EntityPlayerMP p = (EntityPlayerMP)player;
            switch (this.action) {
                case StorageBusSetByStorage: {
                    if (!(p.field_71070_bA instanceof ContainerStorageBus)) break;
                    ContainerStorageBus csb = (ContainerStorageBus)p.field_71070_bA;
                    TileStorageBus tsb = (TileStorageBus)csb.getTile();
                    IMEInventoryHandler han = tsb.getReadWriteCell();
                    if (han != null) {
                        han.setFlow(ItemFlow.READ_WRITE);
                        tsb.updating = true;
                        IItemList l = han.getAvailableItems();
                        tsb.updating = false;
                        List<ItemStack> list = l.getItems();
                        for (int x = 0; x < tsb.storeable.func_70302_i_(); ++x) {
                            if (x < list.size()) {
                                tsb.storeable.func_70299_a(x, list.get(x));
                                continue;
                            }
                            tsb.storeable.func_70299_a(x, null);
                        }
                        p.field_71070_bA.func_75142_b();
                    }
                    break;
                }
                case PartitionEditorSetByStorage: {
                    if (!(p.field_71070_bA instanceof ContainerPreformatter)) break;
                    ContainerPreformatter c = (ContainerPreformatter)p.field_71070_bA;
                    ItemStack fish = c.tileEntity.cellinv.func_70301_a(0);
                    if (fish != null && Util.getCell(fish) != null) {
                        IMEInventoryHandler sc = Util.getCell(fish);
                        IItemList l = sc.getAvailableItems();
                        List<ItemStack> list = l.getItems();
                        for (int x = 0; x < c.tileEntity.types.func_70302_i_(); ++x) {
                            if (x < list.size()) {
                                c.tileEntity.types.func_70299_a(x, list.get(x));
                                continue;
                            }
                            c.tileEntity.types.func_70299_a(x, null);
                        }
                        p.field_71070_bA.func_75142_b();
                    }
                    break;
                }
                case PatternEncoderClear: {
                    if (!(p.field_71070_bA instanceof ContainerPatternEncoder)) break;
                    ContainerPatternEncoder c = (ContainerPatternEncoder)p.field_71070_bA;
                    ((TilePatternEncoder)c.getTile()).clearConfig();
                    break;
                }
                case PatternEncoderEncode: {
                    if (!(p.field_71070_bA instanceof ContainerPatternEncoder)) break;
                    ContainerPatternEncoder c = (ContainerPatternEncoder)p.field_71070_bA;
                    c.getTile().pulseRedStone();
                    break;
                }
                case PartitionEditorSet: {
                    if (!(p.field_71070_bA instanceof ContainerPreformatter)) break;
                    ContainerPreformatter c = (ContainerPreformatter)p.field_71070_bA;
                    ItemStack fish = c.tileEntity.cellinv.func_70301_a(0);
                    if (fish != null && Util.getCell(fish) != null) {
                        IMEInventoryHandler sc = Util.getCell(fish);
                        if (sc != null) {
                            sc.setPreformattedItems(c.tileEntity.types.getIMEI().getAvailableItems(new ItemList()), c.tileEntity.fMode, c.tileEntity.lMode);
                            sc.setName(this.name);
                            sc.setFuzzyPreformatted(c.tileEntity.mMode == MatchingMode.Fuzzy);
                            c.tileEntity.cellinv.func_70296_d();
                            p.func_71111_a((Container)c, 0, fish);
                        }
                        break;
                    }
                    for (int x = 0; x < c.tileEntity.types.func_70302_i_(); ++x) {
                        c.tileEntity.types.func_70299_a(x, null);
                    }
                    c.updateClient();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public PacketGuiButtonAction(DataInputStream stream) throws IOException {
        this.action = PlayerTileBtn.values()[stream.readByte()];
        this.name = stream.readUTF();
    }

    public PacketGuiButtonAction(PlayerTileBtn act, String msg) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        this.action = act;
        data.writeInt(this.getPacketID());
        data.writeByte(act.ordinal());
        this.name = msg;
        data.writeUTF(this.name);
        this.isChunkDataPacket = false;
        this.configureWrite(bytes.toByteArray());
    }

    public static enum PlayerTileBtn {
        PatternEncoderClear,
        PatternEncoderEncode,
        PartitionEditorSet,
        PartitionEditorSetByStorage,
        StorageBusSetByStorage;

    }
}

