/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.network.packets;

import appeng.common.AppEng;
import appeng.common.network.AppEngPacket;
import appeng.render.EnergyFx;
import appeng.util.Platform;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.Item;
import net.minecraft.network.INetworkManager;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class PacketTransitionPlane
extends AppEngPacket {
    public final double x;
    public final double y;
    public final double z;
    public final ForgeDirection d;
    public final boolean mode;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkManager network, AppEngPacket packet, Player player) {
        int l;
        World world = AppEng.getInstance().SideProxy.getWorld();
        for (int zz = 0; zz < (this.mode ? 32 : 8); ++zz) {
            EnergyFx fx = new EnergyFx(world, this.x + (this.mode ? (double)(Platform.getRandomInt() % 100) * 0.01 : (double)(Platform.getRandomInt() % 100) * 0.005 - 0.25), this.y + (this.mode ? (double)(Platform.getRandomInt() % 100) * 0.01 : (double)(Platform.getRandomInt() % 100) * 0.005 - 0.25), this.z + (this.mode ? (double)(Platform.getRandomInt() % 100) * 0.01 : (double)(Platform.getRandomInt() % 100) * 0.005 - 0.25), Item.field_77702_n);
            if (!this.mode) {
                fx.fromItem(this.d);
            }
            fx.field_70159_w = -0.1 * (double)this.d.offsetX;
            fx.field_70181_x = -0.1 * (double)this.d.offsetY;
            fx.field_70179_y = -0.1 * (double)this.d.offsetZ;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        if (this.mode && (l = world.func_72798_a((int)this.x, (int)this.y, (int)this.z)) > 0) {
            Block block = Block.field_71973_m[l];
            Minecraft.func_71410_x().field_71416_A.func_77364_b(block.field_72020_cn.func_72676_a(), (float)this.x + 0.5f, (float)this.y + 0.5f, (float)this.z + 0.5f, (block.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, block.field_72020_cn.func_72678_c() * 0.8f);
        }
    }

    public PacketTransitionPlane(DataInputStream stream) throws IOException {
        this.x = stream.readFloat();
        this.y = stream.readFloat();
        this.z = stream.readFloat();
        this.d = ForgeDirection.getOrientation((int)stream.readByte());
        this.mode = stream.readBoolean();
    }

    public PacketTransitionPlane(float x, float y, float z, ForgeDirection d, boolean mode) throws IOException {
        this.x = x;
        this.y = y;
        this.z = z;
        this.d = d;
        this.mode = mode;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        data.writeInt(this.getPacketID());
        data.writeFloat(x);
        data.writeFloat(y);
        data.writeFloat(z);
        data.writeByte(d.ordinal());
        data.writeBoolean(mode);
        this.isChunkDataPacket = false;
        this.configureWrite(bytes.toByteArray());
    }
}

