/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.exceptions.AppEngException;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.interfaces.INetworkNotifiable;
import appeng.me.MEInventoryArray;
import appeng.util.ItemList;
import appeng.util.Platform;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class MEInventoryNetwork
extends MEInventoryArray {
    INetworkNotifiable tc;
    ItemList list;
    boolean registerInputs = true;
    static LinkedList<IGridInterface> networkDepths = new LinkedList();

    protected MEInventoryNetwork(List<IMEInventoryHandler> List2, INetworkNotifiable tcon, ItemList il) throws AppEngException {
        super(List2);
        this.tc = tcon;
        this.list = il;
    }

    public static IMEInventoryHandler getMEInventoryNetwork(List<IMEInventoryHandler> o, INetworkNotifiable tcon, ItemList il) {
        try {
            return new MEInventoryNetwork(o, tcon, il);
        }
        catch (AppEngException appEngException) {
            return null;
        }
    }

    public boolean checkRecurrsion(MEInventoryNetwork net) {
        for (IGridInterface o : networkDepths) {
            if (o != net.getGrid()) continue;
            return false;
        }
        networkDepths.push(net.getGrid());
        return true;
    }

    public void endRecurssion(MEInventoryNetwork net) {
        IGridInterface oldNet = networkDepths.pop();
        if (oldNet != net.getGrid()) {
            throw new RuntimeException("Invalid Network Recussion Detected");
        }
    }

    @Override
    public IAEItemStack addItems(IAEItemStack input) {
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        IAEItemStack notAdded = input;
        if (this.checkRecurrsion(this)) {
            if (AppEngConfiguration.logTransaction) {
                AppEng.log(this.tc.getName() + ": addItem " + input.getStackSize() + " : " + Platform.getSharedItemStack(input).func_77977_a());
            }
            IAEItemStack original = input.copy();
            notAdded = super.addItems(input);
            if (notAdded != null && AppEngConfiguration.logTransaction) {
                AppEng.log(this.tc.getName() + ": addItem but rejected " + notAdded.getStackSize() + " : " + Platform.getSharedItemStack(notAdded).func_77977_a());
            }
            if (notAdded == null) {
                if (this.registerInputs) {
                    this.tc.notifyAddItems(original);
                }
            } else if (notAdded.getStackSize() != original.getStackSize()) {
                original.decStackSize(notAdded.getStackSize());
                if (this.registerInputs) {
                    this.tc.notifyAddItems(original);
                }
            }
            this.endRecurssion(this);
        }
        return notAdded;
    }

    @Override
    public IAEItemStack calculateItemAddition(IAEItemStack input) {
        IAEItemStack o = input;
        if (this.checkRecurrsion(this)) {
            o = super.calculateItemAddition(input);
            this.endRecurssion(this);
        }
        return o;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request) {
        if (request == null) {
            return null;
        }
        if (request.getStackSize() == 0L) {
            return null;
        }
        IAEItemStack removed = null;
        if (this.checkRecurrsion(this)) {
            removed = super.extractItems(request);
            if (removed != null && AppEngConfiguration.logTransaction) {
                AppEng.log(this.tc.getName() + ": extractItems " + removed.getStackSize() + " : " + Platform.getSharedItemStack(removed).func_77977_a());
            }
            if (removed != null) {
                this.tc.notifyExtractItems(removed);
            }
            this.endRecurssion(this);
        }
        return removed;
    }

    @Override
    public void setUpdateTarget(TileEntity e) {
    }

    @Override
    public IItemList getAvailableItems(IItemList out) {
        if (this.checkRecurrsion(this)) {
            ((ItemList)out).resetStatus();
            super.getAvailableItems(out);
            this.endRecurssion(this);
            return out;
        }
        return out;
    }

    @Override
    public IItemList getAvailableItems() {
        if (this.checkRecurrsion(this)) {
            this.list.resetStatus();
            super.getAvailableItems(this.list);
            this.list.clean();
            this.endRecurssion(this);
            return this.list;
        }
        return new ItemList();
    }
}

