/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.basetiles;

import Reika.RotaryCraft.API.ShaftPowerReceiver;
import appeng.api.TileRef;
import appeng.api.config.ItemFlow;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IMEPowerStorage;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.base.AppEngMultiBlock;
import appeng.me.basetiles.TileME;
import appeng.util.Platform;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.compatibility.Compatibility;
import universalelectricity.core.block.IElectrical;
import universalelectricity.core.electricity.ElectricityPack;

public abstract class TilePoweredBase
extends TileME
implements ShaftPowerReceiver,
IElectrical,
IPowerReceptor,
IEnergySink,
IMEPowerStorage,
IEnergyHandler {
    public float maxStoredPower;
    public float storedPower;
    public boolean isOnUE = false;
    protected float pushQty = 256.0f;
    private PowerHandler bcPowerhandler;
    int rcOmega;
    int rcTorque;
    long rcPower;

    @Override
    public double getMEMaxPower() {
        return this.maxStoredPower;
    }

    @Override
    public double getMECurrentPower() {
        return this.storedPower;
    }

    protected List<TileRef<IMEPowerStorage>> getPowerRequesters() {
        return new LinkedList<TileRef<IMEPowerStorage>>();
    }

    protected List<TileRef<IMEPowerStorage>> getPowerProviders() {
        return new LinkedList<TileRef<IMEPowerStorage>>();
    }

    @Override
    public ItemFlow getPowerFlow() {
        return ItemFlow.READ;
    }

    public float getRequiredPower() {
        float req = this.maxStoredPower - this.storedPower;
        for (TileRef<IMEPowerStorage> ps : this.getPowerRequesters()) {
            try {
                IMEPowerStorage psx = ps.getTile();
                if (psx.getPowerFlow() != ItemFlow.READ) {
                    req = (float)((double)req + (psx.getMEMaxPower() - psx.getMECurrentPower()));
                }
            }
            catch (AppEngTileMissingException e) {
                e.printStackTrace();
            }
            if (!(req > 200000.0f)) continue;
            return req;
        }
        if (req < 0.0f) {
            req = 0.0f;
        }
        return req;
    }

    public double addPowerToNetwork(double power, boolean returnExtra) {
        if (power < 0.01) {
            return power;
        }
        this.storedPower = (float)((double)this.storedPower + power);
        if (this.storedPower > this.maxStoredPower + this.pushQty) {
            Iterator<TileRef<IMEPowerStorage>> i;
            double Extra = this.storedPower - this.maxStoredPower;
            this.storedPower = this.maxStoredPower;
            int iterations = 8;
            for (int x = 0; x < iterations && (i = this.getPowerRequesters().iterator()).hasNext(); ++x) {
                TileRef<IMEPowerStorage> ps = i.next();
                try {
                    IMEPowerStorage psx = ps.getTile();
                    if (psx.getPowerFlow() == ItemFlow.READ) continue;
                    double adding = Extra;
                    if (Math.abs(adding - (Extra = psx.addMEPower(Extra))) < 0.01) {
                        this.getPowerRequesters().remove(ps);
                    }
                    if (!(Extra < 0.001)) continue;
                    return 0.0;
                }
                catch (AppEngTileMissingException e) {
                    e.printStackTrace();
                }
            }
            if (returnExtra && (double)this.storedPower + Extra > (double)(this.maxStoredPower + this.pushQty)) {
                return Extra;
            }
            this.storedPower = (float)((double)this.storedPower + Extra);
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public void updateTileEntity() {
        double requiredPower;
        if (Platform.isClient()) {
            return;
        }
        if (AppEng.getInstance().BCProxy != null && this.getPowerProvider() != null && AppEngConfiguration.requirePower && (requiredPower = (double)this.getRequiredPower()) > 0.0) {
            float want = (float)requiredPower / 5.0f;
            if (want < 0.0f) {
                want = 0.0f;
            }
            float used = this.getPowerProvider().useEnergy(1.0f, Math.min(want, this.getPowerProvider().getMaxEnergyStored()), true);
            this.addPowerToNetwork(used * 5.0f, false);
            this.onUpdatePower();
        }
        if (this.rcPower > 0L) {
            this.addPowerToNetwork((double)this.rcPower / 11256.0, true);
            this.onUpdatePower();
        }
    }

    protected abstract int getMaxStoredPower();

    @Override
    public void func_70313_j() {
        super.func_70313_j();
    }

    @Override
    public void init() {
        super.init();
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    @Override
    public void postInit() {
        super.postInit();
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return AppEngConfiguration.requirePower;
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return AppEngConfiguration.requirePower;
    }

    public double demandedEnergyUnits() {
        if (!AppEngConfiguration.requirePower) {
            return 0.0;
        }
        double diff = this.getRequiredPower() / 2.0f;
        return diff > 0.0 ? diff : 0.0;
    }

    @Override
    public double addMEPower(double amt) {
        if (!AppEngConfiguration.requirePower) {
            return amt;
        }
        float old = this.storedPower;
        this.storedPower = (float)((double)this.storedPower + amt);
        if (this.storedPower > this.maxStoredPower) {
            int diff = (int)Math.ceil(this.storedPower - this.maxStoredPower);
            this.storedPower = this.maxStoredPower;
            this.onUpdatePower();
            return diff;
        }
        this.onUpdatePower();
        return 0.0;
    }

    public void onUpdatePower() {
    }

    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (!AppEngConfiguration.requirePower) {
            return amount;
        }
        double reminder = this.addPowerToNetwork(2.0 * amount, false) / 2.0;
        this.onUpdatePower();
        return reminder;
    }

    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    public void doWork(PowerHandler workProvider) {
    }

    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.getPowerProvider().getPowerReceiver();
    }

    public PowerHandler getPowerProvider() {
        if (this.bcPowerhandler == null) {
            this.bcPowerhandler = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);
            if (this.bcPowerhandler != null) {
                this.bcPowerhandler.configure(1.0f, 320.0f, 800.0f, 640.0f);
            }
        }
        return this.bcPowerhandler;
    }

    @Override
    public void func_70307_a(NBTTagCompound tagCompound) {
        try {
            super.func_70307_a(tagCompound);
            this.storedPower = tagCompound.func_74762_e("storedPower");
            try {
                this.getPowerProvider().readFromNBT(tagCompound);
            }
            catch (Throwable _) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tagCompound) {
        try {
            super.func_70310_b(tagCompound);
            tagCompound.func_74768_a("storedPower", (int)this.storedPower);
            try {
                this.getPowerProvider().writeToNBT(tagCompound);
            }
            catch (Throwable _) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    float getUERatio() {
        return 1.0f / (Compatibility.TO_BC_RATIO * 5.0f);
    }

    public boolean canConnect(ForgeDirection direction) {
        return AppEngConfiguration.requirePower;
    }

    public float receiveElectricity(ForgeDirection from, ElectricityPack receive, boolean doReceive) {
        if (receive == null) {
            return 0.0f;
        }
        float unused = 0.0f;
        if (doReceive) {
            float energy = receive.getWatts() / this.getUERatio();
            unused = (float)this.addPowerToNetwork(energy, true);
            this.onUpdatePower();
        }
        return receive.getWatts() - unused;
    }

    public ElectricityPack provideElectricity(ForgeDirection from, ElectricityPack request, boolean doProvide) {
        return null;
    }

    public float getRequest(ForgeDirection direction) {
        if (!AppEngConfiguration.requirePower) {
            return 0.0f;
        }
        int diff = (int)Math.floor(this.getRequiredPower() * this.getUERatio());
        return diff > 0 ? (float)diff : 0.0f;
    }

    public float getProvide(ForgeDirection direction) {
        return 0.0f;
    }

    public float getVoltage() {
        return 120.0f;
    }

    public int getOmega() {
        return this.rcOmega;
    }

    public int getTorque() {
        return this.rcTorque;
    }

    public long getPower() {
        return this.rcPower;
    }

    public int getIORenderAlpha() {
        return 0;
    }

    public void setIORenderAlpha(int io) {
    }

    public int getMachineX() {
        return this.field_70329_l;
    }

    public int getMachineY() {
        return this.field_70330_m;
    }

    public int getMachineZ() {
        return this.field_70327_n;
    }

    public void setOmega(int omega) {
        this.rcOmega = omega;
    }

    public void setTorque(int torque) {
        this.rcTorque = torque;
    }

    public void setPower(long power) {
        this.rcPower = power;
        if (Platform.isClient()) {
            return;
        }
        if (!AppEngConfiguration.requirePower) {
            return;
        }
    }

    public boolean canReadFromBlock(int x, int y, int z) {
        return true;
    }

    public boolean isReceiving() {
        return true;
    }

    public void noInputMachine() {
        this.rcTorque = 0;
        this.rcPower = 0L;
        this.rcOmega = 0;
    }

    public String getName() {
        if (Platform.isClient()) {
            try {
                int meta = this.func_70322_n();
                AppEngMultiBlock mb = (AppEngMultiBlock)this.func_70311_o();
                return mb.getName(meta);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "AppEng";
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!AppEngConfiguration.requirePower) {
            return 0;
        }
        if (simulate) {
            int diff = (int)(this.getRequiredPower() * 2.0f);
            return diff > 0 ? diff : 0;
        }
        double reminder = this.addPowerToNetwork(0.5 * (double)maxReceive, true) * 2.0;
        this.onUpdatePower();
        return (int)((double)maxReceive - reminder);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canInterface(ForgeDirection from) {
        return AppEngConfiguration.requirePower;
    }

    public int getEnergyStored(ForgeDirection from) {
        return (int)(this.storedPower * 2.0f);
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)(this.maxStoredPower * 2.0f);
    }
}

