/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile.P2PTunnel;

import appeng.me.METhrottle;
import appeng.me.tile.TileP2PTunnel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileP2PLiquids
extends TileP2PTunnel
implements IFluidHandler {
    IFluidHandler cachedTank;
    METhrottle tr = new METhrottle(1, 1, 20);
    private int tmpUsed;

    private FluidTankInfo[] getTank() {
        TileP2PLiquids tun;
        if (this.output ? (tun = (TileP2PLiquids)this.getInput()) != null : this.getOutputs().size() > 0) {
            return new FluidTankInfo[]{new FluidTankInfo(null, 10000)};
        }
        return new FluidTankInfo[]{new FluidTankInfo(null, 0)};
    }

    @Override
    public float getPowerDrainPerTick() {
        return 2.0f;
    }

    @Override
    public boolean requiresTickingUpdates() {
        return true;
    }

    @Override
    public void updateTileEntity() {
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
    }

    @Override
    public String getTunnelTip() {
        return "AppEng.GuiITooltip.P2PFluidTunnel";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getTypeTexture() {
        return Block.field_71948_O.func_71851_a(0);
    }

    List<TileP2PLiquids> getOutputs(Fluid input) {
        LinkedList<TileP2PLiquids> outs = new LinkedList<TileP2PLiquids>();
        for (TileP2PTunnel tun : this.getOutputs()) {
            if (!(tun instanceof TileP2PLiquids)) continue;
            TileP2PLiquids l = (TileP2PLiquids)tun;
            IFluidHandler targ = this.getTarget();
            if (targ == null || !targ.canFill(this.orientation.getOpposite(), input)) continue;
            outs.add(l);
        }
        return outs;
    }

    @Override
    public void onNeighborBlockChange() {
        this.cachedTank = null;
    }

    IFluidHandler getTarget() {
        if (this.cachedTank != null) {
            return this.cachedTank;
        }
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + this.orientation.offsetX, this.field_70330_m + this.orientation.offsetY, this.field_70327_n + this.orientation.offsetZ);
        if (te instanceof IFluidHandler) {
            this.cachedTank = (IFluidHandler)te;
            return this.cachedTank;
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        List<TileP2PLiquids> list = this.getOutputs(resource.getFluid());
        int requestTotal = 0;
        Iterator<TileP2PLiquids> i = list.iterator();
        while (i.hasNext()) {
            TileP2PLiquids l = i.next();
            IFluidHandler tank = l.getTarget();
            l.tmpUsed = tank != null ? tank.fill(l.orientation.getOpposite(), resource.copy(), false) : 0;
            if (l.tmpUsed <= 0) {
                i.remove();
                continue;
            }
            requestTotal += l.tmpUsed;
        }
        if (requestTotal <= 0) {
            return 0;
        }
        if (!doFill) {
            return Math.min(resource.amount, requestTotal);
        }
        int avilable = resource.amount;
        int used = 0;
        for (TileP2PLiquids l : list) {
            IFluidHandler tank;
            FluidStack insert = resource.copy();
            insert.amount = (int)Math.ceil((double)insert.amount * ((double)l.tmpUsed / (double)requestTotal));
            if (insert.amount > avilable) {
                insert.amount = avilable;
            }
            l.tmpUsed = (tank = l.getTarget()) != null ? tank.fill(l.orientation.getOpposite(), insert.copy(), true) : 0;
            avilable -= insert.amount;
            used += insert.amount;
        }
        return used;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return !this.output && from.equals((Object)this.orientation) && !this.getOutputs(fluid).isEmpty();
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from.equals((Object)this.orientation)) {
            return this.getTank();
        }
        return new FluidTankInfo[0];
    }
}

