/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.DimentionalCoord;
import appeng.api.TileRef;
import appeng.api.Util;
import appeng.api.events.MultiBlockUpdateEvent;
import appeng.api.exceptions.AppEngTileMissingException;
import appeng.api.me.tiles.IAssemblerMB;
import appeng.api.me.tiles.IFulllyOptionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.util.IAssemblerCluster;
import appeng.common.AppEng;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.common.network.packets.PacketBulkMAC;
import appeng.interfaces.IBulkNetworkTile;
import appeng.me.basetiles.TileME;
import appeng.me.crafting.AssemblerCluster;
import appeng.me.tile.TileAssembler;
import appeng.render.AppEngBlockRenderer;
import appeng.util.Platform;
import appeng.util.inv.WrapperChainedInventory;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileAssemblerMB
extends TileME
implements IInventory,
IBulkNetworkTile,
IFulllyOptionalMETile,
IGridMachine,
IAssemblerMB {
    public boolean complete;
    public AssemblerCluster ac;
    private boolean isEdge;
    long instanceCalc = Long.MIN_VALUE;
    int state = -1;

    public TileAssemblerMB() {
        this.updatesOnPower = false;
    }

    @Override
    public long markViewed(long inst) {
        long old = this.instanceCalc;
        this.instanceCalc = inst;
        return old;
    }

    @Override
    protected void terminate() {
        super.terminate();
        if (this.ac != null) {
            this.ac.destroy();
        }
        this.ac = null;
    }

    @Override
    public IAssemblerCluster getCluster() {
        return this.ac;
    }

    @Override
    public boolean isComplete() {
        return this.complete || this.ac != null;
    }

    @Override
    public void calculateMultiblock(long instanceCalc) {
        TileAssembler.calculateMultiblockR(this, instanceCalc);
    }

    @Override
    public void init() {
        super.init();
        this.isEdge = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n) != AppEng.getInstance().registration.blkCraftingAccelerator.getMetaData();
        this.onNeighborBlockChange();
    }

    public int getState() {
        int o = 0;
        if (AppEng.getInstance().GridManager.getEntityFromCoord(new DimentionalCoord(this.field_70331_k, this.field_70329_l - 1, this.field_70330_m, this.field_70327_n)) != null) {
            o |= 1;
        }
        if (AppEng.getInstance().GridManager.getEntityFromCoord(new DimentionalCoord(this.field_70331_k, this.field_70329_l + 1, this.field_70330_m, this.field_70327_n)) != null) {
            o |= 2;
        }
        if (AppEng.getInstance().GridManager.getEntityFromCoord(new DimentionalCoord(this.field_70331_k, this.field_70329_l, this.field_70330_m - 1, this.field_70327_n)) != null) {
            o |= 4;
        }
        if (AppEng.getInstance().GridManager.getEntityFromCoord(new DimentionalCoord(this.field_70331_k, this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) != null) {
            o |= 8;
        }
        if (AppEng.getInstance().GridManager.getEntityFromCoord(new DimentionalCoord(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n - 1)) != null) {
            o |= 0x10;
        }
        if (AppEng.getInstance().GridManager.getEntityFromCoord(new DimentionalCoord(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n + 1)) != null) {
            o |= 0x20;
        }
        return o;
    }

    @Override
    public void onNeighborBlockChange() {
        if (this.isEdge) {
            int newState = this.getState();
            int oldState = this.state;
            if (this.state != newState) {
                this.state = newState;
                MinecraftForge.EVENT_BUS.post((Event)new MultiBlockUpdateEvent(this, this.field_70331_k, this.getLocation()));
            }
        }
    }

    @Override
    public float getPowerDrainPerTick() {
        AppEngMultiBlock block = (AppEngMultiBlock)this.func_70311_o();
        AppEngSubBlock sb = block.getSubBlock(this.func_70322_n());
        if (sb == AppEng.getInstance().registration.blkAssemblerFieldWall || sb == AppEng.getInstance().registration.blkHeatVent) {
            return 0.0f;
        }
        return this.ac != null ? 1.0f : 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        AppEngBlockRenderer AppEngRenderer = AppEngBlockRenderer.instance;
        AppEngSubBlock sb = ((AppEngMultiBlock)block).getSubBlock(this.func_70322_n());
        if (this.complete) {
            if (sb == AppEng.getInstance().registration.blkHeatVent) {
                block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                AppEngRenderer.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockHeatVentMerged.get());
                renderer.func_83018_a(block);
                renderer.func_78570_q(block, x, y, z);
                AppEngRenderer.setOverrideBlockTexture(block, null);
                return true;
            }
            if (sb == AppEng.getInstance().registration.blkAssemblerFieldWall) {
                boolean ZAxis;
                boolean XAxis = world.func_72796_p(x + 1, y, z) instanceof TileAssemblerMB && world.func_72796_p(x - 1, y, z) instanceof TileAssemblerMB;
                boolean YAxis = world.func_72796_p(x, y + 1, z) instanceof TileAssemblerMB && world.func_72796_p(x, y - 1, z) instanceof TileAssemblerMB;
                boolean bl = ZAxis = world.func_72796_p(x, y, z + 1) instanceof TileAssemblerMB && world.func_72796_p(x, y, z - 1) instanceof TileAssemblerMB;
                if (XAxis) {
                    block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    AppEngRenderer.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockContainmentWallMerged.get());
                    renderer.func_83018_a(block);
                    renderer.func_78570_q(block, x, y, z);
                    AppEngRenderer.setOverrideBlockTexture(block, null);
                    return true;
                }
                if (YAxis) {
                    renderer.field_78683_h = 1;
                    renderer.field_78662_g = 1;
                    renderer.field_78679_j = 1;
                    renderer.field_78685_i = 1;
                    block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    AppEngRenderer.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockContainmentWallMerged.get());
                    renderer.func_83018_a(block);
                    renderer.func_78570_q(block, x, y, z);
                    AppEngRenderer.setOverrideBlockTexture(block, null);
                    renderer.field_78683_h = 0;
                    renderer.field_78662_g = 0;
                    renderer.field_78679_j = 0;
                    renderer.field_78685_i = 0;
                    return true;
                }
                if (ZAxis) {
                    renderer.field_78681_k = 1;
                    renderer.field_78675_l = 1;
                    block.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    AppEngRenderer.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockContainmentWallMerged.get());
                    renderer.func_83018_a(block);
                    renderer.func_78570_q(block, x, y, z);
                    AppEngRenderer.setOverrideBlockTexture(block, null);
                    renderer.field_78681_k = 0;
                    renderer.field_78675_l = 0;
                    return true;
                }
            }
        }
        return super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        AppEngMultiBlock block = (AppEngMultiBlock)this.func_70311_o();
        AppEngSubBlock sb = block.getSubBlock(this.func_70322_n());
        return sb.getBlockTextureFromSide(side.ordinal());
    }

    @Override
    public void updateStatus(IAssemblerCluster _ac) {
        if (Platform.isClient()) {
            boolean wasComplete = this.ac != null;
            this.ac = (AssemblerCluster)_ac;
            if (wasComplete != (this.ac != null)) {
                this.markForUpdate();
            }
        } else {
            this.ac = (AssemblerCluster)_ac;
        }
    }

    @Override
    public boolean isEnabled() {
        if (Platform.isClient()) {
            return this.complete;
        }
        return this.ac != null;
    }

    public IInventory getInventory() {
        if (this.ac == null) {
            return null;
        }
        if (this.ac.inv == null) {
            ArrayList<IInventory> invs = new ArrayList<IInventory>();
            try {
                for (TileRef<TileAssembler> ta : this.ac.Assemblers) {
                    invs.add(ta.getTile());
                }
            }
            catch (AppEngTileMissingException err) {
                return null;
            }
            this.ac.inv = new WrapperChainedInventory(invs);
        }
        return this.ac.inv;
    }

    public int func_70302_i_() {
        IInventory inv = this.getInventory();
        if (inv == null) {
            return 0;
        }
        return inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        IInventory inv = this.getInventory();
        if (inv == null) {
            return null;
        }
        return inv.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        IInventory inv = this.getInventory();
        if (inv == null) {
            return null;
        }
        return inv.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        IInventory inv = this.getInventory();
        if (inv == null) {
            return;
        }
        inv.func_70299_a(var1, var2);
    }

    public String func_70303_b() {
        return "ME Assembler Chamber";
    }

    public int func_70297_j_() {
        IInventory inv = this.getInventory();
        if (inv == null) {
            return 0;
        }
        return inv.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (Util.isAssemblerPattern(itemstack).booleanValue()) {
            return Util.getAssemblerPattern(itemstack).isEncoded();
        }
        return false;
    }

    @Override
    public void bulkUpdate(long inst, Player player) {
        if (this.ac != null && this.ac.inst != inst) {
            this.ac.inst = inst;
            this.sendUpdate(true, player);
        }
    }

    @Override
    public boolean requiresTickingUpdates() {
        return false;
    }

    public void sendUpdate(boolean newState, Player player) {
        if (this.ac != null) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74757_a("formed", newState);
            try {
                Packet250CustomPayload p = new PacketBulkMAC(Platform.createBulkUpdate(tc, this.ac.min, this.ac.max)).getPacket();
                if (p != null) {
                    if (player == null) {
                        AppEng.getInstance().SideProxy.sendToAllNearExcept(null, this.field_70329_l, this.field_70330_m, this.field_70327_n, 512.0, this.field_70331_k, (Packet)p);
                    } else {
                        PacketDispatcher.sendPacketToPlayer((Packet)p, (Player)player);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isSeperated() {
        return !this.isEnabled();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.isCommonUseableByPlayer(entityplayer);
    }
}

