/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.IAEItemStack;
import appeng.api.Util;
import appeng.api.events.GridStorageUpdateEvent;
import appeng.api.me.tiles.ICellContainer;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IOrientableTile;
import appeng.api.me.tiles.IPriorityTile;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngTextureRegistry;
import appeng.common.network.IAppEngNetworkTile;
import appeng.common.registries.AppEngCellRegistry;
import appeng.gui.AppEngGuiHandler;
import appeng.interfaces.IBlinky;
import appeng.interfaces.ICellFeedBack;
import appeng.interfaces.IMEInterfaceHandlerExtended;
import appeng.me.MEInventoryArray;
import appeng.me.basetiles.TileMEWInventory;
import appeng.me.tile.TileController;
import appeng.util.InventoryAdaptor;
import appeng.util.ItemList;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import buildcraft.api.inventory.ISpecialInventory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileDrive
extends TileMEWInventory
implements IOrientableTile,
IBlinky,
ISpecialInventory,
ICellFeedBack,
ICellContainer,
IPriorityTile,
IAppEngNetworkTile,
IGridMachine {
    List<IMEInventoryHandler> cachedCellArray = null;
    int priority = 1;
    byte typeSlots;
    byte countSlots;
    int driveConfig;
    public int blink = 0;
    IMEInventoryHandler[] cells = new IMEInventoryHandler[10];
    int bdelay = 0;

    @Override
    public boolean requiresTickingUpdates() {
        return true;
    }

    @Override
    public void updateTileEntity() {
        if (this.bdelay-- < 0 && this.blink > 0) {
            this.blink = 0;
            this.bdelay = 0;
        }
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return true;
    }

    @Override
    public void openGui(EntityPlayer p) {
        Platform.openGui(p, AppEngGuiHandler.GUI_DRIVE, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public TileDrive() {
        super(10);
        this.orientation = ForgeDirection.NORTH;
    }

    @Override
    public void placedBy(EntityLivingBase entityliving) {
        this.orientation = this.getOrientationFromLivingEntity(entityliving, false);
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (ForgeDirection.DOWN == side) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (ForgeDirection.UP == side) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        Icon frontPanel = AppEngTextureRegistry.Blocks.BlockDriveFace.get();
        if (AppEngConfiguration.gfxDrivesHighDef) {
            frontPanel = AppEngTextureRegistry.Blocks.BlockHDDriveFace.get();
        }
        if (this.orientation == side) {
            return frontPanel;
        }
        int xoffset = (int)(5.0f * (float)this.countSlots / 5.0f);
        int yoffset = (int)(5.0f * (float)this.typeSlots / 5.0f);
        if (xoffset > 5) {
            xoffset = 5;
        }
        if (xoffset < 0) {
            xoffset = 0;
        }
        if (yoffset > 5) {
            yoffset = 5;
        }
        if (yoffset < 0) {
            yoffset = 0;
        }
        Icon Texture = AppEngTextureRegistry.Blocks.MEDriveStatus[xoffset][yoffset].get();
        if (this.orientation.getOpposite() == side) {
            return Texture;
        }
        return AppEngTextureRegistry.Blocks.GenericSide.get();
    }

    public String func_70303_b() {
        return "ME Drive";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (AppEngConfiguration.gfxDrivesHighDef && renderer.field_78664_d == null) {
            renderer.func_78570_q(block, x, y, z);
            if (!this.func_70311_o().func_71877_c(world, x + this.orientation.offsetX, y + this.orientation.offsetY, z + this.orientation.offsetZ, this.orientation.ordinal())) {
                return true;
            }
            float offsetPerPixel = 0.0625f;
            float initialOffsetX = 1.0f * offsetPerPixel;
            float initialOffsetY = 4.0f * offsetPerPixel;
            float mulOffsetX = 7.0f * offsetPerPixel;
            float mulOffsetY = 3.0f * offsetPerPixel;
            this.hasPower = (this.driveConfig & 0x100000) > 0;
            Icon parts = AppEngTextureRegistry.Blocks.BlockHDDriveFaceParts.get();
            for (int yy = 0; yy < 5; ++yy) {
                for (int xx = 0; xx < 2; ++xx) {
                    int cellSlot = (int)Math.pow(2.0, xx + yy * 2);
                    int cellSlotB = cellSlot * 1024;
                    boolean noCell = (this.driveConfig & (cellSlotB | cellSlot)) == 0;
                    byte rotation = this.getAERotationFromDirection(this.orientation);
                    int bn = (this.blink & cellSlot) > 0 ? 9 : 15;
                    int slotColor = 3;
                    if ((this.driveConfig & (cellSlotB | cellSlot)) == (cellSlotB | cellSlot)) {
                        slotColor = 6;
                    } else if ((this.driveConfig & (cellSlotB | cellSlot)) == cellSlotB) {
                        slotColor = 9;
                    }
                    float[] p1 = new float[5];
                    float[] p2 = new float[5];
                    float[] p3 = new float[5];
                    float[] p4 = new float[5];
                    p1[0] = initialOffsetX + (float)xx * mulOffsetX;
                    p1[1] = 1.0f - initialOffsetY - (float)yy * mulOffsetY;
                    p1[2] = rotation == 2 || rotation == 1 ? 0.01f : 0.99f;
                    p1[3] = 7.0f;
                    p1[4] = (noCell ? 12.0f : (this.hasPower ? (float)slotColor : 0.0f)) + 4.0f;
                    p2[0] = p1[0] + offsetPerPixel * 7.0f;
                    p2[1] = p1[1];
                    p2[2] = p1[2];
                    p2[3] = p1[3] - 7.0f;
                    p2[4] = p1[4];
                    p3[0] = p1[0] + offsetPerPixel * 7.0f;
                    p3[1] = p1[1] + offsetPerPixel * 4.0f;
                    p3[2] = p1[2];
                    p3[3] = p1[3] - 7.0f;
                    p3[4] = p1[4] - 4.0f;
                    p4[0] = p1[0];
                    p4[1] = p1[1] + offsetPerPixel * 4.0f;
                    p4[2] = p1[2];
                    p4[3] = p1[3];
                    p4[4] = p1[4] - 3.9f;
                    Tessellator tess = Tessellator.field_78398_a;
                    tess.func_78386_a(1.0f, 1.0f, 1.0f);
                    if (rotation == 0) {
                        tess.func_78380_c(block.func_71874_e((IBlockAccess)this.field_70331_k, x, y, z + 1));
                        tess.func_78374_a((double)((float)x + p1[0]), (double)((float)y + p1[1]), (double)((float)z + p1[2]), (double)parts.func_94214_a((double)p1[3]), (double)parts.func_94207_b((double)p1[4]));
                        tess.func_78374_a((double)((float)x + p2[0]), (double)((float)y + p2[1]), (double)((float)z + p2[2]), (double)parts.func_94214_a((double)p2[3]), (double)parts.func_94207_b((double)p2[4]));
                        tess.func_78374_a((double)((float)x + p3[0]), (double)((float)y + p3[1]), (double)((float)z + p3[2]), (double)parts.func_94214_a((double)p3[3]), (double)parts.func_94207_b((double)p3[4]));
                        tess.func_78374_a((double)((float)x + p4[0]), (double)((float)y + p4[1]), (double)((float)z + p4[2]), (double)parts.func_94214_a((double)p4[3]), (double)parts.func_94207_b((double)p4[4]));
                        continue;
                    }
                    if (rotation == 1) {
                        tess.func_78380_c(block.func_71874_e((IBlockAccess)this.field_70331_k, x - 1, y, z));
                        tess.func_78374_a((double)((float)x + p1[2]), (double)((float)y + p1[1]), (double)((float)z + p1[0]), (double)parts.func_94214_a((double)p1[3]), (double)parts.func_94207_b((double)p1[4]));
                        tess.func_78374_a((double)((float)x + p2[2]), (double)((float)y + p2[1]), (double)((float)z + p2[0]), (double)parts.func_94214_a((double)p2[3]), (double)parts.func_94207_b((double)p2[4]));
                        tess.func_78374_a((double)((float)x + p3[2]), (double)((float)y + p3[1]), (double)((float)z + p3[0]), (double)parts.func_94214_a((double)p3[3]), (double)parts.func_94207_b((double)p3[4]));
                        tess.func_78374_a((double)((float)x + p4[2]), (double)((float)y + p4[1]), (double)((float)z + p4[0]), (double)parts.func_94214_a((double)p4[3]), (double)parts.func_94207_b((double)p4[4]));
                        continue;
                    }
                    if (rotation == 3) {
                        tess.func_78380_c(block.func_71874_e((IBlockAccess)this.field_70331_k, x + 1, y, z));
                        tess.func_78374_a((double)((float)x + p1[2]), (double)((float)y + p1[1]), (double)((float)z + 1.0f - p1[0]), (double)parts.func_94214_a((double)p1[3]), (double)parts.func_94207_b((double)p1[4]));
                        tess.func_78374_a((double)((float)x + p2[2]), (double)((float)y + p2[1]), (double)((float)z + 1.0f - p2[0]), (double)parts.func_94214_a((double)p2[3]), (double)parts.func_94207_b((double)p2[4]));
                        tess.func_78374_a((double)((float)x + p3[2]), (double)((float)y + p3[1]), (double)((float)z + 1.0f - p3[0]), (double)parts.func_94214_a((double)p3[3]), (double)parts.func_94207_b((double)p3[4]));
                        tess.func_78374_a((double)((float)x + p4[2]), (double)((float)y + p4[1]), (double)((float)z + 1.0f - p4[0]), (double)parts.func_94214_a((double)p4[3]), (double)parts.func_94207_b((double)p4[4]));
                        continue;
                    }
                    tess.func_78380_c(block.func_71874_e((IBlockAccess)this.field_70331_k, x, y, z - 1));
                    tess.func_78374_a((double)((float)x + 1.0f - p1[0]), (double)((float)y + p1[1]), (double)((float)z + p1[2]), (double)parts.func_94214_a((double)p1[3]), (double)parts.func_94207_b((double)p1[4]));
                    tess.func_78374_a((double)((float)x + 1.0f - p2[0]), (double)((float)y + p2[1]), (double)((float)z + p2[2]), (double)parts.func_94214_a((double)p2[3]), (double)parts.func_94207_b((double)p2[4]));
                    tess.func_78374_a((double)((float)x + 1.0f - p3[0]), (double)((float)y + p3[1]), (double)((float)z + p3[2]), (double)parts.func_94214_a((double)p3[3]), (double)parts.func_94207_b((double)p3[4]));
                    tess.func_78374_a((double)((float)x + 1.0f - p4[0]), (double)((float)y + p4[1]), (double)((float)z + p4[2]), (double)parts.func_94214_a((double)p4[3]), (double)parts.func_94207_b((double)p4[4]));
                }
            }
        } else {
            renderer.func_78570_q(block, x, y, z);
        }
        return true;
    }

    @Override
    public boolean isBlinking() {
        return this.blink != 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBlinks(RenderBlocks rb) {
        int x = this.field_70329_l;
        int y = this.field_70330_m;
        int z = this.field_70327_n;
        float offsetPerPixel = 0.0625f;
        float initialOffsetX = 1.0f * offsetPerPixel;
        float initialOffsetY = 4.0f * offsetPerPixel;
        float mulOffsetX = 7.0f * offsetPerPixel;
        float mulOffsetY = 3.0f * offsetPerPixel;
        this.hasPower = (this.driveConfig & 0x100000) > 0;
        Icon parts = AppEngTextureRegistry.Blocks.BlockHDDriveFaceParts.get();
        for (int yy = 0; yy < 5; ++yy) {
            for (int xx = 0; xx < 2; ++xx) {
                int cellSlot = (int)Math.pow(2.0, xx + yy * 2);
                int cellSlotB = cellSlot * 1024;
                boolean noCell = (this.driveConfig & (cellSlotB | cellSlot)) == 0;
                byte rotation = this.getAERotationFromDirection(this.orientation);
                int bn = (this.blink & cellSlot) > 0 ? 9 : 15;
                int slotColor = 3;
                if ((this.driveConfig & (cellSlotB | cellSlot)) == (cellSlotB | cellSlot)) {
                    slotColor = 6;
                } else if ((this.driveConfig & (cellSlotB | cellSlot)) == cellSlotB) {
                    slotColor = 9;
                }
                float[] p1 = new float[5];
                float[] p2 = new float[5];
                float[] p3 = new float[5];
                float[] p4 = new float[5];
                p1[0] = initialOffsetX + (float)xx * mulOffsetX;
                p1[1] = 1.0f - initialOffsetY - (float)yy * mulOffsetY;
                p1[2] = rotation == 2 || rotation == 1 ? 0.01f : 0.99f;
                p1[3] = 7.0f;
                p1[4] = (noCell ? 12.0f : (this.hasPower ? (float)slotColor : 0.0f)) + 4.0f;
                p2[0] = p1[0] + offsetPerPixel * 7.0f;
                p2[1] = p1[1];
                p2[2] = p1[2];
                p2[3] = p1[3] - 7.0f;
                p2[4] = p1[4];
                p3[0] = p1[0] + offsetPerPixel * 7.0f;
                p3[1] = p1[1] + offsetPerPixel * 4.0f;
                p3[2] = p1[2];
                p3[3] = p1[3] - 7.0f;
                p3[4] = p1[4] - 4.0f;
                p4[0] = p1[0];
                p4[1] = p1[1] + offsetPerPixel * 4.0f;
                p4[2] = p1[2];
                p4[3] = p1[3];
                p4[4] = p1[4] - 4.0f;
                Tessellator tess = Tessellator.field_78398_a;
                tess.func_78386_a(1.0f, 1.0f, 1.0f);
                if (rotation == 0) {
                    if (noCell || !this.hasPower) continue;
                    tess.func_78380_c(bn << 20 | bn << 4);
                    p1[2] = (double)p1[2] > 0.5 ? 0.998f : 0.002f;
                    p2[2] = (double)p2[2] > 0.5 ? 0.998f : 0.002f;
                    p3[2] = (double)p3[2] > 0.5 ? 0.998f : 0.002f;
                    p4[2] = (double)p4[2] > 0.5 ? 0.998f : 0.002f;
                    tess.func_78374_a((double)((float)x + p1[0]), (double)((float)y + p1[1]), (double)((float)z + p1[2]), (double)parts.func_94214_a((double)p1[3] + 7.0), (double)parts.func_94207_b((double)p1[4]));
                    tess.func_78374_a((double)((float)x + p2[0]), (double)((float)y + p2[1]), (double)((float)z + p2[2]), (double)parts.func_94214_a((double)p2[3] + 7.0), (double)parts.func_94207_b((double)p2[4]));
                    tess.func_78374_a((double)((float)x + p3[0]), (double)((float)y + p3[1]), (double)((float)z + p3[2]), (double)parts.func_94214_a((double)p3[3] + 7.0), (double)parts.func_94207_b((double)p3[4]));
                    tess.func_78374_a((double)((float)x + p4[0]), (double)((float)y + p4[1]), (double)((float)z + p4[2]), (double)parts.func_94214_a((double)p4[3] + 7.0), (double)parts.func_94207_b((double)p4[4]));
                    continue;
                }
                if (rotation == 1) {
                    if (noCell || !this.hasPower) continue;
                    tess.func_78380_c(bn << 20 | bn << 4);
                    p1[2] = (double)p1[2] > 0.5 ? 0.998f : 0.002f;
                    p2[2] = (double)p2[2] > 0.5 ? 0.998f : 0.002f;
                    p3[2] = (double)p3[2] > 0.5 ? 0.998f : 0.002f;
                    p4[2] = (double)p4[2] > 0.5 ? 0.998f : 0.002f;
                    tess.func_78374_a((double)((float)x + p1[2]), (double)((float)y + p1[1]), (double)((float)z + p1[0]), (double)parts.func_94214_a((double)p1[3] + 7.0), (double)parts.func_94207_b((double)p1[4]));
                    tess.func_78374_a((double)((float)x + p2[2]), (double)((float)y + p2[1]), (double)((float)z + p2[0]), (double)parts.func_94214_a((double)p2[3] + 7.0), (double)parts.func_94207_b((double)p2[4]));
                    tess.func_78374_a((double)((float)x + p3[2]), (double)((float)y + p3[1]), (double)((float)z + p3[0]), (double)parts.func_94214_a((double)p3[3] + 7.0), (double)parts.func_94207_b((double)p3[4]));
                    tess.func_78374_a((double)((float)x + p4[2]), (double)((float)y + p4[1]), (double)((float)z + p4[0]), (double)parts.func_94214_a((double)p4[3] + 7.0), (double)parts.func_94207_b((double)p4[4]));
                    continue;
                }
                if (rotation == 3) {
                    if (noCell || !this.hasPower) continue;
                    tess.func_78380_c(bn << 20 | bn << 4);
                    p1[2] = (double)p1[2] > 0.5 ? 0.998f : 0.002f;
                    p2[2] = (double)p2[2] > 0.5 ? 0.998f : 0.002f;
                    p3[2] = (double)p3[2] > 0.5 ? 0.998f : 0.002f;
                    p4[2] = (double)p4[2] > 0.5 ? 0.998f : 0.002f;
                    tess.func_78374_a((double)((float)x + p1[2]), (double)((float)y + p1[1]), (double)((float)z + 1.0f - p1[0]), (double)parts.func_94214_a((double)p1[3] + 7.0), (double)parts.func_94207_b((double)p1[4]));
                    tess.func_78374_a((double)((float)x + p2[2]), (double)((float)y + p2[1]), (double)((float)z + 1.0f - p2[0]), (double)parts.func_94214_a((double)p2[3] + 7.0), (double)parts.func_94207_b((double)p2[4]));
                    tess.func_78374_a((double)((float)x + p3[2]), (double)((float)y + p3[1]), (double)((float)z + 1.0f - p3[0]), (double)parts.func_94214_a((double)p3[3] + 7.0), (double)parts.func_94207_b((double)p3[4]));
                    tess.func_78374_a((double)((float)x + p4[2]), (double)((float)y + p4[1]), (double)((float)z + 1.0f - p4[0]), (double)parts.func_94214_a((double)p4[3] + 7.0), (double)parts.func_94207_b((double)p4[4]));
                    continue;
                }
                if (noCell || !this.hasPower) continue;
                tess.func_78380_c(bn << 20 | bn << 4);
                p1[2] = (double)p1[2] > 0.5 ? 0.998f : 0.002f;
                p2[2] = (double)p2[2] > 0.5 ? 0.998f : 0.002f;
                p3[2] = (double)p3[2] > 0.5 ? 0.998f : 0.002f;
                p4[2] = (double)p4[2] > 0.5 ? 0.998f : 0.002f;
                tess.func_78374_a((double)((float)x + 1.0f - p1[0]), (double)((float)y + p1[1]), (double)((float)z + p1[2]), (double)parts.func_94214_a((double)p1[3] + 7.0), (double)parts.func_94207_b((double)p1[4]));
                tess.func_78374_a((double)((float)x + 1.0f - p2[0]), (double)((float)y + p2[1]), (double)((float)z + p2[2]), (double)parts.func_94214_a((double)p2[3] + 7.0), (double)parts.func_94207_b((double)p2[4]));
                tess.func_78374_a((double)((float)x + 1.0f - p3[0]), (double)((float)y + p3[1]), (double)((float)z + p3[2]), (double)parts.func_94214_a((double)p3[3] + 7.0), (double)parts.func_94207_b((double)p3[4]));
                tess.func_78374_a((double)((float)x + 1.0f - p4[0]), (double)((float)y + p4[1]), (double)((float)z + p4[2]), (double)parts.func_94214_a((double)p4[3] + 7.0), (double)parts.func_94207_b((double)p4[4]));
            }
        }
    }

    @Override
    public List<IMEInventoryHandler> getCellArray() {
        if (this.cachedCellArray != null) {
            return this.cachedCellArray;
        }
        ArrayList<IMEInventoryHandler> invs = new ArrayList<IMEInventoryHandler>();
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            ItemStack s = this.func_70301_a(x);
            this.cells[x] = null;
            if (s == null || !AppEngCellRegistry.isCell(s)) continue;
            IMEInventoryHandler inv = AppEngCellRegistry.getCellHandler(s);
            if (inv instanceof IMEInterfaceHandlerExtended) {
                ((IMEInterfaceHandlerExtended)inv).setCellIndex((int)Math.pow(2.0, x));
            }
            inv.setUpdateTarget(this);
            this.cells[x] = inv;
            invs.add(inv);
        }
        this.cachedCellArray = invs;
        return this.cachedCellArray;
    }

    public void applyCellChanges(ItemList Il, boolean subtract) {
        TileController tc;
        if (this.cachedCellArray == null && subtract) {
            return;
        }
        List<IMEInventoryHandler> cellArray = this.getCellArray();
        if (cellArray != null) {
            for (IMEInventoryHandler ih : cellArray) {
                ih.getAvailableItems(Il);
            }
            if (subtract) {
                for (IAEItemStack is : Il) {
                    is.setStackSize(-is.getStackSize());
                }
            }
        }
        if (!subtract && this.getGrid() != null && (tc = (TileController)this.getGrid().getController()) != null) {
            for (IAEItemStack is : Il) {
                if (is.getStackSize() < 0L) {
                    is.setStackSize(-is.getStackSize());
                    tc.notifyExtractItems(is);
                    continue;
                }
                if (is.getStackSize() <= 0L) continue;
                tc.notifyAddItems(is);
            }
        }
    }

    @Override
    public ItemStack func_70298_a(int var1, int var2) {
        ItemList Il = new ItemList();
        this.applyCellChanges(Il, true);
        this.resetCache();
        this.triggerPowerUpdate();
        ItemStack is = super.func_70298_a(var1, var2);
        this.applyCellChanges(Il, false);
        return is;
    }

    @Override
    public void func_70299_a(int var1, ItemStack var2) {
        if (Platform.isServer()) {
            ItemList Il = new ItemList();
            this.applyCellChanges(Il, true);
            this.resetCache();
            this.triggerPowerUpdate();
            super.func_70299_a(var1, var2);
            this.applyCellChanges(Il, false);
        } else {
            super.func_70299_a(var1, var2);
        }
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        byte ts = this.typeSlots;
        byte cs = this.countSlots;
        int bl = this.blink;
        ForgeDirection ori = this.orientation;
        int dc = this.driveConfig;
        this.priority = stream.readInt();
        short rotation = stream.readShort();
        this.typeSlots = stream.readByte();
        this.countSlots = stream.readByte();
        this.blink ^= rotation >> 3;
        this.orientation = this.getDirectionFromAERotation((byte)(rotation & 7));
        this.driveConfig = stream.readInt();
        this.setInventorySize(10);
        this.bdelay = 4;
        if (!AppEngConfiguration.gfxDrivesHighDef) {
            dc = this.driveConfig;
        }
        return ts != this.typeSlots || cs != this.countSlots || ori != this.orientation || dc != this.driveConfig;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        this.typeSlots = 0;
        this.countSlots = 0;
        IMEInventoryHandler ca = MEInventoryArray.getMEInventoryArray(this.getCellArray());
        if (ca != null) {
            float tPer = (float)ca.storedItemTypes() / (float)ca.getTotalItemTypes();
            float cPer = (float)ca.usedBytes() / (float)ca.totalBytes();
            this.typeSlots = (byte)(tPer * 5.0f);
            this.countSlots = (byte)(cPer * 5.0f);
        } else {
            this.typeSlots = 0;
            this.countSlots = 0;
        }
        data.writeInt(this.priority);
        data.writeShort(this.getAERotationFromDirection(this.orientation) | this.blink << 3);
        this.blink = 0;
        data.writeByte(this.typeSlots);
        data.writeByte(this.countSlots);
        this.driveConfig = 0;
        this.driveConfig |= this.getCellVarForSlot(0, 1, 1024);
        this.driveConfig |= this.getCellVarForSlot(1, 2, 2048);
        this.driveConfig |= this.getCellVarForSlot(2, 4, 4096);
        this.driveConfig |= this.getCellVarForSlot(3, 8, 8192);
        this.driveConfig |= this.getCellVarForSlot(4, 16, 16384);
        this.driveConfig |= this.getCellVarForSlot(5, 32, 32768);
        this.driveConfig |= this.getCellVarForSlot(6, 64, 65536);
        this.driveConfig |= this.getCellVarForSlot(7, 128, 131072);
        this.driveConfig |= this.getCellVarForSlot(8, 256, 262144);
        this.driveConfig |= this.getCellVarForSlot(9, 512, 524288);
        this.driveConfig |= this.hasPower ? 0x100000 : 0;
        data.writeInt(this.driveConfig);
    }

    public int getCellVarForSlot(int slot, int A, int B) {
        IMEInventoryHandler h;
        if (slot < 10 && (h = this.cells[slot]) != null) {
            return !h.isPreformatted() && h.canHoldNewItem() ? A | B : (h.remainingItemCount() > 0L ? B : A);
        }
        return 0;
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("priority", this.priority);
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.priority = par1nbtTagCompound.func_74762_e("priority");
    }

    void resetCache() {
        if (this.getGrid() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
        this.cachedCellArray = null;
        if (this.getGrid() != null) {
            this.getGrid().resetWaitingQueue();
        }
        this.markForUpdate();
    }

    @Override
    public void actionHandler(EntityPlayerMP pmp, int action, DataInputStream stream) {
        try {
            if (action == 1) {
                this.setPriority(stream.readInt());
                this.markForUpdate();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public float getPowerDrainPerTick() {
        return 2.0f + this.getStoragePowerUsage(this.getCellArray());
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int p) {
        this.priority = p;
        if (this.getGrid() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
    }

    @Override
    public void updateCellIndex(int idx) {
        if ((this.blink & idx) != idx) {
            this.blink |= idx;
            this.markForUpdate();
        }
    }

    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (Util.isCell(stack).booleanValue()) {
            AdaptorIInventory ia = new AdaptorIInventory(this);
            ItemStack used = null;
            int originalStackSize = stack.field_77994_a;
            used = doAdd ? ((InventoryAdaptor)ia).addItems(stack) : ((InventoryAdaptor)ia).simulateAdd(stack);
            if (used == null) {
                return originalStackSize;
            }
            return originalStackSize - used.field_77994_a;
        }
        return 0;
    }

    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack[] output = new ItemStack[1];
        AdaptorIInventory ia = new AdaptorIInventory(this);
        output[0] = doRemove ? ((InventoryAdaptor)ia).removeItems(maxItemCount, null, null) : ((InventoryAdaptor)ia).simulateRemove(maxItemCount, null, null);
        if (output[0] == null) {
            return new ItemStack[0];
        }
        return output;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return Util.isCell(itemstack);
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return 0;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
    }

    @Override
    public void setSpin(int spin) {
    }
}

