/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.IOrientableTile;
import appeng.api.me.util.IGridInterface;
import appeng.common.AppEng;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngTile;
import appeng.common.network.IAppEngNetworkTile;
import appeng.interfaces.ISolidSides;
import appeng.me.basetiles.TileCableBase;
import appeng.me.cache.P2PCache;
import appeng.render.AppEngBlockRenderer;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class TileP2PTunnel
extends TileCableBase
implements ISolidSides,
IOrientableTile,
IAppEngNetworkTile,
IDirectionalMETile,
IGridMachine,
IColoredMETile {
    static HashMap<ItemStack, Class<? extends TileP2PTunnel>> Tunnels = new HashMap();
    public ForgeDirection orientation = ForgeDirection.UP;
    public int color = -1;
    public long freq;
    public boolean output;

    public static void addType(ItemStack is, Class<? extends TileP2PTunnel> c) {
        if (is != null) {
            Tunnels.put(is, c);
        }
    }

    @Override
    public boolean isSideSolid(ForgeDirection f) {
        return f.equals((Object)this.orientation);
    }

    public boolean attune(ItemStack eq) {
        if (FluidContainerRegistry.isContainer((ItemStack)eq)) {
            eq = new ItemStack(Item.field_77788_aw);
        }
        for (ItemStack is : Tunnels.keySet()) {
            if (!Platform.isSameItemType(is, eq)) continue;
            if (Platform.isServer()) {
                this.replaceTile(Tunnels.get(is).getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isBlockNormalCube() {
        return false;
    }

    TileP2PTunnel replaceTile(String type) {
        TileP2PTunnel inst = this;
        if (type.equals(this.getTunnelType())) {
            return inst;
        }
        try {
            Class<?> c = Class.forName(type);
            if (TileP2PTunnel.class.isAssignableFrom(c)) {
                inst = (TileP2PTunnel)c.newInstance();
                inst.color = this.color;
                inst.orientation = this.orientation;
                inst.freq = this.freq;
                inst.output = this.output;
                inst.field_70331_k = this.field_70331_k;
                inst.field_70329_l = this.field_70329_l;
                inst.field_70330_m = this.field_70330_m;
                inst.field_70327_n = this.field_70327_n;
                inst.connectionMask = this.connectionMask;
                inst.connections = this.connections;
                inst.coveredMask = this.coveredMask;
                inst.hasPower = this.hasPower;
                NBTTagCompound t = new NBTTagCompound();
                this.getFacadeProxy().writeToNBT(t);
                inst.getFacadeProxy().readFromNBT(t);
                IGridInterface gi = this.getGrid();
                this.field_70331_k.func_72837_a(this.field_70329_l, this.field_70330_m, this.field_70327_n, (TileEntity)inst);
                this.notifyNeightbors();
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l + d.offsetX, this.field_70330_m + d.offsetY, this.field_70327_n + d.offsetZ);
                    if (!(te instanceof IGridTileEntity)) continue;
                    AppEng.getInstance().GridManager.forceNetworkReclculation(te);
                }
                inst.markForUpdate();
                MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent(inst, this.field_70331_k, inst.getLocation()));
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return inst;
    }

    void recalculateTunnels() {
        IGridInterface gi = this.getGrid();
        if (gi != null) {
            ((P2PCache)gi.getCacheByID(P2PCache.index)).reset(gi);
        }
    }

    @Override
    public void init() {
        super.init();
        this.recalculateTunnels();
    }

    protected TileP2PTunnel getInput() {
        if (!this.isMachineActive()) {
            return null;
        }
        IGridInterface gi = this.getGrid();
        if (!this.output || gi == null) {
            return null;
        }
        return ((P2PCache)gi.getCacheByID(P2PCache.index)).getInput(this.freq);
    }

    protected Collection<TileP2PTunnel> getOutputs() {
        IGridInterface gi = this.getGrid();
        if (this.output || gi == null) {
            return new ArrayList<TileP2PTunnel>();
        }
        if (!this.isMachineActive()) {
            return new ArrayList<TileP2PTunnel>();
        }
        return ((P2PCache)gi.getCacheByID(P2PCache.index)).getOutputs(this.freq);
    }

    protected void putInput(Object o) {
    }

    public void onChange() {
    }

    protected void sendToOutput(Object o) {
        if (!this.output && this.isMachineActive()) {
            for (TileP2PTunnel t : this.getOutputs()) {
                if (!this.getClass().isInstance(t)) continue;
                t.putInput(o);
            }
        }
    }

    @Override
    public void setOrientationBySide(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        super.setOrientationBySide(player, side, hitX, hitY, hitZ);
        this.orientation = ForgeDirection.getOrientation((int)side);
        if (player.func_70093_af()) {
            this.orientation = this.orientation.getOpposite();
        }
        WorldCoord pos = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        pos.add(this.orientation, -1);
        TileEntity te = this.field_70331_k.func_72796_p(pos.x, pos.y, pos.z);
        if (te instanceof IColoredMETile && ((IColoredMETile)te).isColored(ForgeDirection.UNKNOWN)) {
            this.color = ((IColoredMETile)te).getColor();
        }
    }

    @Override
    public boolean requiresRedstoneUpdates() {
        return false;
    }

    @Override
    public boolean requiresTickingUpdates() {
        return false;
    }

    public String getTunnelType() {
        return this.getClass().getName();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getTypeTexture() {
        return AppEngTextureRegistry.Blocks.BlockQuartz.get();
    }

    public boolean[] BackSide() {
        byte rotation = this.getAERotationFromDirection(this.orientation.getOpposite());
        return new boolean[]{rotation != 5, rotation != 4, rotation != 2, rotation != 0, rotation != 1, rotation != 3};
    }

    public boolean[] FrontSide() {
        byte rotation = this.getAERotationFromDirection(this.orientation);
        return new boolean[]{rotation != 5, rotation != 4, rotation != 2, rotation != 0, rotation != 1, rotation != 3};
    }

    public boolean[] NotFrontSide() {
        byte rotation = this.getAERotationFromDirection(this.orientation);
        return new boolean[]{rotation == 5, rotation == 4, rotation == 2, rotation == 0, rotation == 1, rotation == 3};
    }

    @Override
    public AxisAlignedBB extendBusCollision(AxisAlignedBB b) {
        return this.IOBusCollision(0.128f, this.orientation, b);
    }

    public boolean[] SidesOnly() {
        byte rotation = this.getAERotationFromDirection(this.orientation);
        byte orotation = this.getAERotationFromDirection(this.orientation.getOpposite());
        return new boolean[]{rotation == 5 || orotation == 5, rotation == 4 || orotation == 4, rotation == 2 || orotation == 2, rotation == 0 || orotation == 0, rotation == 1 || orotation == 1, rotation == 3 || orotation == 3};
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTipPart(Block block, RenderBlocks renderer, float offset, float Thickness, int x, int y, int z) {
        float offX = (float)this.orientation.offsetX / 2.0f;
        float offY = (float)this.orientation.offsetY / 2.0f;
        float offZ = (float)this.orientation.offsetZ / 2.0f;
        float centerX = 0.5f;
        float centerY = 0.5f;
        float centerZ = 0.5f;
        float thickX = (double)Math.abs(this.orientation.offsetX) > 0.1 ? 0.076f : Thickness;
        float thickY = (double)Math.abs(this.orientation.offsetY) > 0.1 ? 0.076f : Thickness;
        float thickZ = (double)Math.abs(this.orientation.offsetZ) > 0.1 ? 0.076f : Thickness;
        this.setTipRenderBounds(renderer, this.orientation, centerX + offX - thickX, (centerY += (float)this.orientation.offsetY * -offset) + offY - thickY, (centerZ += (float)this.orientation.offsetZ * -offset) + offZ - thickZ, (centerX += (float)this.orientation.offsetX * -offset) + offX + thickX, centerY + offY + thickY, centerZ + offZ + thickZ);
        renderer.func_78570_q(block, x, y, z);
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.field_78661_f = true;
        Icon cableColor = this.color == -1 ? AppEngTextureRegistry.Blocks.MECableClear.get() : AppEngTextureRegistry.Blocks.MECableColors[this.color].get();
        this.renderCableAt(0.11, world, x, y, z, block, modelId, renderer, cableColor, true, 0.0);
        this.renderCableAt(0.18, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.MECable.get(), false, 0.1875);
        AppEngMultiBlock b = (AppEngMultiBlock)block;
        renderer.field_78661_f = false;
        b.nonOpaqueMode = true;
        b.dontrender = this.FrontSide();
        AppEngBlockRenderer.instance.setOverrideBlockTexture(block, this.getTypeTexture());
        this.renderTipPart(block, renderer, 0.071f, 0.251f, x, y, z);
        AppEngBlockRenderer.overrideTexture = AppEngTextureRegistry.Blocks.BlockP2PTunnel1.get();
        this.renderTipPart(block, renderer, 0.071f, 0.375f, x, y, z);
        AppEngBlockRenderer.overrideTexture = AppEngTextureRegistry.Blocks.BlockP2PTunnel2.get();
        b.dontrender = this.SidesOnly();
        this.renderTipPart(block, renderer, 0.031f, 0.375f, x, y, z);
        b.dontrender = this.BackSide();
        this.renderTipPart(block, renderer, 0.031f, 0.375f, x, y, z);
        b.dontrender = this.NotFrontSide();
        this.renderTipPart(block, renderer, 0.142f, 0.3125f, x, y, z);
        AppEngBlockRenderer.overrideTexture = AppEngTextureRegistry.Blocks.MECableCorner.get();
        this.renderTipPart(block, renderer, 0.304f, 0.15625f, x, y, z);
        b.nonOpaqueMode = false;
        AppEngBlockRenderer.overrideTexture = null;
        b.dontrender = null;
        super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        return true;
    }

    @Override
    public NBTTagCompound getSettings(AppEngTile.ConfigMode mode) {
        if (Platform.isClient()) {
            return null;
        }
        if (this.output || this.freq == 0L) {
            this.output = false;
            this.freq = System.currentTimeMillis();
        }
        NBTTagCompound c = new NBTTagCompound();
        c.func_74772_a("freq", this.freq);
        c.func_74778_a("type", this.getTunnelType());
        if (this.getTunnelTip() != null) {
            c.func_74778_a("tooltip", this.getTunnelTip());
        }
        if (mode == AppEngTile.ConfigMode.Wrench) {
            c.func_74757_a("output", this.output);
        }
        return c;
    }

    public String getTunnelTip() {
        return null;
    }

    @Override
    public void restoreSettings(NBTTagCompound tag, AppEngTile.ConfigMode mode) {
        if (Platform.isClient()) {
            return;
        }
        this.output = true;
        TileP2PTunnel newTunnel = this.replaceTile(tag.func_74779_i("type"));
        newTunnel.freq = tag.func_74763_f("freq");
        if (mode == AppEngTile.ConfigMode.Wrench) {
            newTunnel.output = tag.func_74767_n("output");
        }
        this.recalculateTunnels();
    }

    @Override
    public float getHoleThickness(ForgeDirection direction) {
        return 0.125f;
    }

    @Override
    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        for (ItemStack is : this.getFacadeProxy().getDrops(this)) {
            drops.add(is);
        }
        return true;
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74768_a("color", this.color);
        tag.func_74772_a("freq", this.freq);
        tag.func_74757_a("output", this.output);
        tag.func_74768_a("orientation", this.orientation.ordinal());
        tag.func_74778_a("type", this.getTunnelType());
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.color = tag.func_74762_e("color");
        this.freq = tag.func_74763_f("freq");
        this.output = tag.func_74767_n("output");
        this.orientation = ForgeDirection.getOrientation((int)tag.func_74762_e("orientation"));
    }

    @Override
    public boolean isColored(ForgeDirection d) {
        return this.color >= 0;
    }

    @Override
    public void setColor(int offset) {
        this.color = offset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public float getPowerDrainPerTick() {
        return 1.0f;
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection dir) {
        return null;
    }

    @Override
    public void cycleOrientation() {
        this.orientation = Platform.cycleOrientations(this.orientation, false);
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
        this.updatePowerConnectivity();
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        String Newtype;
        boolean b = super.handleTilePacket(stream);
        ForgeDirection oldDir = this.orientation;
        this.orientation = ForgeDirection.getOrientation((int)stream.readByte());
        String Oldtype = this.getTunnelType();
        if (!Oldtype.equals(Newtype = stream.readUTF())) {
            this.replaceTile(Newtype);
        }
        return b || this.orientation != oldDir;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        super.configureTilePacket(data);
        data.writeByte(this.orientation.ordinal());
        data.writeUTF(this.getTunnelType());
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return !dir.equals((Object)this.orientation);
    }

    protected void usePower(float x) {
        IGridInterface gi = this.getGrid();
        if (gi != null) {
            gi.useMEEnergy(x, "P2P Tunnel");
        }
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return 0;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
    }

    @Override
    public void setSpin(int spin) {
    }
}

