/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.util;

import java.text.DecimalFormat;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import tonius.simplyjetpacks.config.MainConfig;

public final class StringUtils {
    private static DecimalFormat formatter = new DecimalFormat("###,###");
    public static final String BLACK = "\u00a70";
    public static final String BLUE = "\u00a71";
    public static final String GREEN = "\u00a72";
    public static final String TEAL = "\u00a73";
    public static final String RED = "\u00a74";
    public static final String PURPLE = "\u00a75";
    public static final String ORANGE = "\u00a76";
    public static final String LIGHT_GRAY = "\u00a77";
    public static final String GRAY = "\u00a78";
    public static final String LIGHT_BLUE = "\u00a79";
    public static final String BRIGHT_GREEN = "\u00a7a";
    public static final String BRIGHT_BLUE = "\u00a7b";
    public static final String LIGHT_RED = "\u00a7c";
    public static final String PINK = "\u00a7d";
    public static final String YELLOW = "\u00a7e";
    public static final String WHITE = "\u00a7f";
    public static final String OBFUSCATED = "\u00a7k";
    public static final String BOLD = "\u00a7l";
    public static final String STRIKETHROUGH = "\u00a7m";
    public static final String UNDERLINE = "\u00a7n";
    public static final String ITALIC = "\u00a7o";
    public static final String END = "\u00a7r";

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static boolean isControlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static String getScaledNumber(int number) {
        return StringUtils.getScaledNumber(number, 2);
    }

    public static String getScaledNumber(int number, int minDigits) {
        String numString = "";
        int numMod = 10 * minDigits;
        numString = number > 100000 * numMod ? numString + number / 1000000 + "M" : (number > 100 * numMod ? numString + number / 1000 + "k" : numString + number);
        return numString;
    }

    public static String getFormattedNumber(int number) {
        return formatter.format(number);
    }

    public static String getChargeText(boolean infinite, int charge, int total) {
        if (infinite) {
            return ORANGE + StringUtils.translate("tooltip.charge") + ": " + LIGHT_GRAY + StringUtils.translate("tooltip.charge.infinite");
        }
        return ORANGE + StringUtils.translate("tooltip.charge") + ": " + LIGHT_GRAY + StringUtils.getFormattedNumber(charge) + " / " + StringUtils.getFormattedNumber(total) + " RF";
    }

    public static String getStateText(boolean state) {
        String onOrOff = state ? BRIGHT_GREEN + StringUtils.translate("tooltip.state.on") : LIGHT_RED + StringUtils.translate("tooltip.state.off");
        return ORANGE + StringUtils.translate("tooltip.state") + ": " + onOrOff;
    }

    public static String getHoverModeText(boolean state) {
        String enabledOrDisabled = state ? BRIGHT_GREEN + StringUtils.translate("tooltip.jetpack.hoverMode.enabled") : LIGHT_RED + StringUtils.translate("tooltip.jetpack.hoverMode.disabled");
        return ORANGE + StringUtils.translate("tooltip.jetpack.hoverMode") + ": " + enabledOrDisabled;
    }

    public static String getEnergyUsageText(int usage) {
        return ORANGE + StringUtils.translate("tooltip.energyUsage") + ": " + LIGHT_GRAY + usage + " RF/t";
    }

    public static String getArmorText(boolean isArmored) {
        if (isArmored) {
            return "\u00a7b\u00a7o" + StringUtils.translate("tooltip.jetpack.armor.off");
        }
        return "\u00a7b\u00a7o" + StringUtils.translate("tooltip.jetpack.armor.on");
    }

    public static String getRequiredArmorText(int tier) {
        return "\u00a7b\u00a7o" + StringUtils.translate("tooltip.jetpack.armor.requires") + ": " + YELLOW + ITALIC + StringUtils.translate("item.simplyjetpacks.components_" + (tier + 4) + ".name", false);
    }

    public static String getHUDEnergyText(int percent, int energy) {
        if (MainConfig.showExactEnergyInHUD) {
            return StringUtils.translate("gui.hud.jetpack.energy") + ": " + StringUtils.getColoredPercent(percent) + "% (" + StringUtils.getFormattedNumber(energy) + " RF)";
        }
        return StringUtils.translate("gui.hud.jetpack.energy") + ": " + StringUtils.getColoredPercent(percent) + "%";
    }

    public static String getColoredPercent(int percent) {
        if (percent > 70) {
            return BRIGHT_GREEN + percent;
        }
        if (percent > 40 && percent <= 70) {
            return YELLOW + percent;
        }
        if (percent > 10 && percent <= 40) {
            return ORANGE + percent;
        }
        return LIGHT_RED + percent;
    }

    public static String getHUDEnergyLowText() {
        return LIGHT_RED + StringUtils.translate("gui.hud.jetpack.warning.low");
    }

    public static String getHUDEnergyEmptyText() {
        return RED + StringUtils.translate("gui.hud.jetpack.warning.empty");
    }

    public static String getShiftText() {
        return LIGHT_GRAY + StringUtils.translate("tooltip.holdShift1") + " " + YELLOW + ITALIC + StringUtils.translate("tooltip.holdShift2") + " " + END + LIGHT_GRAY + StringUtils.translate("tooltip.holdShift3");
    }

    public static boolean canShowDetails() {
        return MainConfig.holdShiftForDetails ? StringUtils.isShiftKeyDown() : true;
    }

    public static String translate(String unlocalized) {
        return StringUtils.translate(unlocalized, true);
    }

    public static String translate(String unlocalized, boolean prefix) {
        if (prefix) {
            return StatCollector.func_74838_a((String)("simplyjetpacks." + unlocalized));
        }
        return StatCollector.func_74838_a((String)unlocalized);
    }
}

