/*
 * Decompiled with CFR 0.152.
 */
package openmods;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import openmods.LibConfig;
import openmods.config.CommandConfig;
import openmods.config.ConfigProcessing;
import openmods.entity.DelayedEntityLoadManager;
import openmods.fakeplayer.FakePlayerPool;
import openmods.integration.Integration;
import openmods.integration.modules.BuildCraftPipes;
import openmods.network.EventPacket;
import openmods.network.PacketHandler;
import openmods.network.events.TileEntityEventHandler;
import openmods.proxy.IOpenModsProxy;
import openmods.sync.SyncableManager;

@Mod(modid="OpenMods", name="OpenMods", version="0.5", dependencies="required-after:OpenModsCore")
@NetworkMod(serverSideRequired=true, clientSideRequired=false, channels={"OpenMods|S", "OpenMods|E"}, packetHandler=PacketHandler.class)
public class OpenMods {
    @Mod.Instance(value="OpenMods")
    public static OpenMods instance;
    @SidedProxy(clientSide="openmods.proxy.OpenClientProxy", serverSide="openmods.proxy.OpenServerProxy")
    public static IOpenModsProxy proxy;
    public static SyncableManager syncableManager;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        EventPacket.registerCorePackets();
        File configFile = evt.getSuggestedConfigurationFile();
        Configuration config = new Configuration(configFile);
        ConfigProcessing.processAnnotations(configFile, "OpenMods", config, LibConfig.class);
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)new TileEntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)DelayedEntityLoadManager.instance);
        MinecraftForge.EVENT_BUS.register((Object)FakePlayerPool.instance);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        syncableManager = new SyncableManager();
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        Integration.addModule(new BuildCraftPipes());
        Integration.loadModules();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void severStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandConfig("om_config_s", true));
    }
}

