/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class GenericFluidHandler
implements IFluidHandler {
    private final IFluidTank tank;

    public GenericFluidHandler(IFluidTank tank) {
        this.tank = tank;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid()) || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from, null)) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public static class Drain
    extends GenericFluidHandler {
        public Drain(IFluidTank tank) {
            super(tank);
        }

        @Override
        public boolean canDrain(ForgeDirection from, Fluid fluid) {
            return false;
        }

        @Override
        public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
            return null;
        }

        @Override
        public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
            return null;
        }
    }

    public static class Source
    extends GenericFluidHandler {
        public Source(IFluidTank tank) {
            super(tank);
        }

        @Override
        public boolean canFill(ForgeDirection from, Fluid fluid) {
            return false;
        }

        @Override
        public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
            return 0;
        }
    }
}

