/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import openmods.Log;
import openmods.block.OpenBlock;
import openmods.renderer.IBlockRenderer;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public abstract class BlockRenderingHandlerBase
implements ISimpleBlockRenderingHandler {
    protected final Map<Block, TileEntity> inventoryTileEntities = Maps.newIdentityHashMap();
    protected final Map<Block, IBlockRenderer<Block>> blockRenderers = Maps.newIdentityHashMap();

    public <B extends Block> void addRenderer(B block, IBlockRenderer<B> renderer) {
        this.blockRenderers.put(block, renderer);
    }

    public TileEntity getTileEntityForBlock(OpenBlock block) {
        TileEntity te = this.inventoryTileEntities.get(block);
        if (te == null) {
            te = block.createTileEntityForRender();
            this.inventoryTileEntities.put(block, te);
        }
        return te;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        Class<? extends TileEntity> teClass;
        if (this.blockRenderers.containsKey(block)) {
            this.blockRenderers.get(block).renderInventoryBlock(block, metadata, modelID, renderer);
            return;
        }
        OpenBlock openBlock = block instanceof OpenBlock ? (OpenBlock)block : null;
        TileEntity te = null;
        if (openBlock != null && openBlock.useTESRForInventory() && (teClass = openBlock.getTileClass()) != null && TileEntityRenderer.field_76963_a.field_76966_m.containsKey(teClass) && (te = this.getTileEntityForBlock(openBlock)) instanceof OpenTileEntity) {
            ((OpenTileEntity)te).prepareForInventoryRender(block, metadata);
        }
        try {
            GL11.glEnable((int)32826);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (te != null) {
                GL11.glPushAttrib((int)262144);
                GL11.glPushMatrix();
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                TileEntityRenderer.field_76963_a.func_76949_a(te, 0.0, 0.0, 0.0, 0.0f);
                GL11.glPopMatrix();
                GL11.glPopAttrib();
            }
            if (openBlock == null || openBlock.shouldRenderBlock()) {
                ForgeDirection rotation;
                if (block instanceof OpenBlock) {
                    rotation = openBlock.getInventoryRenderRotation();
                    openBlock.setBoundsBasedOnRotation(rotation);
                    RenderUtils.rotateFacesOnRenderer(openBlock, rotation, renderer);
                } else {
                    rotation = ForgeDirection.EAST;
                }
                RenderUtils.renderInventoryBlock(renderer, block, rotation);
                RenderUtils.resetFacesOnRenderer(renderer);
            }
        }
        catch (Exception e) {
            Log.severe(e, "Error during block '%s' rendering", block.func_71917_a());
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        OpenBlock openBlock = block instanceof OpenBlock ? (OpenBlock)block : null;
        IBlockRenderer<Block> customRenderer = this.blockRenderers.get(block);
        if (customRenderer != null) {
            return customRenderer.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        }
        if (openBlock == null || openBlock.shouldRenderBlock()) {
            if (openBlock != null) {
                int metadata = world.func_72805_g(x, y, z);
                ForgeDirection rotation = ForgeDirection.getOrientation((int)metadata);
                RenderUtils.rotateFacesOnRenderer((OpenBlock)block, rotation, renderer);
            }
            renderer.func_78570_q(block, x, y, z);
            RenderUtils.resetFacesOnRenderer(renderer);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }
}

