/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import openmods.structured.Command;
import openmods.structured.IStructureContainer;
import openmods.structured.IStructureContainerFactory;
import openmods.structured.IStructureElement;
import openmods.structured.StructuredData;

public abstract class StructuredDataSlave<C extends IStructureContainer<E>, E extends IStructureElement>
extends StructuredData<C, E> {
    public final IStructureContainerFactory<C> factory;

    protected StructuredDataSlave(IStructureContainerFactory<C> factory) {
        this.factory = factory;
    }

    protected abstract void onConsistencyCheckFail();

    public void interpretCommandList(List<Command> commands) {
        for (Command c : commands) {
            Command msg;
            if (c.isEnd()) break;
            if (c instanceof Command.ConsistencyCheck) {
                int maxElementId;
                msg = (Command.ConsistencyCheck)c;
                NavigableSet containers = this.containerToElement.keySet();
                int containerCount = containers.size();
                int maxContainerId = containerCount == 0 ? 0 : (Integer)containers.last();
                int elementCount = this.elements.size();
                int n = maxElementId = elementCount == 0 ? 0 : (Integer)this.elements.lastKey();
                if (msg.version == this.version && msg.containerCount == containerCount && msg.maxContainerId == maxContainerId && msg.elementCount == elementCount && msg.maxElementId == maxElementId) continue;
                this.onConsistencyCheckFail();
                break;
            }
            if (c instanceof Command.SetVersion) {
                msg = (Command.SetVersion)c;
                this.version = ((Command.SetVersion)msg).version;
                continue;
            }
            if (c instanceof Command.Reset) {
                this.reset();
                continue;
            }
            if (c instanceof Command.Create) {
                msg = (Command.Create)c;
                TreeSet elements = Sets.newTreeSet();
                for (Command.ContainerInfo pair : ((Command.Create)msg).containers) {
                    SortedSet<Integer> newElementsId = this.addReplaceContainer(pair.type, pair.id, pair.start);
                    elements.addAll(newElementsId);
                }
                this.readPayload(elements, ((Command.Create)msg).payload);
                continue;
            }
            if (c instanceof Command.Delete) {
                msg = (Command.Delete)c;
                Iterator i$ = ((Command.Delete)msg).idList.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    this.removeContainer(i);
                }
                continue;
            }
            if (!(c instanceof Command.Update)) continue;
            msg = (Command.Update)c;
            this.readPayload(((Command.Update)msg).idList, ((Command.Update)msg).payload);
            this.version = (byte)(this.version + ((Command.Update)msg).idList.size());
        }
    }

    private SortedSet<Integer> addReplaceContainer(int type, int containerId, int start) {
        C container = this.factory.createContainer(containerId, type);
        if (this.containerToElement.containsEntry((Object)containerId, (Object)start)) {
            this.onConsistencyCheckFail();
            return ImmutableSortedSet.of();
        }
        this.addContainer(containerId, container, start);
        return this.containerToElement.get((Object)containerId);
    }

    private void readPayload(SortedSet<Integer> ids, byte[] payload) {
        try {
            ByteArrayDataInput input = ByteStreams.newDataInput((byte[])payload);
            for (Integer id : ids) {
                IStructureElement element = (IStructureElement)this.elements.get(id);
                if (element == null) {
                    this.onConsistencyCheckFail();
                }
                element.readFromStream((DataInput)input);
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

