/*
 * Decompiled with CFR 0.152.
 */
package enviromine.trackers;

import enviromine.EnviroDamageSource;
import enviromine.EnviroPotion;
import enviromine.core.EM_Settings;
import enviromine.core.EnviroMine;
import enviromine.handlers.EM_StatusManager;
import enviromine.trackers.EntityProperties;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;

public class EnviroDataTracker {
    public EntityLivingBase trackedEntity;
    public float prevBodyTemp = 37.0f;
    public float prevHydration = 100.0f;
    public float prevAirQuality = 100.0f;
    public float prevSanity = 100.0f;
    public float airQuality;
    public float bodyTemp;
    public float airTemp;
    public float hydration;
    public float sanity;
    public int attackDelay = 0;
    public int curAttackTime = 0;
    public boolean isDisabled = false;
    public int itemUse = 0;
    public int frostbiteLevel = 0;
    public boolean brokenLeg = false;
    public boolean brokenArm = false;
    public boolean bleedingOut = false;
    public String sleepState = "Awake";
    public int lastSleepTime = 0;
    public int timeBelow10 = 0;
    public int updateTimer = 0;

    public EnviroDataTracker(EntityLivingBase entity) {
        this.trackedEntity = entity;
        this.airQuality = 100.0f;
        this.bodyTemp = 37.0f;
        this.hydration = 100.0f;
        this.sanity = 100.0f;
    }

    public void updateData() {
        ItemStack plate;
        float spAmp;
        this.prevBodyTemp = this.bodyTemp;
        this.prevAirQuality = this.airQuality;
        this.prevHydration = this.hydration;
        this.prevSanity = this.sanity;
        this.updateTimer = 0;
        if (this.trackedEntity == null || this.isDisabled) {
            EM_StatusManager.removeTracker(this);
            return;
        }
        if (this.trackedEntity.field_70128_L) {
            if (this.trackedEntity instanceof EntityPlayer) {
                EntityPlayer player = EM_StatusManager.findPlayer(((EntityPlayer)this.trackedEntity).field_71092_bJ);
                if (player == null) {
                    EM_StatusManager.saveAndRemoveTracker(this);
                    return;
                }
                this.trackedEntity = player;
                this.isDisabled = false;
                this.loadNBTTags();
            } else {
                EM_StatusManager.removeTracker(this);
                return;
            }
        }
        if (!(this.trackedEntity instanceof EntityPlayer) && !EM_Settings.trackNonPlayer || !EM_Settings.enableAirQ && !EM_Settings.enableBodyTemp && !EM_Settings.enableHydrate && !EM_Settings.enableSanity) {
            EM_StatusManager.saveAndRemoveTracker(this);
        }
        int i = MathHelper.func_76128_c((double)this.trackedEntity.field_70165_t);
        int k = MathHelper.func_76128_c((double)this.trackedEntity.field_70161_v);
        if (!this.trackedEntity.field_70170_p.func_72938_d((int)i, (int)k).field_76636_d) {
            return;
        }
        float[] enviroData = EM_StatusManager.getSurroundingData(this.trackedEntity, 5);
        if ((this.trackedEntity.func_110143_aJ() <= 2.0f || this.bodyTemp >= 41.0f) && enviroData[7] > (float)(-1.0 * EM_Settings.sanityMult)) {
            enviroData[7] = (float)(-1.0 * EM_Settings.sanityMult);
        }
        this.airQuality += enviroData[0];
        if (this.airQuality <= 0.0f) {
            this.airQuality = 0.0f;
        }
        if (this.airQuality >= 100.0f) {
            this.airQuality = 100.0f;
        }
        this.airTemp = enviroData[1];
        float tnm = enviroData[4];
        float tpm = enviroData[5];
        if (this.bodyTemp - this.airTemp > 0.0f) {
            float f = spAmp = Math.abs(this.bodyTemp - this.airTemp) > 10.0f ? Math.abs(this.bodyTemp - this.airTemp) / 10.0f : 1.0f;
            this.bodyTemp = this.bodyTemp - this.airTemp >= tnm * spAmp ? (this.bodyTemp -= tnm * spAmp) : this.airTemp;
        } else if (this.bodyTemp - this.airTemp < 0.0f) {
            float f = spAmp = Math.abs(this.bodyTemp - this.airTemp) > 10.0f ? Math.abs(this.bodyTemp - this.airTemp) / 10.0f : 1.0f;
            this.bodyTemp = this.bodyTemp - this.airTemp <= -tpm * spAmp ? (this.bodyTemp += tpm * spAmp) : this.airTemp;
        }
        if (this.hydration > 0.0f && (enviroData[6] == 1.0f || !(this.trackedEntity instanceof EntityAnimal))) {
            if (this.bodyTemp >= 38.02f) {
                this.dehydrate(0.1f);
                if (this.hydration >= 75.0f) {
                    this.bodyTemp -= 0.01f;
                }
            }
            if (enviroData[3] > 0.0f) {
                this.dehydrate(0.05f + enviroData[3]);
            } else {
                if (enviroData[3] < 0.0f) {
                    this.hydrate(-enviroData[3]);
                }
                this.dehydrate(0.05f);
            }
        } else if (enviroData[6] == -1.0f && this.trackedEntity instanceof EntityAnimal) {
            this.hydrate(0.05f);
        } else if (this.hydration <= 0.0f) {
            this.hydration = 0.0f;
        }
        if (this.sanity < 0.0f) {
            this.sanity = 0.0f;
        }
        if (enviroData[7] < 0.0f) {
            this.sanity = this.sanity + enviroData[7] >= 0.0f ? (this.sanity += enviroData[7]) : 0.0f;
        } else if (enviroData[7] > 0.0f) {
            this.sanity = this.sanity + enviroData[7] <= 100.0f ? (this.sanity += enviroData[7]) : 100.0f;
        }
        boolean enableAirQ = true;
        boolean enableBodyTemp = true;
        boolean enableHydrate = true;
        boolean enableFrostbite = true;
        boolean enableHeat = true;
        if (EntityList.func_75619_a((Entity)this.trackedEntity) > 0) {
            if (EM_Settings.livingProperties.containsKey(EntityList.func_75619_a((Entity)this.trackedEntity))) {
                EntityProperties livingProps = EM_Settings.livingProperties.get(EntityList.func_75619_a((Entity)this.trackedEntity));
                enableHydrate = livingProps.dehydration;
                enableBodyTemp = livingProps.bodyTemp;
                enableAirQ = livingProps.airQ;
                enableFrostbite = !livingProps.immuneToFrost;
                enableHeat = !livingProps.immuneToHeat;
            } else if (this.trackedEntity instanceof EntitySheep || this.trackedEntity instanceof EntityWolf) {
                enableFrostbite = false;
            } else if (this.trackedEntity instanceof EntityChicken) {
                enableHeat = false;
            }
        }
        if (!EM_Settings.enableAirQ || !enableAirQ) {
            this.airQuality = 100.0f;
        }
        if (!EM_Settings.enableBodyTemp || !enableBodyTemp) {
            this.bodyTemp = 37.0f;
        }
        if (!EM_Settings.enableHydrate || !enableHydrate) {
            this.hydration = 100.0f;
        }
        if (!EM_Settings.enableSanity || !(this.trackedEntity instanceof EntityPlayer)) {
            this.sanity = 100.0f;
        }
        if ((plate = this.trackedEntity.func_71124_b(3)) != null && plate.field_77993_c == EnviroMine.camelPack.field_77779_bT && plate.func_77960_j() < plate.func_77958_k() && (double)this.hydration <= 99.0 - EM_Settings.hydrationMult) {
            plate.func_77964_b(plate.func_77960_j() + 1);
            this.hydrate((float)EM_Settings.hydrationMult);
            if ((double)this.bodyTemp >= 37.0 + EM_Settings.tempMult / 10.0) {
                this.bodyTemp = (float)((double)this.bodyTemp - EM_Settings.tempMult / 10.0);
            }
        }
        this.fixFloatinfPointErrors();
        if (this.trackedEntity instanceof EntityPlayer && ((EntityPlayer)this.trackedEntity).field_71075_bZ.field_75098_d) {
            this.bodyTemp = this.prevBodyTemp;
            this.airQuality = this.prevAirQuality;
            this.hydration = this.prevHydration;
            this.sanity = this.prevSanity;
        }
        this.timeBelow10 = this.airTemp <= 10.0f && this.bodyTemp <= 35.0f || this.bodyTemp <= 30.0f ? ++this.timeBelow10 : 0;
        if (this.curAttackTime >= this.attackDelay) {
            if (this.airQuality <= 0.0f) {
                this.trackedEntity.func_70097_a((DamageSource)EnviroDamageSource.suffocate, 4.0f);
            }
            if (this.airQuality <= 10.0f) {
                this.trackedEntity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 200, 1));
                this.trackedEntity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 1));
            } else if (this.airQuality <= 25.0f) {
                this.trackedEntity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 200, 0));
                this.trackedEntity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 0));
            }
            if (!this.trackedEntity.func_70644_a(Potion.field_76426_n)) {
                if (this.bodyTemp >= 39.0f && enableHeat && (enviroData[6] == 1.0f || !(this.trackedEntity instanceof EntityAnimal))) {
                    if (this.bodyTemp >= 43.0f) {
                        this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.heatstroke.field_76415_H, 200, 2));
                    } else if (this.bodyTemp >= 41.0f) {
                        this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.heatstroke.field_76415_H, 200, 1));
                    } else {
                        this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.heatstroke.field_76415_H, 200, 0));
                    }
                }
            } else if (this.trackedEntity.func_70644_a((Potion)EnviroPotion.heatstroke)) {
                this.trackedEntity.func_82170_o(EnviroPotion.heatstroke.field_76415_H);
            }
            if (this.bodyTemp <= 35.0f && enableFrostbite && (enviroData[6] == 1.0f || !(this.trackedEntity instanceof EntityAnimal))) {
                if (this.bodyTemp <= 30.0f) {
                    this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.hypothermia.field_76415_H, 200, 2));
                } else if (this.bodyTemp <= 32.0f) {
                    this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.hypothermia.field_76415_H, 200, 1));
                } else {
                    this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.hypothermia.field_76415_H, 200, 0));
                }
            }
            if (this.timeBelow10 >= 120 && enableFrostbite || this.frostbiteLevel >= 1 && enableFrostbite) {
                if (this.timeBelow10 >= 240 || this.frostbiteLevel >= 2) {
                    this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.frostbite.field_76415_H, 200, 1));
                    if (this.frostbiteLevel <= 2) {
                        this.frostbiteLevel = 2;
                    }
                } else {
                    this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.frostbite.field_76415_H, 200, 0));
                    if (this.frostbiteLevel <= 1) {
                        this.frostbiteLevel = 1;
                    }
                }
            }
            if (this.bodyTemp >= 45.0f && enviroData[2] == 1.0f) {
                this.trackedEntity.func_70015_d(10);
            }
            if (this.hydration <= 0.0f) {
                this.trackedEntity.func_70097_a((DamageSource)EnviroDamageSource.dehydrate, 4.0f);
            }
            if (this.sanity <= 10.0f) {
                this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.insanity.field_76415_H, 600, 2));
            } else if (this.sanity <= 25.0f) {
                this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.insanity.field_76415_H, 600, 1));
            } else if (this.sanity <= 50.0f) {
                this.trackedEntity.func_70690_d(new PotionEffect(EnviroPotion.insanity.field_76415_H, 600, 0));
            }
            this.curAttackTime = 0;
        } else {
            ++this.curAttackTime;
        }
        EnviroPotion.checkAndApplyEffects(this.trackedEntity);
        this.fixFloatinfPointErrors();
        EM_StatusManager.saveTracker(this);
    }

    public void fixFloatinfPointErrors() {
        this.airQuality = new BigDecimal(String.valueOf(this.airQuality)).setScale(2, RoundingMode.HALF_UP).floatValue();
        this.bodyTemp = new BigDecimal(String.valueOf(this.bodyTemp)).setScale(3, RoundingMode.HALF_UP).floatValue();
        this.airTemp = new BigDecimal(String.valueOf(this.airTemp)).setScale(3, RoundingMode.HALF_UP).floatValue();
        this.hydration = new BigDecimal(String.valueOf(this.hydration)).setScale(2, RoundingMode.HALF_UP).floatValue();
        this.sanity = new BigDecimal(String.valueOf(this.sanity)).setScale(3, RoundingMode.HALF_UP).floatValue();
    }

    public static boolean isLegalType(EntityLivingBase entity) {
        String name = EntityList.func_75621_b((Entity)entity);
        if (EM_Settings.livingProperties.containsKey(EntityList.func_75619_a((Entity)entity))) {
            return EM_Settings.livingProperties.get((Object)Integer.valueOf((int)EntityList.func_75619_a((Entity)entity))).shouldTrack;
        }
        if (entity.func_70662_br() || entity instanceof EntityMob) {
            return false;
        }
        if (name == "Enderman") {
            return false;
        }
        if (name == "Villager") {
            return false;
        }
        if (name == "Slime") {
            return false;
        }
        if (name == "Ghast") {
            return false;
        }
        if (name == "Squid") {
            return false;
        }
        if (name == "Blaze") {
            return false;
        }
        if (name == "LavaSlime") {
            return false;
        }
        if (name == "SnowMan") {
            return false;
        }
        if (name == "MushroomCow") {
            return false;
        }
        if (name == "WitherBoss") {
            return false;
        }
        if (name == "EnderDragon") {
            return false;
        }
        if (name == "VillagerGolem") {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EnviroDataTracker tracker = EM_StatusManager.lookupTracker(entity);
            return tracker == null;
        }
        return true;
    }

    public void hydrate(float amount) {
        float MAmount = (float)((double)amount * EM_Settings.hydrationMult);
        this.hydration = this.hydration >= 100.0f - MAmount ? 100.0f : (this.hydration += MAmount);
        this.fixFloatinfPointErrors();
        if (!EnviroMine.proxy.isClient() || EnviroMine.proxy.isOpenToLAN()) {
            EM_StatusManager.syncMultiplayerTracker(this);
        }
    }

    public void dehydrate(float amount) {
        float MAmount = (float)((double)amount * EM_Settings.hydrationMult);
        this.hydration = this.hydration >= MAmount ? (this.hydration -= MAmount) : 0.0f;
        this.fixFloatinfPointErrors();
        if (!EnviroMine.proxy.isClient() || EnviroMine.proxy.isOpenToLAN()) {
            EM_StatusManager.syncMultiplayerTracker(this);
        }
    }

    public void loadNBTTags() {
        NBTTagCompound tags = this.trackedEntity.getEntityData();
        if (tags.func_74764_b("ENVIRO_AIR")) {
            this.airQuality = tags.func_74760_g("ENVIRO_AIR");
        }
        if (tags.func_74764_b("ENVIRO_HYD")) {
            this.hydration = tags.func_74760_g("ENVIRO_HYD");
        }
        if (tags.func_74764_b("ENVIRO_TMP")) {
            this.bodyTemp = tags.func_74760_g("ENVIRO_TMP");
        }
        if (tags.func_74764_b("ENVIRO_SAN")) {
            this.sanity = tags.func_74760_g("ENVIRO_SAN");
        }
    }

    public int getAndIncrementItemUse() {
        ++this.itemUse;
        return this.itemUse;
    }

    public void resetItemUse() {
        this.itemUse = 0;
    }

    public void resetData() {
        this.airQuality = 100.0f;
        this.bodyTemp = 37.0f;
        this.hydration = 100.0f;
        this.sanity = 100.0f;
    }
}

