/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import java.util.Iterator;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerArrayBytes;
import stanhebben.minetweaker.api.value.TweakerArrayInts;
import stanhebben.minetweaker.api.value.TweakerByte;
import stanhebben.minetweaker.api.value.TweakerField;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;

public abstract class TweakerArray
extends TweakerValue {
    public abstract int size();

    public abstract TweakerValue get(int var1);

    public abstract TweakerValue remove(int var1);

    @Override
    public TweakerArray asArray() {
        return this;
    }

    @Override
    public TweakerArrayBytes asByteArray() {
        byte[] result = new byte[this.size()];
        for (int i = 0; i < result.length; ++i) {
            TweakerByte asByte = this.get(i).asByte();
            if (asByte == null) {
                return null;
            }
            result[i] = asByte.get();
        }
        return new TweakerArrayBytes(result);
    }

    @Override
    public TweakerArrayInts asIntArray() {
        int[] result = new int[this.size()];
        for (int i = 0; i < result.length; ++i) {
            TweakerInt asInt = this.get(i).asInt();
            if (asInt == null) {
                return null;
            }
            result[i] = asInt.get();
        }
        return new TweakerArrayInts(result);
    }

    @Override
    public abstract TweakerValue addAssign(TweakerValue var1);

    @Override
    public abstract TweakerValue subAssign(TweakerValue var1);

    @Override
    public TweakerValue index(TweakerValue value) {
        if (value == null) {
            throw new TweakerExecuteException("Cannot index an array with a null value");
        }
        if (value.getClass() == TweakerString.class) {
            return this.index(value.asString());
        }
        return this.get(value.toBasicInt());
    }

    @Override
    public TweakerValue index(int value) {
        return this.get(value);
    }

    @Override
    public TweakerValue index(String index) {
        switch (TweakerField.get(index)) {
            case BYTEARRAY: {
                return this.asByteArray();
            }
            case INTARRAY: {
                return this.asIntArray();
            }
            case LENGTH: {
                return new TweakerInt(this.size());
            }
        }
        throw new TweakerExecuteException("on such member in array: " + index);
    }

    @Override
    public abstract Iterator<TweakerValue> iterator();

    @Override
    public cl toTagValue(String name) {
        cg list = new cg(name);
        Iterator<TweakerValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            TweakerValue value = iterator.next();
            cl tag = value.toTagValue(null);
            if (tag == null) {
                throw new TweakerExecuteException("Could not convert " + value + " to NBT value");
            }
            list.a(tag);
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[');
        boolean first = true;
        Iterator<TweakerValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            TweakerValue value = iterator.next();
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            result.append(value.toString());
        }
        result.append(']');
        return result.toString();
    }
}

