/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.tweaker.FuelTweaker;

public class SetFuelItemAction
implements IUndoableAction {
    private TweakerItem item;
    private int newValue;
    private Integer oldValue;

    public SetFuelItemAction(TweakerItem item, int value) {
        this.item = item;
        this.newValue = value;
    }

    @Override
    public void apply() {
        this.oldValue = this.item.isSubItem() ? FuelTweaker.INSTANCE.setFuelItem(this.item.getItemId(), this.item.getItemSubId(), this.newValue) : FuelTweaker.INSTANCE.setFuelItem(this.item.getItemId(), this.newValue);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.item.isSubItem()) {
            FuelTweaker.INSTANCE.setFuelItem(this.item.getItemId(), this.item.getItemSubId(), this.oldValue);
        } else {
            FuelTweaker.INSTANCE.setFuelItem(this.item.getItemId(), this.oldValue);
        }
    }

    @Override
    public String describe() {
        return "Setting the fuel value for " + this.item.getDisplayName() + " to " + this.newValue + " ticks";
    }

    @Override
    public String describeUndo() {
        return "Restoring the fuel value for " + this.item.getDisplayName() + " to " + this.oldValue + " ticks";
    }
}

