/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.functions;

import buildcraft.api.core.StackWrapper;
import buildcraft.api.fuels.IronEngineCoolant;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerBool;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerValue;

public class ContainsCoolantFunction
extends TweakerFunction {
    public static final ContainsCoolantFunction INSTANCE = new ContainsCoolantFunction();

    private ContainsCoolantFunction() {
    }

    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        if (arguments.length == 0) {
            throw new TweakerExecuteException("coolants.contains requires one argument");
        }
        TweakerValue value = ContainsCoolantFunction.notNull(arguments[0], "the coolants.contains argument cannot be null");
        if (value.asFluid() != null) {
            return TweakerBool.get(IronEngineCoolant.liquidCoolants.containsKey(value.asFluid().get().getName()));
        }
        if (value.asItem() != null) {
            return TweakerBool.get(IronEngineCoolant.solidCoolants.containsKey(new StackWrapper(value.asItem().make(1))));
        }
        throw new TweakerExecuteException("the coolants.contains argument must be a fluid or item");
    }

    @Override
    public String toString() {
        return "buildcraft.coolants.contains";
    }
}

