/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.recipes.RecipeManagers;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerItemStack;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;

public class CarpenterAddRecipeAction
implements IUndoableAction {
    private final TweakerItemStack output;
    private final Object[] input;
    private final TweakerItem box;
    private final int packagingTime;
    private final TweakerLiquidStack liquid;

    public CarpenterAddRecipeAction(TweakerItemStack output, Object[] input, TweakerItem box, int packagingTime, TweakerLiquidStack liquid) {
        this.output = output;
        this.input = input;
        this.box = box;
        this.packagingTime = packagingTime;
        this.liquid = liquid;
    }

    @Override
    public void apply() {
        if (this.liquid != null) {
            RecipeManagers.carpenterManager.addRecipe(this.packagingTime, this.liquid.get(), this.box == null ? null : this.box.make(1), this.output.get(), this.input);
        } else if (this.packagingTime > 0) {
            RecipeManagers.carpenterManager.addRecipe(this.packagingTime, this.box == null ? null : this.box.make(1), this.output.get(), this.input);
        } else {
            RecipeManagers.carpenterManager.addRecipe(this.box == null ? null : this.box.make(1), this.output.get(), this.input);
        }
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String describe() {
        return "Adding a carpenter recipe for " + this.output.getDisplayName();
    }

    @Override
    public String describeUndo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

