/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.script.expressions;

import java.util.ArrayList;
import stanhebben.minetweaker.api.TweakerException;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerBool;
import stanhebben.minetweaker.api.value.TweakerDouble;
import stanhebben.minetweaker.api.value.TweakerFunctionScript;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerItemPatternAny;
import stanhebben.minetweaker.api.value.TweakerItemPatternAnyMeta;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.script.TweakerFile;
import stanhebben.minetweaker.script.TweakerParser;
import stanhebben.minetweaker.script.expressions.TweakerExpressionAdd;
import stanhebben.minetweaker.script.expressions.TweakerExpressionAddAssign;
import stanhebben.minetweaker.script.expressions.TweakerExpressionAnd;
import stanhebben.minetweaker.script.expressions.TweakerExpressionAndAnd;
import stanhebben.minetweaker.script.expressions.TweakerExpressionAndAssign;
import stanhebben.minetweaker.script.expressions.TweakerExpressionArray;
import stanhebben.minetweaker.script.expressions.TweakerExpressionAs;
import stanhebben.minetweaker.script.expressions.TweakerExpressionAssign;
import stanhebben.minetweaker.script.expressions.TweakerExpressionCall;
import stanhebben.minetweaker.script.expressions.TweakerExpressionConditional;
import stanhebben.minetweaker.script.expressions.TweakerExpressionConstant;
import stanhebben.minetweaker.script.expressions.TweakerExpressionDiv;
import stanhebben.minetweaker.script.expressions.TweakerExpressionDivAssign;
import stanhebben.minetweaker.script.expressions.TweakerExpressionDollar;
import stanhebben.minetweaker.script.expressions.TweakerExpressionEq;
import stanhebben.minetweaker.script.expressions.TweakerExpressionIn;
import stanhebben.minetweaker.script.expressions.TweakerExpressionIndex;
import stanhebben.minetweaker.script.expressions.TweakerExpressionIndexString;
import stanhebben.minetweaker.script.expressions.TweakerExpressionItemId;
import stanhebben.minetweaker.script.expressions.TweakerExpressionItemIdMeta;
import stanhebben.minetweaker.script.expressions.TweakerExpressionLt;
import stanhebben.minetweaker.script.expressions.TweakerExpressionLtEq;
import stanhebben.minetweaker.script.expressions.TweakerExpressionMod;
import stanhebben.minetweaker.script.expressions.TweakerExpressionModAssign;
import stanhebben.minetweaker.script.expressions.TweakerExpressionMul;
import stanhebben.minetweaker.script.expressions.TweakerExpressionMulAssign;
import stanhebben.minetweaker.script.expressions.TweakerExpressionNeg;
import stanhebben.minetweaker.script.expressions.TweakerExpressionNot;
import stanhebben.minetweaker.script.expressions.TweakerExpressionNotEq;
import stanhebben.minetweaker.script.expressions.TweakerExpressionOr;
import stanhebben.minetweaker.script.expressions.TweakerExpressionOrAssign;
import stanhebben.minetweaker.script.expressions.TweakerExpressionOrOr;
import stanhebben.minetweaker.script.expressions.TweakerExpressionRange;
import stanhebben.minetweaker.script.expressions.TweakerExpressionSub;
import stanhebben.minetweaker.script.expressions.TweakerExpressionSubAssign;
import stanhebben.minetweaker.script.expressions.TweakerExpressionTable;
import stanhebben.minetweaker.script.expressions.TweakerExpressionVariable;
import stanhebben.minetweaker.script.expressions.TweakerExpressionXor;
import stanhebben.minetweaker.script.expressions.TweakerExpressionXorAssign;
import stanhebben.minetweaker.script.parser.ParseException;
import stanhebben.minetweaker.script.parser.Token;
import stanhebben.minetweaker.script.statements.TweakerStatement;
import stanhebben.minetweaker.script.types.TweakerType;

public abstract class TweakerExpression {
    private final TweakerFile file;
    private final int line;
    private final int offset;

    public static TweakerExpression read(TweakerFile file, TweakerParser parser) {
        return TweakerExpression.readAssignExpression(file, parser);
    }

    private static TweakerExpression readAssignExpression(TweakerFile file, TweakerParser parser) {
        int line = parser.peek().getLine();
        int offset = parser.peek().getLineOffset();
        TweakerExpression left = TweakerExpression.readConditionalExpression(file, line, offset, parser);
        switch (parser.peek() == null ? -1 : parser.peek().getType()) {
            case 39: {
                parser.next();
                return left.assign(file, line, offset, TweakerExpression.readAssignExpression(file, parser));
            }
            case 12: {
                parser.next();
                return new TweakerExpressionAddAssign(file, line, offset, left, TweakerExpression.readAssignExpression(file, parser));
            }
            case 14: {
                parser.next();
                return new TweakerExpressionSubAssign(file, line, offset, left, TweakerExpression.readAssignExpression(file, parser));
            }
            case 16: {
                parser.next();
                return new TweakerExpressionMulAssign(file, line, offset, left, TweakerExpression.readAssignExpression(file, parser));
            }
            case 18: {
                parser.next();
                return new TweakerExpressionDivAssign(file, line, offset, left, TweakerExpression.readAssignExpression(file, parser));
            }
            case 20: {
                parser.next();
                return new TweakerExpressionModAssign(file, line, offset, left, TweakerExpression.readAssignExpression(file, parser));
            }
            case 22: {
                parser.next();
                return new TweakerExpressionOrAssign(file, line, offset, left, TweakerExpression.readAssignExpression(file, parser));
            }
            case 24: {
                parser.next();
                return new TweakerExpressionAndAssign(file, line, offset, left, TweakerExpression.readAssignExpression(file, parser));
            }
            case 26: {
                parser.next();
                return new TweakerExpressionXorAssign(file, line, offset, left, TweakerExpression.readAssignExpression(file, parser));
            }
        }
        return left;
    }

    private static TweakerExpression readConditionalExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        TweakerExpression left = TweakerExpression.readOrOrExpression(file, line, offset, parser);
        if (parser.optional(28) != null) {
            TweakerExpression onIf = TweakerExpression.readOrOrExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
            parser.required(29, ": expected");
            TweakerExpression onElse = TweakerExpression.readConditionalExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
            return new TweakerExpressionConditional(file, line, offset, left, onIf, onElse);
        }
        return left;
    }

    private static TweakerExpression readOrOrExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        TweakerExpression left = TweakerExpression.readAndAndExpression(file, line, offset, parser);
        while (parser.optional(40) != null) {
            TweakerExpression right = TweakerExpression.readAndAndExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
            left = new TweakerExpressionOrOr(file, line, offset, left, right);
        }
        return left;
    }

    private static TweakerExpression readAndAndExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        TweakerExpression left = TweakerExpression.readOrExpression(file, line, offset, parser);
        while (parser.optional(41) != null) {
            TweakerExpression right = TweakerExpression.readOrExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
            left = new TweakerExpressionAndAnd(file, line, offset, left, right);
        }
        return left;
    }

    private static TweakerExpression readOrExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        TweakerExpression left = TweakerExpression.readXorExpression(file, line, offset, parser);
        while (parser.optional(23) != null) {
            TweakerExpression right = TweakerExpression.readXorExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
            left = new TweakerExpressionOr(file, line, offset, left, right);
        }
        return left;
    }

    private static TweakerExpression readXorExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        TweakerExpression left = TweakerExpression.readAndExpression(file, line, offset, parser);
        while (parser.optional(27) != null) {
            TweakerExpression right = TweakerExpression.readAndExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
            left = new TweakerExpressionXor(file, line, offset, left, right);
        }
        return left;
    }

    private static TweakerExpression readAndExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        TweakerExpression left = TweakerExpression.readCompareExpression(file, line, offset, parser);
        while (parser.optional(25) != null) {
            TweakerExpression right = TweakerExpression.readCompareExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
            left = new TweakerExpressionAnd(file, line, offset, left, right);
        }
        return left;
    }

    private static TweakerExpression readCompareExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        TweakerExpression left = TweakerExpression.readAddExpression(file, line, offset, parser);
        switch (parser.peek() == null ? -1 : parser.peek().getType()) {
            case 38: {
                parser.next();
                TweakerExpression right = TweakerExpression.readAddExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                return new TweakerExpressionEq(file, line, offset, left, right);
            }
            case 42: {
                parser.next();
                TweakerExpression right = TweakerExpression.readAddExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                return new TweakerExpressionNotEq(file, line, offset, left, right);
            }
            case 35: {
                parser.next();
                TweakerExpression right = TweakerExpression.readAddExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                return new TweakerExpressionLt(file, line, offset, left, right);
            }
            case 34: {
                parser.next();
                TweakerExpression right = TweakerExpression.readAddExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                return new TweakerExpressionLtEq(file, line, offset, left, right);
            }
            case 37: {
                parser.next();
                TweakerExpression right = TweakerExpression.readAddExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                return new TweakerExpressionLt(file, line, offset, right, left);
            }
            case 36: {
                parser.next();
                TweakerExpression right = TweakerExpression.readAddExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                return new TweakerExpressionLtEq(file, line, offset, right, left);
            }
            case 109: {
                parser.next();
                TweakerExpression right = TweakerExpression.readAddExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                return new TweakerExpressionIn(file, line, offset, right, left);
            }
        }
        return left;
    }

    private static TweakerExpression readAddExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        TweakerExpression left = TweakerExpression.readMulExpression(file, line, offset, parser);
        while (true) {
            TweakerExpression right;
            if (parser.optional(13) != null) {
                right = TweakerExpression.readMulExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                left = new TweakerExpressionAdd(file, line, offset, left, right);
                continue;
            }
            if (parser.optional(15) == null) break;
            right = TweakerExpression.readMulExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
            left = new TweakerExpressionSub(file, line, offset, left, right);
        }
        return left;
    }

    private static TweakerExpression readMulExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        TweakerExpression left = TweakerExpression.readUnaryExpression(file, line, offset, parser);
        while (true) {
            TweakerExpression right;
            if (parser.optional(17) != null) {
                right = TweakerExpression.readUnaryExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                left = new TweakerExpressionMul(file, line, offset, left, right);
                continue;
            }
            if (parser.optional(19) != null) {
                right = TweakerExpression.readUnaryExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                left = new TweakerExpressionDiv(file, line, offset, left, right);
                continue;
            }
            if (parser.optional(21) == null) break;
            right = TweakerExpression.readUnaryExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
            left = new TweakerExpressionMod(file, line, offset, left, right);
        }
        return left;
    }

    private static TweakerExpression readUnaryExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        switch (parser.peek().getType()) {
            case 43: {
                parser.next();
                return new TweakerExpressionNot(file, line, offset, TweakerExpression.readUnaryExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser));
            }
            case 15: {
                parser.next();
                return new TweakerExpressionNeg(file, line, offset, TweakerExpression.readUnaryExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser));
            }
        }
        return TweakerExpression.readPostfixExpression(file, line, offset, parser);
    }

    private static TweakerExpression readPostfixExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        TweakerExpression base = TweakerExpression.readPrimaryExpression(file, line, offset, parser);
        while (true) {
            if (parser.optional(10) != null) {
                Token indexString = parser.optional(1);
                if (indexString != null) {
                    base = new TweakerExpressionIndexString(file, line, offset, base, indexString.getValue());
                    continue;
                }
                TweakerExpression index = TweakerExpression.readPrimaryExpression(file, parser.peek().getLine(), parser.peek().getLineOffset(), parser);
                base = new TweakerExpressionIndex(file, line, offset, base, index);
                continue;
            }
            if (parser.optional(9) != null) {
                TweakerExpression to = TweakerExpression.readAssignExpression(file, parser);
                base = new TweakerExpressionRange(file, line, offset, base, to);
                continue;
            }
            if (parser.optional(7) != null) {
                TweakerExpression index = TweakerExpression.readAssignExpression(file, parser);
                base = new TweakerExpressionIndex(file, line, offset, base, index);
                parser.required(8, "] expected");
                continue;
            }
            if (parser.optional(30) != null) {
                if (parser.optional(31) != null) {
                    base = new TweakerExpressionCall(file, line, offset, base, new TweakerExpression[0]);
                    continue;
                }
                ArrayList<TweakerExpression> arguments = new ArrayList<TweakerExpression>();
                arguments.add(TweakerExpression.readAssignExpression(file, parser));
                while (parser.optional(11) != null) {
                    arguments.add(TweakerExpression.readAssignExpression(file, parser));
                }
                base = new TweakerExpressionCall(file, line, offset, base, arguments.toArray(new TweakerExpression[arguments.size()]));
                parser.required(31, ") expected");
                continue;
            }
            if (parser.optional(120) == null) break;
            TweakerType type = TweakerType.read(file, line, offset, parser);
            base = new TweakerExpressionAs(file, line, offset, base, type);
        }
        return base;
    }

    private static TweakerExpression readPrimaryExpression(TweakerFile file, int line, int offset, TweakerParser parser) {
        switch (parser.peek().getType()) {
            case 2: {
                return new TweakerExpressionConstant(file, line, offset, new TweakerInt(Integer.parseInt(parser.next().getValue())));
            }
            case 3: {
                return new TweakerExpressionConstant(file, line, offset, new TweakerDouble(Double.parseDouble(parser.next().getValue())));
            }
            case 4: {
                try {
                    return new TweakerExpressionConstant(file, line, offset, new TweakerString(TweakerString.unescapeString(parser.next().getValue())));
                }
                catch (TweakerExecuteException ex) {
                    throw new RuntimeException(ex.getMessage());
                }
            }
            case 44: {
                TweakerExpressionDollar result = new TweakerExpressionDollar(file, line, offset);
                if (parser.isNext(4)) {
                    try {
                        return new TweakerExpressionIndexString(file, line, offset, result, TweakerString.unescapeString(parser.next().getValue()));
                    }
                    catch (TweakerExecuteException ex) {
                        throw new RuntimeException(ex.getMessage());
                    }
                }
                return result;
            }
            case 1: {
                return new TweakerExpressionVariable(file, line, offset, parser.next().getValue());
            }
            case 108: {
                TweakerStatement[] statements;
                String[] argumentNames;
                parser.next();
                parser.required(30, "( expected");
                if (parser.optional(31) != null) {
                    argumentNames = new String[]{};
                } else {
                    ArrayList<String> argumentNamesAL = new ArrayList<String>();
                    argumentNamesAL.add(parser.required(1, "identifier expected").getValue());
                    while (parser.optional(11) != null) {
                        argumentNamesAL.add(parser.required(1, "identifier expected").getValue());
                    }
                    argumentNames = argumentNamesAL.toArray(new String[argumentNamesAL.size()]);
                    parser.required(31, ") expected");
                }
                parser.required(5, "{ expected");
                if (parser.optional(6) != null) {
                    statements = new TweakerStatement[]{};
                } else {
                    ArrayList<TweakerStatement> statementsAL = new ArrayList<TweakerStatement>();
                    while (parser.optional(6) == null) {
                        statementsAL.add(TweakerStatement.read(file, parser));
                    }
                    statements = statementsAL.toArray(new TweakerStatement[statementsAL.size()]);
                }
                return new TweakerExpressionConstant(file, line, offset, new TweakerFunctionScript(argumentNames, statements));
            }
            case 35: {
                parser.next();
                if (parser.optional(17) != null) {
                    parser.required(37, "> expected");
                    return new TweakerExpressionConstant(file, line, offset, TweakerItemPatternAny.INSTANCE);
                }
                int id = Integer.parseInt(parser.required(2, "integer expected").getValue());
                if (parser.optional(29) != null) {
                    if (parser.optional(17) != null) {
                        parser.required(37, "> expected");
                        return new TweakerExpressionConstant(file, line, offset, new TweakerItemPatternAnyMeta(id));
                    }
                    int meta = Integer.parseInt(parser.required(2, "integer expected").getValue());
                    parser.required(37, "> expected");
                    return new TweakerExpressionItemIdMeta(file, line, offset, id, meta);
                }
                parser.required(37, "> expected");
                return new TweakerExpressionItemId(file, line, offset, id);
            }
            case 7: {
                parser.next();
                if (parser.optional(8) != null) {
                    return new TweakerExpressionArray(file, line, offset, new TweakerExpression[0]);
                }
                ArrayList<TweakerExpression> contents = new ArrayList<TweakerExpression>();
                while (parser.optional(8) == null) {
                    contents.add(TweakerExpression.readAssignExpression(file, parser));
                    if (parser.optional(11) != null) continue;
                    parser.required(8, "] or , expected");
                    break;
                }
                return new TweakerExpressionArray(file, line, offset, contents.toArray(new TweakerExpression[contents.size()]));
            }
            case 5: {
                parser.next();
                if (parser.optional(6) != null) {
                    return new TweakerExpressionTable(file, line, offset, new TweakerExpression[0], new TweakerExpression[0]);
                }
                ArrayList<TweakerExpression> keys = new ArrayList<TweakerExpression>();
                ArrayList<TweakerExpression> values = new ArrayList<TweakerExpression>();
                while (parser.optional(6) == null) {
                    keys.add(TweakerExpression.readAssignExpression(file, parser));
                    parser.required(29, ": expected");
                    values.add(TweakerExpression.readAssignExpression(file, parser));
                    if (parser.optional(11) != null) continue;
                    parser.required(6, "} or , expected");
                    break;
                }
                return new TweakerExpressionTable(file, line, offset, keys.toArray(new TweakerExpression[keys.size()]), values.toArray(new TweakerExpression[values.size()]));
            }
            case 141: {
                parser.next();
                return new TweakerExpressionConstant(file, line, offset, TweakerBool.TRUE);
            }
            case 142: {
                parser.next();
                return new TweakerExpressionConstant(file, line, offset, TweakerBool.FALSE);
            }
            case 140: {
                parser.next();
                return new TweakerExpressionConstant(file, line, offset, null);
            }
            case 30: {
                parser.next();
                TweakerExpression result = TweakerExpression.readAssignExpression(file, parser);
                parser.required(31, ") expected");
                return result;
            }
        }
        Token last = parser.next();
        throw new ParseException(last, "Invalid expression, last token: " + last.getValue());
    }

    public TweakerExpression(TweakerFile file, int line, int offset) {
        this.file = file;
        this.line = line;
        this.offset = offset;
    }

    public TweakerFile getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public TweakerValue execute(TweakerNameSpace namespace) {
        try {
            return this.executeInner(namespace);
        }
        catch (TweakerExecuteException ex) {
            throw new TweakerException(this.file, this.line, this.offset, ex.getMessage());
        }
    }

    public abstract TweakerValue executeInner(TweakerNameSpace var1);

    public TweakerExpression assign(TweakerFile file, int line, int offset, TweakerExpression src) {
        return new TweakerExpressionAssign(file, line, offset, this, src);
    }

    public void assign(TweakerNameSpace namespace, TweakerValue value) {
        throw new TweakerException(this.file, this.line, this.offset, "Not an lvalue");
    }
}

