/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.script.statements;

import java.util.ArrayList;
import stanhebben.minetweaker.api.TweakerException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.script.TweakerFile;
import stanhebben.minetweaker.script.TweakerParser;
import stanhebben.minetweaker.script.expressions.TweakerExpression;
import stanhebben.minetweaker.script.parser.Token;
import stanhebben.minetweaker.script.statements.StatementBlock;
import stanhebben.minetweaker.script.statements.StatementExpression;
import stanhebben.minetweaker.script.statements.StatementForeach;
import stanhebben.minetweaker.script.statements.StatementIf;
import stanhebben.minetweaker.script.statements.StatementInclude;
import stanhebben.minetweaker.script.statements.StatementReturn;
import stanhebben.minetweaker.script.statements.StatementVersion;

public abstract class TweakerStatement {
    private TweakerFile file;
    private int line;
    private int offset;

    public static TweakerStatement read(TweakerFile file, TweakerParser parser) {
        Token next = parser.peek();
        switch (next.getType()) {
            case 5: {
                Token t = parser.next();
                ArrayList<TweakerStatement> statements = new ArrayList<TweakerStatement>();
                while (parser.optional(6) == null) {
                    statements.add(TweakerStatement.read(file, parser));
                }
                return new StatementBlock(file, t.getLine(), t.getLineOffset(), statements);
            }
            case 125: {
                parser.next();
                TweakerExpression expression = TweakerExpression.read(file, parser);
                parser.required(33, "; expected");
                return new StatementReturn(file, next.getLine(), next.getLineOffset(), expression);
            }
            case 122: {
                Token t = parser.next();
                TweakerExpression expression = TweakerExpression.read(file, parser);
                TweakerStatement onIf = TweakerStatement.read(file, parser);
                TweakerStatement onElse = null;
                if (parser.optional(123) != null) {
                    onElse = TweakerStatement.read(file, parser);
                }
                return new StatementIf(file, t.getLine(), t.getLineOffset(), expression, onIf, onElse);
            }
            case 124: {
                Token t = parser.next();
                String name = parser.required(1, "identifier expected").getValue();
                parser.required(29, ": expected");
                TweakerExpression source = TweakerExpression.read(file, parser);
                TweakerStatement content = TweakerStatement.read(file, parser);
                return new StatementForeach(file, t.getLine(), t.getLineOffset(), name, source, content);
            }
            case 121: {
                Token t = parser.next();
                int value = Integer.parseInt(parser.required(2, "integer expected").getValue());
                StatementVersion result = new StatementVersion(file, t.getLine(), t.getLineOffset(), value);
                parser.required(33, "; expected");
                return result;
            }
            case 126: {
                Token t = parser.next();
                TweakerExpression expression = TweakerExpression.read(file, parser);
                parser.required(33, "; expected");
                return new StatementInclude(file, t.getLine(), t.getLineOffset(), expression);
            }
        }
        int line = parser.peek().getLine();
        int offset = parser.peek().getLineOffset();
        TweakerExpression expression = TweakerExpression.read(file, parser);
        parser.required(33, "; expected");
        return new StatementExpression(file, line, offset, expression);
    }

    public TweakerStatement(TweakerFile file, int line, int offset) {
        this.file = file;
        this.line = line;
        this.offset = offset;
    }

    public TweakerFile getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public abstract TweakerValue execute(TweakerNameSpace var1) throws TweakerException;
}

