/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.autopackager;

import cofh.api.energy.TileEnergyHandler;
import cofh.util.InventoryHelper;
import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.tileentity.ISortingMember;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingMemberHandler;
import cpw.mods.fml.common.Optional;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import org.mcupdater.autopackager.AutoPackager;
import org.mcupdater.shared.Position;

@Optional.Interface(iface="com.dynious.refinedrelocation.api.tileentity.ISortingMember", modid="RefinedRelocation")
public class TilePackager
extends TileEnergyHandler
implements ISortingMember {
    private Object sortingHandler;
    private ForgeDirection orientation;
    private int tickCounter = 0;
    private int tickDelay = AutoPackager.delayCycleNormal;

    public void func_70316_g() {
        super.func_70316_g();
        if (++this.tickCounter >= this.tickDelay) {
            this.tickCounter = 0;
            if (this.storage.getEnergyStored() > AutoPackager.energyPerCycle) {
                if (this.tryCraft()) {
                    this.storage.extractEnergy(AutoPackager.energyPerCycle, false);
                    this.tickDelay = AutoPackager.delayCycleNormal;
                } else {
                    this.tickDelay = AutoPackager.delayCycleIdle;
                }
            }
        }
    }

    private boolean tryCraft() {
        if (this.orientation == null) {
            return false;
        }
        Position inputPos = new Position(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.orientation);
        Position outputPos = new Position(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.orientation);
        inputPos.moveLeft(1.0);
        outputPos.moveRight(1.0);
        TileEntity tileInput = this.field_70331_k.func_72796_p((int)inputPos.x, (int)inputPos.y, (int)inputPos.z);
        TileEntity tileOutput = this.field_70331_k.func_72796_p((int)outputPos.x, (int)outputPos.y, (int)outputPos.z);
        HashMap slotMap = new HashMap();
        if (tileInput instanceof IInventory && tileOutput instanceof IInventory) {
            IInventory invInput = (IInventory)tileInput;
            IInventory invOutput = (IInventory)tileOutput;
            for (int slot = 0; slot < invInput.func_70302_i_(); ++slot) {
                ItemStack result;
                ItemStack testStack;
                if (invInput.func_70301_a(slot) == null) continue;
                if (slotMap.containsKey(invInput.func_70301_a(slot).func_77973_b())) {
                    ((SortedSet)slotMap.get(invInput.func_70301_a(slot).func_77973_b())).add(slot);
                } else {
                    TreeSet<Integer> slotList = new TreeSet<Integer>();
                    slotList.add(slot);
                    slotMap.put(invInput.func_70301_a(slot).func_77973_b(), slotList);
                }
                if (invInput.func_70301_a((int)slot).field_77994_a >= 4) {
                    testStack = invInput.func_70301_a(slot).func_77946_l();
                    testStack.field_77994_a = 1;
                    InventoryCrafting smallCraft = new InventoryCrafting(new Container(){

                        public boolean func_75145_c(EntityPlayer entityPlayer) {
                            return false;
                        }
                    }, 2, 2);
                    for (int craftSlot = 0; craftSlot < 4; ++craftSlot) {
                        smallCraft.func_70299_a(craftSlot, testStack);
                    }
                    result = CraftingManager.func_77594_a().func_82787_a(smallCraft, this.field_70331_k);
                    if (result != null && (testStack = InventoryHelper.simulateInsertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1)) == null) {
                        invInput.func_70298_a(slot, 4);
                        InventoryHelper.insertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1);
                        return true;
                    }
                }
                if (invInput.func_70301_a((int)slot).field_77994_a < 9) continue;
                testStack = invInput.func_70301_a(slot).func_77946_l();
                testStack.field_77994_a = 1;
                InventoryCrafting largeCraft = new InventoryCrafting(new Container(){

                    public boolean func_75145_c(EntityPlayer entityPlayer) {
                        return false;
                    }
                }, 3, 3);
                for (int craftSlot = 0; craftSlot < 9; ++craftSlot) {
                    largeCraft.func_70299_a(craftSlot, testStack);
                }
                result = CraftingManager.func_77594_a().func_82787_a(largeCraft, this.field_70331_k);
                if (result == null || (testStack = InventoryHelper.simulateInsertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1)) != null) continue;
                invInput.func_70298_a(slot, 9);
                InventoryHelper.insertItemStackIntoInventory((IInventory)invOutput, (ItemStack)result, (int)1);
                return true;
            }
            for (Map.Entry entry : slotMap.entrySet()) {
                if (((SortedSet)entry.getValue()).size() <= 1) continue;
                SortedSet slots = (SortedSet)entry.getValue();
                while (slots.size() > 1) {
                    if (invInput.func_70301_a(((Integer)slots.first()).intValue()) == null || !invInput.func_70301_a(((Integer)slots.first()).intValue()).func_77973_b().equals(entry.getKey()) || invInput.func_70301_a((int)((Integer)slots.first()).intValue()).field_77994_a >= invInput.func_70301_a(((Integer)slots.first()).intValue()).func_77976_d()) {
                        slots.remove(slots.first());
                        continue;
                    }
                    if (invInput.func_70301_a(((Integer)slots.last()).intValue()) == null || !invInput.func_70301_a(((Integer)slots.last()).intValue()).func_77973_b().equals(entry.getKey())) {
                        slots.remove(slots.last());
                        continue;
                    }
                    if (invInput.func_70301_a((int)((Integer)slots.first()).intValue()).field_77994_a + invInput.func_70301_a((int)((Integer)slots.last()).intValue()).field_77994_a <= invInput.func_70301_a(((Integer)slots.first()).intValue()).func_77976_d()) {
                        invInput.func_70301_a((int)((Integer)slots.first()).intValue()).field_77994_a += invInput.func_70301_a((int)((Integer)slots.last()).intValue()).field_77994_a;
                        invInput.func_70299_a(((Integer)slots.last()).intValue(), null);
                        continue;
                    }
                    int spaceRemain = invInput.func_70301_a(((Integer)slots.first()).intValue()).func_77976_d() - invInput.func_70301_a((int)((Integer)slots.first()).intValue()).field_77994_a;
                    invInput.func_70301_a((int)((Integer)slots.first()).intValue()).field_77994_a += spaceRemain;
                    invInput.func_70298_a(((Integer)slots.last()).intValue(), spaceRemain);
                }
            }
        }
        return false;
    }

    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        tagCompound.func_74768_a("orientation", this.orientation.ordinal());
    }

    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        this.orientation = ForgeDirection.getOrientation((int)tagCompound.func_74762_e("orientation"));
    }

    public void setOrientation(ForgeDirection orientation) {
        this.orientation = orientation;
    }

    @Optional.Method(modid="RefinedRelocation")
    public ISortingMemberHandler getSortingHandler() {
        if (this.sortingHandler == null) {
            this.sortingHandler = APIUtils.createSortingMemberHandler((TileEntity)this);
        }
        return (ISortingMemberHandler)this.sortingHandler;
    }
}

