/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import net.minecraft.client.Minecraft;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentTab;

public class GuiComponentTabs
extends BaseComponent {
    protected GuiComponentTab activeTab;

    public GuiComponentTabs(int x, int y) {
        super(x, y);
    }

    @Override
    public BaseComponent addComponent(BaseComponent component) {
        super.addComponent(component);
        if (component instanceof GuiComponentTab) {
            ((GuiComponentTab)component).setContainer(this);
        }
        return this;
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.render(minecraft, offsetX, offsetY, mouseX, mouseY);
        int oY = 0;
        for (BaseComponent component : this.components) {
            if (!(component instanceof GuiComponentTab)) continue;
            component.setY(oY);
            oY += ((GuiComponentTab)component).getHeight() - 1;
        }
    }

    public void onTabClicked(GuiComponentTab tab) {
        if (tab != this.activeTab) {
            if (this.activeTab != null) {
                this.activeTab.setActive(false);
            }
            tab.setActive(true);
            this.activeTab = tab;
        } else {
            tab.setActive(false);
            this.activeTab = null;
        }
    }

    @Override
    public int getWidth() {
        int maxWidth = 0;
        for (BaseComponent component : this.components) {
            if (component.getX() + component.getWidth() <= maxWidth) continue;
            maxWidth = component.getX() + component.getWidth();
        }
        return maxWidth;
    }

    @Override
    public int getHeight() {
        int maxHeight = 0;
        for (BaseComponent component : this.components) {
            if (component.getY() + component.getHeight() <= maxHeight) continue;
            maxHeight = component.getY() + component.getHeight();
        }
        return maxHeight;
    }
}

