/*
 * Decompiled with CFR 0.152.
 */
package openmods.network;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.WorldServer;
import openmods.Log;
import openmods.OpenMods;
import openmods.network.EventPacketManager;

public class PacketHandler
implements IPacketHandler {
    public static final String CHANNEL_SYNC = "OpenMods|S";
    public static final String CHANNEL_EVENTS = "OpenMods|E";
    private static Field trackingPlayers;

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        try {
            if (packet.field_73630_a.equals(CHANNEL_SYNC)) {
                OpenMods.syncableManager.handlePacket(packet);
            } else if (packet.field_73630_a.equals(CHANNEL_EVENTS)) {
                EventPacketManager.handlePacket(packet, manager, player);
            }
        }
        catch (Exception e) {
            Log.warn(e, "Error while handling data on channel %s from player '%s'", packet.field_73630_a, player);
        }
    }

    public static Set<EntityPlayer> getPlayersWatchingChunk(WorldServer world, int chunkX, int chunkZ) {
        PlayerManager manager = world.func_73040_p();
        HashSet playerList = Sets.newHashSet();
        for (Object o : world.field_73010_i) {
            EntityPlayerMP player = (EntityPlayerMP)o;
            if (!manager.func_72694_a(player, chunkX, chunkZ)) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public static Set<EntityPlayer> getPlayersWatchingBlock(WorldServer world, int blockX, int blockZ) {
        return PacketHandler.getPlayersWatchingChunk(world, blockX >> 4, blockZ >> 4);
    }

    public static Set<EntityPlayer> getPlayersWatchingEntity(WorldServer server, int entityId) {
        IntHashMap trackers;
        EntityTracker tracker = server.func_73039_n();
        if (trackingPlayers == null) {
            trackingPlayers = ReflectionHelper.findField(EntityTracker.class, (String[])new String[]{"trackedEntityIDs", "field_72794_c"});
        }
        try {
            trackers = (IntHashMap)trackingPlayers.get(tracker);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        EntityTrackerEntry entry = (EntityTrackerEntry)trackers.func_76041_a(entityId);
        if (entry == null) {
            return ImmutableSet.of();
        }
        Set trackingPlayers = entry.field_73134_o;
        return ImmutableSet.copyOf((Collection)trackingPlayers);
    }
}

