/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.events;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import openmods.network.EventPacket;
import openmods.network.IEventPacketType;
import openmods.network.PacketHandler;
import openmods.tileentity.OpenTileEntity;

public class TileEntityMessageEventPacket
extends EventPacket {
    public int xCoord;
    public int yCoord;
    public int zCoord;

    public TileEntityMessageEventPacket() {
    }

    public TileEntityMessageEventPacket(OpenTileEntity tile) {
        this.xCoord = tile.field_70329_l;
        this.yCoord = tile.field_70330_m;
        this.zCoord = tile.field_70327_n;
    }

    @Override
    protected final void readFromStream(DataInput input) throws IOException {
        this.xCoord = input.readInt();
        this.yCoord = input.readInt();
        this.zCoord = input.readInt();
        this.readPayload(input);
    }

    protected void readPayload(DataInput input) {
    }

    @Override
    protected final void writeToStream(DataOutput output) throws IOException {
        output.writeInt(this.xCoord);
        output.writeInt(this.yCoord);
        output.writeInt(this.zCoord);
        this.writePayload(output);
    }

    protected void writePayload(DataOutput output) {
    }

    @Override
    protected void appendLogInfo(List<String> info) {
        info.add(String.format("%d,%d,%d", this.xCoord, this.yCoord, this.zCoord));
    }

    protected World getWorld() {
        return ((EntityPlayer)this.player).field_70170_p;
    }

    public OpenTileEntity getTileEntity() {
        World world = this.getWorld();
        Preconditions.checkNotNull((Object)world, (Object)"Invalid packet data");
        TileEntity te = world.func_72796_p(this.xCoord, this.yCoord, this.zCoord);
        return te instanceof OpenTileEntity ? (OpenTileEntity)te : null;
    }

    public void sendToWatchers(WorldServer world) {
        this.sendToPlayers(PacketHandler.getPlayersWatchingBlock(world, this.xCoord, this.zCoord));
    }

    @Override
    public IEventPacketType getType() {
        return EventPacket.CoreEventTypes.TILE_ENTITY_NOTIFY;
    }
}

