/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.MapMaker;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import openblocks.common.entity.EntityMagnet;

public class CraneRegistry {
    private static final double MIN_LENGTH = 0.25;
    private static final double MAX_LENGTH = 10.0;
    private static final double LENGTH_DELTA = 0.1;
    private Map<EntityPlayer, Data> itemData = new MapMaker().weakKeys().makeMap();
    private Map<EntityPlayer, EntityMagnet> playersMagnets = new MapMaker().weakKeys().weakValues().makeMap();
    public static final double ARM_RADIUS = 2.0;
    public static final CraneRegistry instance = new CraneRegistry();

    public void ensureMagnetExists(EntityPlayer player) {
        EntityMagnet magnet = this.playersMagnets.get(player);
        if (magnet == null || magnet.field_70128_L) {
            CraneRegistry.createMagnetForPlayer(player);
        } else if (!magnet.isValid()) {
            magnet.func_70106_y();
            CraneRegistry.createMagnetForPlayer(player);
        }
    }

    private static EntityMagnet createMagnetForPlayer(EntityPlayer player) {
        EntityMagnet.PlayerBound result = new EntityMagnet.PlayerBound(player.field_70170_p, player);
        player.field_70170_p.func_72838_d((Entity)result);
        return result;
    }

    public EntityMagnet getMagnetForPlayer(EntityPlayer player) {
        return this.playersMagnets.get(player);
    }

    public void bindMagnetToPlayer(Entity owner, EntityMagnet magnet) {
        if (owner instanceof EntityPlayer) {
            this.playersMagnets.put((EntityPlayer)owner, magnet);
        }
    }

    private CraneRegistry() {
    }

    public Data getData(EntityPlayer player, boolean canCreate) {
        Data result = this.itemData.get(player);
        if (result == null && canCreate) {
            result = new Data(player);
            this.itemData.put(player, result);
        }
        return result;
    }

    public double getCraneMagnetDistance(EntityPlayer player) {
        Data data = this.getData(player, false);
        return data != null ? data.length : 0.25;
    }

    public static class Data {
        public boolean isDetected;
        public boolean isExtending;
        public double length = 0.25;
        public float prevYaw;
        public double prevPosX;
        public double prevPosY;
        public double prevPosZ;

        private Data(EntityPlayer player) {
            this.prevYaw = player.field_70177_z;
            this.prevPosX = player.field_70165_t;
            this.prevPosY = player.field_70163_u;
            this.prevPosZ = player.field_70161_v;
        }

        public void updateLength() {
            if (this.isExtending && this.length < 10.0) {
                this.length += 0.1;
            } else if (!this.isExtending && this.length > 0.25) {
                this.length -= 0.1;
            }
        }
    }
}

