/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.tileentity.TileEntityRecordPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import openmods.utils.ITester;
import openmods.utils.ObjectTester;

public class MagnetWhitelists {
    public static final MagnetWhitelists instance = new MagnetWhitelists();
    public final ObjectTester<Entity> entityWhitelist = ObjectTester.create();
    public final ObjectTester<Block> blockWhitelist = ObjectTester.create();
    public final ObjectTester<TileEntity> tileEntityWhitelist = ObjectTester.create();

    private MagnetWhitelists() {
    }

    public void initTesters() {
        this.entityWhitelist.addTester((ITester)new ObjectTester.ClassTester(EntityItem.class));
        this.entityWhitelist.addTester((ITester)new ObjectTester.ClassTester(EntityBoat.class));
        this.entityWhitelist.addTester((ITester)new ObjectTester.ClassTester(EntityMinecart.class));
        MinecraftForge.EVENT_BUS.post((Event)new EntityRegisterEvent(this.entityWhitelist));
        this.blockWhitelist.addTester((ITester)new ITester<Block>(){

            public ITester.Result test(Block o) {
                return o.field_71989_cb < 0.0f ? ITester.Result.REJECT : ITester.Result.CONTINUE;
            }
        });
        this.blockWhitelist.addTester((ITester)new ITester<Block>(){

            public ITester.Result test(Block o) {
                return o.func_71857_b() == 0 ? ITester.Result.ACCEPT : ITester.Result.CONTINUE;
            }
        });
        this.blockWhitelist.addTester((ITester)new ObjectTester.ClassTester(BlockSand.class));
        this.blockWhitelist.addTester((ITester)new ObjectTester.ClassTester(BlockStairs.class));
        this.blockWhitelist.addTester((ITester)new ObjectTester.ClassTester(BlockFence.class));
        this.blockWhitelist.addTester((ITester)new ObjectTester.ClassTester(BlockFenceGate.class));
        this.blockWhitelist.addTester((ITester)new ObjectTester.ClassTester(BlockCactus.class));
        MinecraftForge.EVENT_BUS.post((Event)new BlockRegisterEvent(this.blockWhitelist));
        this.tileEntityWhitelist.addTester((ITester)new ObjectTester.ClassTester(TileEntityBeacon.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityBrewingStand.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityChest.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityCommandBlock.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityDispenser.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityEnchantmentTable.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityEnderChest.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityFurnace.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityHopper.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityNote.class)).addTester((ITester)new ObjectTester.ClassTester(TileEntityRecordPlayer.class));
    }

    public boolean testBlock(World world, int x, int y, int z) {
        int blockId = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[blockId];
        if (block == null) {
            return false;
        }
        if (block instanceof BlockContainer) {
            TileEntity te = world.func_72796_p(x, y, z);
            return te != null ? this.tileEntityWhitelist.check((Object)te) : false;
        }
        return this.blockWhitelist.check((Object)block);
    }

    public static class TileEntityRegisterEvent
    extends WhitelistRegisterEvent<TileEntity> {
        protected TileEntityRegisterEvent(ObjectTester<TileEntity> tester) {
            super(tester);
        }
    }

    public static class BlockRegisterEvent
    extends WhitelistRegisterEvent<Block> {
        protected BlockRegisterEvent(ObjectTester<Block> tester) {
            super(tester);
        }
    }

    public static class EntityRegisterEvent
    extends WhitelistRegisterEvent<Entity> {
        protected EntityRegisterEvent(ObjectTester<Entity> tester) {
            super(tester);
        }
    }

    public static class WhitelistRegisterEvent<T>
    extends Event {
        protected final ObjectTester<T> tester;

        protected WhitelistRegisterEvent(ObjectTester<T> tester) {
            this.tester = tester;
        }

        public void addClass(Class<? extends T> cls) {
            this.tester.addTester((ITester)new ObjectTester.ClassTester(cls));
        }

        public void addClassNames(Class<? extends T> ... cls) {
            this.tester.addTester((ITester)new ObjectTester.ClassNameTester().addClasses((Class[])cls));
        }

        public void addClassNames(String ... names) {
            this.tester.addTester((ITester)new ObjectTester.ClassNameTester().addClasses(names));
        }
    }
}

