/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityBigButton;
import openmods.block.OpenBlock;

public class BlockBigButton
extends OpenBlock {
    public BlockBigButton() {
        super(Config.blockBigButton, Material.field_76265_p);
        this.setRotationMode(OpenBlock.BlockRotationMode.FOUR_DIRECTIONS);
        this.setPlacementMode(OpenBlock.BlockPlacementMode.SURFACE);
    }

    public boolean shouldRenderBlock() {
        return true;
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return side != ForgeDirection.UP && side != ForgeDirection.DOWN && BlockBigButton.isNeighborBlockSolid((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71924_d(IBlockAccess world, int x, int y, int z, int side) {
        return false;
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        TileEntityBigButton tile = (TileEntityBigButton)((Object)BlockBigButton.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityBigButton.class));
        if (tile == null) {
            return;
        }
        ForgeDirection direction = tile.getRotation();
        boolean pressed = tile.isButtonActive();
        switch (direction) {
            case EAST: {
                this.func_71905_a(pressed ? 0.9375f : 0.875f, 0.0625f, 0.0625f, 1.0f, 0.9375f, 0.9375f);
                break;
            }
            case WEST: {
                this.func_71905_a(0.0f, 0.0625f, 0.0625f, pressed ? 0.0625f : 0.125f, 0.9375f, 0.9375f);
                break;
            }
            case NORTH: {
                this.func_71905_a(0.0625f, 0.0625f, 0.0f, 0.9375f, 0.9375f, pressed ? 0.0625f : 0.125f);
                break;
            }
            case SOUTH: {
                this.func_71905_a(0.0625f, 0.0625f, pressed ? 0.9375f : 0.875f, 0.9375f, 0.9375f, 1.0f);
                break;
            }
            default: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public void func_71919_f() {
        this.func_71905_a(0.0625f, 0.0625f, 0.4f, 0.9375f, 0.9375f, 0.525f);
    }

    public boolean func_71853_i() {
        return true;
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityBigButton te = (TileEntityBigButton)((Object)BlockBigButton.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityBigButton.class));
        return te != null && te.isButtonActive() ? 15 : 0;
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityBigButton button;
        ForgeDirection direction = ForgeDirection.getOrientation((int)side).getOpposite();
        return direction == (button = (TileEntityBigButton)((Object)BlockBigButton.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityBigButton.class))).getRotation() && button.isButtonActive() ? 15 : 0;
    }

    public boolean canRotateWithTool() {
        return false;
    }
}

