/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.block.BlockCanvas;
import openblocks.common.tileentity.TileEntityCanvas;
import openmods.utils.BlockUtils;
import openmods.utils.ItemUtils;
import openmods.utils.render.PaintUtils;

public class ItemWallpaper
extends Item {
    public ItemWallpaper() {
        super(Config.itemWallpaperId);
        this.func_77627_a(true);
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 0;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    public Icon func_77650_f(ItemStack stack) {
        BlockSideTexture texture = BlockSideTexture.fromItemStack(stack);
        if (texture != null) {
            return texture.getIcon();
        }
        return OpenBlocks.Blocks.canvas.wallpaper;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        BlockSideTexture texture = BlockSideTexture.fromItemStack(stack);
        if (texture != null) {
            list.add(texture.getTranslatedSide());
            list.add(texture.getBlockName());
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        int hitSide = side;
        TileEntity te = world.func_72796_p(x, y, z);
        boolean canReplaceBlock = PaintUtils.instance.isAllowedToReplace(world, x, y, z);
        if (canReplaceBlock || te instanceof TileEntityCanvas) {
            BlockSideTexture texture = BlockSideTexture.fromItemStack(stack);
            if (texture != null) {
                if (canReplaceBlock) {
                    BlockCanvas.replaceBlock(world, x, y, z);
                }
                if ((te = world.func_72796_p(x, y, z)) instanceof TileEntityCanvas) {
                    --stack.field_77994_a;
                }
            } else if (!world.field_72995_K) {
                int blockId = world.func_72798_a(x, y, z);
                int meta = world.func_72805_g(x, y, z);
                if (te instanceof TileEntityCanvas) {
                    TileEntityCanvas canvas = (TileEntityCanvas)te;
                    canvas.getLayersForSide(side);
                    if (blockId == 0) {
                        blockId = canvas.paintedBlockId.getValue();
                        meta = canvas.paintedBlockMeta.getValue();
                        side = hitSide;
                    }
                }
                texture = new BlockSideTexture(blockId, meta, side);
                ItemStack cloneStack = stack.func_77946_l();
                cloneStack.field_77994_a = 1;
                texture.writeToStack(cloneStack);
                if (player == null || !player.field_71071_by.func_70441_a(cloneStack)) {
                    BlockUtils.dropItemStackInWorld((World)world, (double)(hitX + (float)x), (double)y, (double)z, (ItemStack)cloneStack);
                } else if (player instanceof EntityPlayerMP) {
                    MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                    server.func_71203_ab().func_72385_f((EntityPlayerMP)player);
                }
                --stack.field_77994_a;
            }
        }
        return true;
    }

    public static class BlockSideTexture {
        public static final String TAG_BLOCK_ID = "blockId";
        public static final String TAG_BLOCK_META = "blockMeta";
        public static final String TAG_BLOCK_SIDE = "blockSide";
        private int blockId;
        private int blockMeta;
        private int blockSide;

        public BlockSideTexture(int id, int meta, int side) {
            this.blockId = id;
            this.blockMeta = meta;
            this.blockSide = side;
        }

        public Icon getIcon() {
            Block block = this.getBlock();
            if (block != null) {
                return block.func_71858_a(this.blockSide, this.blockMeta);
            }
            return null;
        }

        public Block getBlock() {
            return Block.field_71973_m[this.blockId];
        }

        public static BlockSideTexture fromItemStack(ItemStack stack) {
            NBTTagCompound tag;
            if (stack.func_77942_o() && (tag = ItemUtils.getItemTag((ItemStack)stack)).func_74764_b(TAG_BLOCK_ID) && tag.func_74764_b(TAG_BLOCK_META) && tag.func_74764_b(TAG_BLOCK_SIDE)) {
                return new BlockSideTexture(tag.func_74762_e(TAG_BLOCK_ID), tag.func_74762_e(TAG_BLOCK_META), tag.func_74762_e(TAG_BLOCK_SIDE));
            }
            return null;
        }

        public void writeToStack(ItemStack stack) {
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
            tag.func_74768_a(TAG_BLOCK_ID, this.blockId);
            tag.func_74768_a(TAG_BLOCK_META, this.blockMeta);
            tag.func_74768_a(TAG_BLOCK_SIDE, this.blockSide);
        }

        public int getBlockId() {
            return this.blockId;
        }

        public int getBlockMeta() {
            return this.blockMeta;
        }

        public int getBlockSide() {
            return this.blockSide;
        }

        public String getTranslatedSide() {
            return StatCollector.func_74838_a((String)("openblocks.misc.side." + ForgeDirection.getOrientation((int)this.blockSide).name().toLowerCase()));
        }

        public String getBlockName() {
            Block block = this.getBlock();
            if (block != null) {
                return block.func_71931_t();
            }
            return "Unknown block";
        }
    }
}

